/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.List;
import com.aoindustries.aoserv.client.email.ListAddress;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;

public final class ListAddressTable
extends CachedTableIntegerKey<ListAddress> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("email_address.domain.domain", true), new AoservTable.OrderBy("email_address.domain.ao_server.hostname", true), new AoservTable.OrderBy("email_address.address", true), new AoservTable.OrderBy("email_list.path", true)};

    ListAddressTable(AoservConnector connector) {
        super(connector, ListAddress.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addEmailListAddress(Address emailAddressObject, List emailListObject) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.EMAIL_LIST_ADDRESSES, emailAddressObject.getPkey(), emailListObject.getPkey()});
    }

    @Override
    public ListAddress get(int pkey) throws IOException, SQLException {
        return (ListAddress)this.getUniqueRow(0, pkey);
    }

    java.util.List<ListAddress> getEmailListAddresses(List list) throws IOException, SQLException {
        return this.getIndexedRows(2, list.getPkey());
    }

    java.util.List<Address> getEmailAddresses(List list) throws IOException, SQLException {
        java.util.List<ListAddress> cached = this.getEmailListAddresses(list);
        int len = cached.size();
        ArrayList<Address> eas = new ArrayList<Address>(len);
        for (int c = 0; c < len; ++c) {
            eas.add(cached.get(c).getEmailAddress());
        }
        return eas;
    }

    ListAddress getEmailListAddress(Address ea, List list) throws IOException, SQLException {
        int pkey = ea.getPkey();
        java.util.List<ListAddress> cached = this.getEmailListAddresses(list);
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            ListAddress ela = cached.get(c);
            if (ela.getEmailAddress_pkey() != pkey) continue;
            return ela;
        }
        return null;
    }

    java.util.List<ListAddress> getEmailListAddresses(Address ea) throws IOException, SQLException {
        return this.getIndexedRows(1, ea.getPkey());
    }

    java.util.List<List> getEmailLists(Address ea) throws IOException, SQLException {
        java.util.List<ListAddress> cached = this.getEmailListAddresses(ea);
        int len = cached.size();
        ArrayList<List> els = new ArrayList<List>(len);
        for (int c = 0; c < len; ++c) {
            els.add(cached.get(c).getEmailList());
        }
        return els;
    }

    java.util.List<ListAddress> getEnabledEmailListAddresses(Address ea) throws IOException, SQLException {
        java.util.List<ListAddress> cached = this.getEmailListAddresses(ea);
        int size = cached.size();
        ArrayList<ListAddress> matches = new ArrayList<ListAddress>(size);
        for (int c = 0; c < size; ++c) {
            ListAddress ela = cached.get(c);
            if (ela.getEmailList().isDisabled()) continue;
            matches.add(ela);
        }
        return matches;
    }

    public java.util.List<ListAddress> getEmailListAddresses(Server ao) throws IOException, SQLException {
        int aoPkey = ao.getPkey();
        java.util.List cached = this.getRows();
        int len = cached.size();
        ArrayList<ListAddress> matches = new ArrayList<ListAddress>(len);
        for (int c = 0; c < len; ++c) {
            ListAddress list = (ListAddress)cached.get(c);
            if (list.getEmailAddress().getDomain().getLinuxServer_host_id() != aoPkey) continue;
            matches.add(list);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_LIST_ADDRESSES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_email_list_address")) {
            if (Aosh.checkMinParamCount("add_email_list_address", args, 3, (PrintWriter)err)) {
                if (args.length % 3 != 1) {
                    err.println("aosh: add_email_list_address: must have multiples of three number of parameters");
                    err.flush();
                } else {
                    for (int c = 1; c < args.length; c += 3) {
                        String addr = args[c];
                        int pos = addr.indexOf(64);
                        if (pos == -1) {
                            err.print("aosh: add_email_list_address: invalid email address: ");
                            err.println(addr);
                            err.flush();
                            continue;
                        }
                        out.println(this.connector.getSimpleClient().addEmailListAddress(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "address"), Aosh.parseUnixPath(args[c + 1], "path"), args[c + 2]));
                        out.flush();
                    }
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_email_list_address")) {
            if (Aosh.checkParamCount("remove_email_list_address", args, 3, (PrintWriter)err)) {
                String addr = args[1];
                int pos = addr.indexOf(64);
                if (pos == -1) {
                    err.print("aosh: remove_email_list_address: invalid email address: ");
                    err.println(addr);
                    err.flush();
                } else {
                    this.connector.getSimpleClient().removeEmailListAddress(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "address"), Aosh.parseUnixPath(args[2], "path"), args[3]);
                }
            }
            return true;
        }
        return false;
    }
}

