/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.List;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;

public final class ListTable
extends CachedTableIntegerKey<List> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("path", true), new AoservTable.OrderBy("linux_server_account.ao_server.hostname", true)};

    ListTable(AoservConnector connector) {
        super(connector, List.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addEmailList(PosixPath path, UserServer lsa, GroupServer lsg) throws IllegalArgumentException, IOException, SQLException {
        Server lsgServer;
        Server lsaServer = lsa.getServer();
        if (!lsaServer.equals(lsgServer = lsg.getServer())) {
            throw new IllegalArgumentException("Mismatched servers: " + lsaServer + " and " + lsgServer);
        }
        if (!List.isValidRegularPath(path, lsaServer.getHost().getOperatingSystemVersion_id())) {
            throw new IllegalArgumentException("Invalid list path: " + path);
        }
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.EMAIL_LISTS, path, lsa.getPkey(), lsg.getPkey()});
    }

    @Override
    public List get(int pkey) throws IOException, SQLException {
        return (List)this.getUniqueRow(0, pkey);
    }

    public java.util.List<List> getEmailLists(Account business) throws IOException, SQLException {
        Account.Name accounting = business.getName();
        java.util.List cached = this.getRows();
        int len = cached.size();
        ArrayList<List> matches = new ArrayList<List>(len);
        for (int c = 0; c < len; ++c) {
            List list = (List)cached.get(c);
            if (!list.getLinuxServerGroup().getLinuxGroup().getPackage().getAccount_name().equals(accounting)) continue;
            matches.add(list);
        }
        return matches;
    }

    public java.util.List<List> getEmailLists(Package pack) throws IOException, SQLException {
        Account.Name packName = pack.getName();
        java.util.List cached = this.getRows();
        int size = cached.size();
        ArrayList<List> matches = new ArrayList<List>(size);
        for (int c = 0; c < size; ++c) {
            List list = (List)cached.get(c);
            if (!list.getLinuxServerGroup().getLinuxGroup().getPackage_name().equals(packName)) continue;
            matches.add(list);
        }
        return matches;
    }

    public java.util.List<List> getEmailLists(UserServer lsa) throws IOException, SQLException {
        return this.getIndexedRows(2, lsa.getPkey());
    }

    public List getEmailList(Server ao, PosixPath path) throws IOException, SQLException {
        int aoPkey = ao.getServer_pkey();
        java.util.List cached = this.getRows();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            List list = (List)cached.get(c);
            if (list.getLinuxServerGroup().getServer_host_id() != aoPkey || !list.getPath().equals(path)) continue;
            return list;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_LISTS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_email_list")) {
            if (Aosh.checkParamCount("add_email_list", args, 4, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addEmailList(args[1], Aosh.parseUnixPath(args[2], "path"), Aosh.parseLinuxUserName(args[3], "username"), Aosh.parseGroupName(args[4], "group")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_email_list_path")) {
            if (Aosh.checkParamCount("check_email_list_path", args, 2, (PrintWriter)err)) {
                try {
                    this.connector.getSimpleClient().checkEmailListPath(args[1], Aosh.parseUnixPath(args[2], "path"));
                    out.print(args[2]);
                    out.print(": ");
                    out.println("true");
                }
                catch (IllegalArgumentException ia) {
                    out.print(args[2]);
                    out.print(": ");
                    out.println(ia.getMessage());
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_email_list")) {
            if (Aosh.checkParamCount("disable_email_list", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableEmailList(Aosh.parseUnixPath(args[1], "path"), args[2], args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_email_list")) {
            if (Aosh.checkParamCount("enable_email_list", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableEmailList(Aosh.parseUnixPath(args[1], "path"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_email_list")) {
            if (Aosh.checkParamCount("get_email_list", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().getEmailListAddressList(Aosh.parseUnixPath(args[1], "path"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_email_list")) {
            if (Aosh.checkParamCount("remove_email_list", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeEmailList(Aosh.parseUnixPath(args[1], "path"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_email_list")) {
            if (Aosh.checkParamCount("set_email_list", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setEmailListAddressList(Aosh.parseUnixPath(args[1], "path"), args[2], args[3]);
            }
            return true;
        }
        return false;
    }
}

