/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.List;
import com.aoindustries.aoserv.client.email.ListAddress;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.email.PipeAddress;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class MajordomoList
extends CachedObjectIntegerKey<MajordomoList> {
    static final int COLUMN_EMAIL_LIST = 0;
    static final int COLUMN_MAJORDOMO_SERVER = 1;
    static final String COLUMN_NAME_name = "name";
    static final String COLUMN_MAJORDOMO_SERVER_name = "majordomo_server";
    public static final int MAX_NAME_LENGTH = 64;
    private int majordomoServer;
    private String name;
    private int listnamePipeAdd;
    private int listnameListAdd;
    private int ownerListnameAdd;
    private int listnameOwnerAdd;
    private int listnameApprovalAdd;
    private int listnameRequestPipeAdd;

    @Deprecated
    public MajordomoList() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.majordomoServer;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.listnamePipeAdd;
            }
            case 4: {
                return this.listnameListAdd;
            }
            case 5: {
                return this.ownerListnameAdd;
            }
            case 6: {
                return this.listnameOwnerAdd;
            }
            case 7: {
                return this.listnameApprovalAdd;
            }
            case 8: {
                return this.listnameRequestPipeAdd;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public static String getDefaultInfoFile(DomainName domain, String listName) {
        return "Information about the " + listName + " mailing list:\n\nHOW TO POST A MESSAGE TO THE LIST:\nJust send an email message to " + listName + "@" + domain + ". The message will\nbe distributed to all the members of the list.\n\nHOW TO UNSUBSCRIBE:\nSend an email message to majordomo@" + domain + " with one line in the\nbody of the message:\n\nunsubscribe " + listName + "\n\n\nFOR QUESTIONS:\nIf you ever need to get in contact with the owner of the list,\n(if you have trouble unsubscribing, or have questions about the\nlist itself) send email to owner-" + listName + '@' + domain + ".\n";
    }

    public String getDefaultInfoFile() throws SQLException, IOException {
        return MajordomoList.getDefaultInfoFile(this.getMajordomoServer().getDomain().getDomain(), this.name);
    }

    public static String getDefaultIntroFile(DomainName domain, String listName) {
        return "Welcome to the " + listName + " mailing list.\n\nPlease save this message for future reference.\n\nHOW TO POST A MESSAGE TO THE LIST:\nJust send an email message to " + listName + '@' + domain + ". The message will\nbe distributed to all the members of the list.\n\nHOW TO UNSUBSCRIBE:\nSend an email message to majordomo@" + domain + " with one line in the\nbody of the message:\n\nunsubscribe " + listName + "\n\n\nFOR QUESTIONS:\nIf you ever need to get in contact with the owner of the list,\n(if you have trouble unsubscribing, or have questions about the\nlist itself) send email to owner-" + listName + '@' + domain + ".\n";
    }

    public String getDefaultIntroFile() throws SQLException, IOException {
        return MajordomoList.getDefaultIntroFile(this.getMajordomoServer().getDomain().getDomain(), this.name);
    }

    public List getEmailList() throws SQLException, IOException {
        List obj = this.table.getConnector().getEmail().getList().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find EmailList: " + this.pkey);
        }
        return obj;
    }

    public String getInfoFile() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_MAJORDOMO_INFO_FILE, this.pkey);
    }

    public String getIntroFile() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_MAJORDOMO_INTRO_FILE, this.pkey);
    }

    public PipeAddress getListPipeAddress() throws SQLException, IOException {
        PipeAddress pipeAddress = this.table.getConnector().getEmail().getPipeAddress().get(this.listnamePipeAdd);
        if (pipeAddress == null) {
            throw new SQLException("Unable to find EmailPipeAddress: " + this.listnamePipeAdd);
        }
        return pipeAddress;
    }

    public int getListApprovalAddress_id() {
        return this.listnameApprovalAdd;
    }

    public Address getListApprovalAddress() throws SQLException, IOException {
        Address address = this.table.getConnector().getEmail().getAddress().get(this.listnameApprovalAdd);
        if (address == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.listnameApprovalAdd);
        }
        return address;
    }

    public ListAddress getListListAddress() throws SQLException, IOException {
        ListAddress listAddress = this.table.getConnector().getEmail().getListAddress().get(this.listnameListAdd);
        if (listAddress == null) {
            throw new SQLException("Unable to find EmailListAddress: " + this.listnameListAdd);
        }
        return listAddress;
    }

    public int getListOwnerAddress_id() {
        return this.listnameOwnerAdd;
    }

    public Address getListOwnerAddress() throws SQLException, IOException {
        Address address = this.table.getConnector().getEmail().getAddress().get(this.listnameOwnerAdd);
        if (address == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.listnameOwnerAdd);
        }
        return address;
    }

    public PipeAddress getListRequestPipeAddress() throws SQLException, IOException {
        PipeAddress pipeAddress = this.table.getConnector().getEmail().getPipeAddress().get(this.listnameRequestPipeAdd);
        if (pipeAddress == null) {
            throw new SQLException("Unable to find EmailPipeAddress: " + this.listnameRequestPipeAdd);
        }
        return pipeAddress;
    }

    public String getName() {
        return this.name;
    }

    public int getOwnerListAddress_id() {
        return this.ownerListnameAdd;
    }

    public Address getOwnerListAddress() throws SQLException, IOException {
        Address address = this.table.getConnector().getEmail().getAddress().get(this.ownerListnameAdd);
        if (address == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.ownerListnameAdd);
        }
        return address;
    }

    public int getMajordomoServer_domain_id() {
        return this.majordomoServer;
    }

    public MajordomoServer getMajordomoServer() throws SQLException, IOException {
        MajordomoServer obj = this.table.getConnector().getEmail().getMajordomoServer().get(this.majordomoServer);
        if (obj == null) {
            throw new SQLException("Unable to find MajordomoServer: " + this.majordomoServer);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MAJORDOMO_LISTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.majordomoServer = result.getInt(2);
        this.name = result.getString(3);
        this.listnamePipeAdd = result.getInt(4);
        this.listnameListAdd = result.getInt(5);
        this.ownerListnameAdd = result.getInt(6);
        this.listnameOwnerAdd = result.getInt(7);
        this.listnameApprovalAdd = result.getInt(8);
        this.listnameRequestPipeAdd = result.getInt(9);
    }

    public static boolean isValidListName(String name) {
        int len = name.length();
        if (len < 1 || len > 64) {
            return false;
        }
        for (int c = 0; c < len; ++c) {
            char ch = name.charAt(c);
            if (!(c == 0 ? !(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') : !(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '.' || ch == '-' || ch == '_'))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.majordomoServer = in.readCompressedInt();
        this.name = in.readUTF();
        this.listnamePipeAdd = in.readCompressedInt();
        this.listnameListAdd = in.readCompressedInt();
        this.ownerListnameAdd = in.readCompressedInt();
        this.listnameOwnerAdd = in.readCompressedInt();
        this.listnameApprovalAdd = in.readCompressedInt();
        this.listnameRequestPipeAdd = in.readCompressedInt();
    }

    public void setInfoFile(String file) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_MAJORDOMO_INFO_FILE, this.pkey, file);
    }

    public void setIntroFile(String file) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_MAJORDOMO_INTRO_FILE, this.pkey, file);
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.name + '@' + this.getMajordomoServer().getDomain().getDomain().toString();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.majordomoServer);
        out.writeUTF(this.name);
        out.writeCompressedInt(this.listnamePipeAdd);
        out.writeCompressedInt(this.listnameListAdd);
        out.writeCompressedInt(this.ownerListnameAdd);
        out.writeCompressedInt(this.listnameOwnerAdd);
        out.writeCompressedInt(this.listnameApprovalAdd);
        out.writeCompressedInt(this.listnameRequestPipeAdd);
    }
}

