/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.SimpleAoservClient;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.MajordomoList;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class MajordomoListTable
extends CachedTableIntegerKey<MajordomoList> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("majordomo_server.domain.domain", true), new AoservTable.OrderBy("majordomo_server.domain.ao_server.hostname", true), new AoservTable.OrderBy("name", true)};

    MajordomoListTable(AoservConnector connector) {
        super(connector, MajordomoList.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addMajordomoList(MajordomoServer majordomoServer, String listName) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.MAJORDOMO_LISTS, majordomoServer.getPkey(), listName});
    }

    @Override
    public MajordomoList get(int pkey) throws IOException, SQLException {
        return (MajordomoList)this.getUniqueRow(0, pkey);
    }

    MajordomoList getMajordomoList(MajordomoServer ms, String listName) throws IOException, SQLException {
        int majordomoServer = ms.getPkey();
        List mls = this.getRows();
        int len = mls.size();
        for (int c = 0; c < len; ++c) {
            MajordomoList ml = (MajordomoList)mls.get(c);
            if (ml.getMajordomoServer_domain_id() != majordomoServer || !ml.getName().equals(listName)) continue;
            return ml;
        }
        return null;
    }

    List<MajordomoList> getMajordomoLists(MajordomoServer server) throws IOException, SQLException {
        return this.getIndexedRows(1, server.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MAJORDOMO_LISTS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_majordomo_list")) {
            if (Aosh.checkParamCount("add_majordomo_list", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addMajordomoList(Aosh.parseDomainName(args[1], "domain"), args[2], args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_majordomo_list_name")) {
            if (Aosh.checkParamCount("check_majordomo_list_name", args, 1, (PrintWriter)err)) {
                try {
                    SimpleAoservClient.checkMajordomoListName(args[1]);
                    out.println("true");
                }
                catch (IllegalArgumentException iae) {
                    out.print("aosh: check_majordomo_list_name: ");
                    out.println(iae.getMessage());
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_majordomo_info_file")) {
            if (Aosh.checkParamCount("get_majordomo_info_file", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().getMajordomoInfoFile(Aosh.parseDomainName(args[1], "domain"), args[2], args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_majordomo_intro_file")) {
            if (Aosh.checkParamCount("get_majordomo_intro_file", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().getMajordomoIntroFile(Aosh.parseDomainName(args[1], "domain"), args[2], args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_majordomo_info_file")) {
            if (Aosh.checkParamCount("set_majordomo_info_file", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().setMajordomoInfoFile(Aosh.parseDomainName(args[1], "domain"), args[2], args[3], args[4]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_majordomo_intro_file")) {
            if (Aosh.checkParamCount("set_majordomo_intro_file", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().setMajordomoIntroFile(Aosh.parseDomainName(args[1], "domain"), args[2], args[3], args[4]);
            }
            return true;
        }
        return false;
    }
}

