/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.MajordomoList;
import com.aoindustries.aoserv.client.email.MajordomoVersion;
import com.aoindustries.aoserv.client.email.PipeAddress;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class MajordomoServer
extends CachedObjectIntegerKey<MajordomoServer>
implements Removable {
    static final int COLUMN_DOMAIN = 0;
    static final String COLUMN_DOMAIN_name = "domain";
    public static final PosixPath MAJORDOMO_SERVER_DIRECTORY;
    public static final String MAJORDOMO_ADDRESS = "majordomo";
    public static final String OWNER_MAJORDOMO_ADDRESS = "owner-majordomo";
    public static final String MAJORDOMO_OWNER_ADDRESS = "majordomo-owner";
    private int linuxServerAccount;
    private int linuxServerGroup;
    private String version;
    private int majordomoPipeAddress;
    private int ownerMajordomoAdd;
    private int majordomoOwnerAdd;

    @Deprecated
    public MajordomoServer() {
    }

    public int addMajordomoList(String listName) throws SQLException, IOException {
        return this.table.getConnector().getEmail().getMajordomoList().addMajordomoList(this, listName);
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.linuxServerAccount;
            }
            case 2: {
                return this.linuxServerGroup;
            }
            case 3: {
                return this.version;
            }
            case 4: {
                return this.majordomoPipeAddress;
            }
            case 5: {
                return this.ownerMajordomoAdd;
            }
            case 6: {
                return this.majordomoOwnerAdd;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Domain getDomain() throws IOException, SQLException {
        Domain obj = this.table.getConnector().getEmail().getDomain().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find EmailDomain: " + this.pkey);
        }
        return obj;
    }

    public int getLinuxServerAccount_pkey() {
        return this.linuxServerAccount;
    }

    public UserServer getLinuxServerAccount() throws SQLException, IOException {
        UserServer obj = this.table.getConnector().getLinux().getUserServer().get(this.linuxServerAccount);
        if (obj == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.linuxServerAccount);
        }
        return obj;
    }

    public int getLinuxServerGroup_pkey() {
        return this.linuxServerGroup;
    }

    public GroupServer getLinuxServerGroup() throws SQLException, IOException {
        GroupServer obj = this.table.getConnector().getLinux().getGroupServer().get(this.linuxServerGroup);
        if (obj == null) {
            throw new SQLException("Unable to find LinuxServerGroup: " + this.linuxServerGroup);
        }
        return obj;
    }

    public PipeAddress getMajordomoPipeAddress() throws SQLException, IOException {
        PipeAddress obj = this.table.getConnector().getEmail().getPipeAddress().get(this.majordomoPipeAddress);
        if (obj == null) {
            throw new SQLException("Unable to find EmailPipeAddress: " + this.majordomoPipeAddress);
        }
        return obj;
    }

    public MajordomoList getMajordomoList(String listName) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getMajordomoList().getMajordomoList(this, listName);
    }

    public List<MajordomoList> getMajordomoLists() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getMajordomoList().getMajordomoLists(this);
    }

    public int getMajordomoOwnerAddress_id() {
        return this.majordomoOwnerAdd;
    }

    public Address getMajordomoOwnerAddress() throws SQLException, IOException {
        Address obj = this.table.getConnector().getEmail().getAddress().get(this.majordomoOwnerAdd);
        if (obj == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.majordomoOwnerAdd);
        }
        return obj;
    }

    public int getOwnerMajordomoAddress_id() {
        return this.ownerMajordomoAdd;
    }

    public Address getOwnerMajordomoAddress() throws SQLException, IOException {
        Address obj = this.table.getConnector().getEmail().getAddress().get(this.ownerMajordomoAdd);
        if (obj == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.ownerMajordomoAdd);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MAJORDOMO_SERVERS;
    }

    public MajordomoVersion getVersion() throws SQLException, IOException {
        MajordomoVersion obj = this.table.getConnector().getEmail().getMajordomoVersion().get(this.version);
        if (obj == null) {
            throw new SQLException("Unable to find MajordomoVersion: " + this.version);
        }
        return obj;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.linuxServerAccount = result.getInt(2);
        this.linuxServerGroup = result.getInt(3);
        this.version = result.getString(4);
        this.majordomoPipeAddress = result.getInt(5);
        this.ownerMajordomoAdd = result.getInt(6);
        this.majordomoOwnerAdd = result.getInt(7);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.linuxServerAccount = in.readCompressedInt();
        this.linuxServerGroup = in.readCompressedInt();
        this.version = in.readUTF().intern();
        this.majordomoPipeAddress = in.readCompressedInt();
        this.ownerMajordomoAdd = in.readCompressedInt();
        this.majordomoOwnerAdd = in.readCompressedInt();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.MAJORDOMO_SERVERS, this.pkey});
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.linuxServerAccount);
        out.writeCompressedInt(this.linuxServerGroup);
        out.writeUTF(this.version);
        out.writeCompressedInt(this.majordomoPipeAddress);
        out.writeCompressedInt(this.ownerMajordomoAdd);
        out.writeCompressedInt(this.majordomoOwnerAdd);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeShort(0);
            out.writeShort(7);
        }
    }

    static {
        try {
            MAJORDOMO_SERVER_DIRECTORY = PosixPath.valueOf("/etc/mail/majordomo");
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
    }
}

