/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.email.MajordomoVersion;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class MajordomoServerTable
extends CachedTableIntegerKey<MajordomoServer> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("domain.domain", true), new AoservTable.OrderBy("domain.ao_server.hostname", true)};

    MajordomoServerTable(AoservConnector connector) {
        super(connector, MajordomoServer.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    void addMajordomoServer(Domain emailDomain, UserServer linuxServerAccount, GroupServer linuxServerGroup, MajordomoVersion majordomoVersion) throws IOException, SQLException {
        this.connector.requestUpdateInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.MAJORDOMO_SERVERS, emailDomain.getPkey(), linuxServerAccount.getPkey(), linuxServerGroup.getPkey(), majordomoVersion.getVersion()});
    }

    @Override
    public MajordomoServer get(int domain) throws IOException, SQLException {
        return (MajordomoServer)this.getUniqueRow(0, domain);
    }

    public List<MajordomoServer> getMajordomoServers(Server ao) throws IOException, SQLException {
        int aoPkey = ao.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<MajordomoServer> matches = new ArrayList<MajordomoServer>(size);
        for (int c = 0; c < size; ++c) {
            MajordomoServer ms = (MajordomoServer)cached.get(c);
            if (ms.getDomain().getLinuxServer_host_id() != aoPkey) continue;
            matches.add(ms);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MAJORDOMO_SERVERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_majordomo_server")) {
            if (Aosh.checkParamCount("add_majordomo_server", args, 5, (PrintWriter)err)) {
                this.connector.getSimpleClient().addMajordomoServer(Aosh.parseDomainName(args[1], "domain"), args[2], Aosh.parseLinuxUserName(args[3], "linux_account"), Aosh.parseGroupName(args[4], "linux_group"), args[5]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_majordomo_server")) {
            if (Aosh.checkParamCount("remove_majordomo_server", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeMajordomoServer(Aosh.parseDomainName(args[1], "domain"), args[2]);
            }
            return true;
        }
        return false;
    }
}

