/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class Pipe
extends CachedObjectIntegerKey<Pipe>
implements Removable,
Disablable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_AO_SERVER = 1;
    static final int COLUMN_PACKAGE = 3;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_COMMAND_name = "command";
    private int aoServer;
    private String command;
    private Account.Name packageName;
    private int disableLog;

    @Deprecated
    public Pipe() {
    }

    public int addEmailAddress(Address address) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getPipeAddress().addEmailPipeAddress(address, this);
    }

    @Override
    public boolean canDisable() {
        return this.disableLog == -1;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getPackage().isDisabled();
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.EMAIL_PIPES, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.EMAIL_PIPES, this.pkey});
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.aoServer;
            }
            case 2: {
                return this.command;
            }
            case 3: {
                return this.packageName;
            }
            case 4: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public Package getPackage() throws IOException, SQLException {
        Package packageObject = this.table.getConnector().getBilling().getPackage().get(this.packageName);
        if (packageObject == null) {
            throw new SQLException("Unable to find Package: " + this.packageName);
        }
        return packageObject;
    }

    public String getCommand() {
        return this.command;
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_PIPES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.aoServer = result.getInt(2);
            this.command = result.getString(3);
            this.packageName = Account.Name.valueOf(result.getString(4));
            this.disableLog = result.getInt(5);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.aoServer = in.readCompressedInt();
            this.command = in.readUTF();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
            this.disableLog = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.EMAIL_PIPES, this.pkey});
    }

    @Override
    public String toStringImpl() {
        return this.aoServer + ":" + this.command;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.aoServer);
        out.writeUTF(this.command);
        out.writeUTF(this.packageName.toString());
        out.writeCompressedInt(this.disableLog);
    }
}

