/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.MajordomoList;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.email.Pipe;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class PipeAddress
extends CachedObjectIntegerKey<PipeAddress>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_EMAIL_ADDRESS = 1;
    static final String COLUMN_EMAIL_ADDRESS_name = "email_address";
    static final String COLUMN_EMAIL_PIPE_name = "email_pipe";
    private int emailAddress;
    private int emailPipe;

    @Deprecated
    public PipeAddress() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.emailAddress;
        }
        if (i == 2) {
            return this.emailPipe;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getEmailAddress_id() {
        return this.emailAddress;
    }

    public Address getEmailAddress() throws SQLException, IOException {
        Address emailAddressObject = this.table.getConnector().getEmail().getAddress().get(this.emailAddress);
        if (emailAddressObject == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.emailAddress);
        }
        return emailAddressObject;
    }

    public int getEmailPipe_id() {
        return this.emailPipe;
    }

    public Pipe getEmailPipe() throws SQLException, IOException {
        Pipe emailPipeObject = this.table.getConnector().getEmail().getPipe().get(this.emailPipe);
        if (emailPipeObject == null) {
            throw new SQLException("Unable to find EmailPipe: " + this.emailPipe);
        }
        return emailPipeObject;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_PIPE_ADDRESSES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.emailAddress = result.getInt(2);
        this.emailPipe = result.getInt(3);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.emailAddress = in.readCompressedInt();
        this.emailPipe = in.readCompressedInt();
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        Domain ed;
        ArrayList reasons = new ArrayList();
        for (MajordomoList ml : this.table.getConnector().getEmail().getMajordomoList().getRows()) {
            if (ml.getListPipeAddress().getPkey() != this.pkey && ml.getListRequestPipeAddress().getPkey() != this.pkey) continue;
            ed = ml.getMajordomoServer().getDomain();
            reasons.add(new CannotRemoveReason<MajordomoList>("Used by Majordomo list " + ml.getName() + '@' + ed.getDomain() + " on " + ed.getLinuxServer().getHostname(), ml));
        }
        for (MajordomoServer ms : this.table.getConnector().getEmail().getMajordomoServer().getRows()) {
            if (ms.getMajordomoPipeAddress().getPkey() != this.pkey) continue;
            ed = ms.getDomain();
            reasons.add(new CannotRemoveReason<MajordomoServer>("Used by Majordomo server " + ed.getDomain() + " on " + ed.getLinuxServer().getHostname(), ms));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.EMAIL_PIPE_ADDRESSES, this.pkey});
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getEmailAddress().toStringImpl() + "->" + this.getEmailPipe().getCommand();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.emailAddress);
        out.writeCompressedInt(this.emailPipe);
    }
}

