/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.Pipe;
import com.aoindustries.aoserv.client.email.PipeAddress;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class PipeAddressTable
extends CachedTableIntegerKey<PipeAddress> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("email_address.domain.domain", true), new AoservTable.OrderBy("email_address.domain.ao_server.hostname", true), new AoservTable.OrderBy("email_address.address", true), new AoservTable.OrderBy("email_pipe.command", true)};

    PipeAddressTable(AoservConnector connector) {
        super(connector, PipeAddress.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addEmailPipeAddress(Address emailAddressObject, Pipe emailPipeObject) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.EMAIL_PIPE_ADDRESSES, emailAddressObject.getPkey(), emailPipeObject.getPkey()});
    }

    @Override
    public PipeAddress get(int pkey) throws IOException, SQLException {
        return (PipeAddress)this.getUniqueRow(0, pkey);
    }

    List<Pipe> getEmailPipes(Address address) throws IOException, SQLException {
        int address_id = address.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<Pipe> matches = new ArrayList<Pipe>(len);
        for (int c = 0; c < len; ++c) {
            Pipe ep;
            PipeAddress pipe = (PipeAddress)cached.get(c);
            if (pipe.getEmailAddress_id() != address_id || (ep = pipe.getEmailPipe()) == null) continue;
            matches.add(pipe.getEmailPipe());
        }
        return matches;
    }

    List<PipeAddress> getEmailPipeAddresses(Address address) throws IOException, SQLException {
        return this.getIndexedRows(1, address.getPkey());
    }

    List<PipeAddress> getEnabledEmailPipeAddresses(Address address) throws IOException, SQLException {
        List<PipeAddress> cached = this.getEmailPipeAddresses(address);
        int len = cached.size();
        ArrayList<PipeAddress> matches = new ArrayList<PipeAddress>(len);
        for (int c = 0; c < len; ++c) {
            PipeAddress pipe = cached.get(c);
            if (pipe.getEmailPipe().isDisabled()) continue;
            matches.add(pipe);
        }
        return matches;
    }

    PipeAddress getEmailPipeAddress(Address address, Pipe pipe) throws IOException, SQLException {
        int address_id = address.getPkey();
        int pipe_id = pipe.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        for (int c = 0; c < len; ++c) {
            PipeAddress epa = (PipeAddress)cached.get(c);
            if (epa.getEmailAddress_id() != address_id || epa.getEmailPipe_id() != pipe_id) continue;
            return epa;
        }
        return null;
    }

    public List<PipeAddress> getEmailPipeAddresses(Server ao) throws IOException, SQLException {
        int aoPkey = ao.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<PipeAddress> matches = new ArrayList<PipeAddress>(len);
        for (int c = 0; c < len; ++c) {
            PipeAddress pipe = (PipeAddress)cached.get(c);
            if (pipe.getEmailAddress().getDomain().getLinuxServer_host_id() != aoPkey) continue;
            matches.add(pipe);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_PIPE_ADDRESSES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_email_pipe_address")) {
            if (Aosh.checkMinParamCount("add_email_pipe_address", args, 2, (PrintWriter)err)) {
                if ((args.length & 1) == 0) {
                    err.println("aosh: add_email_pipe_address: must have even number of parameters");
                    err.flush();
                } else {
                    for (int c = 1; c < args.length; c += 2) {
                        String addr = args[c];
                        int pos = addr.indexOf(64);
                        if (pos == -1) {
                            err.print("aosh: add_email_pipe_address: invalid email address: ");
                            err.println(addr);
                            err.flush();
                            continue;
                        }
                        out.println(this.connector.getSimpleClient().addEmailPipeAddress(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "address"), Aosh.parseInt(args[c + 1], "pkey")));
                        out.flush();
                    }
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_email_pipe_address")) {
            if (Aosh.checkParamCount("remove_email_pipe_address", args, 2, (PrintWriter)err)) {
                String addr = args[1];
                int pos = addr.indexOf(64);
                if (pos == -1) {
                    err.print("aosh: remove_email_pipe_address: invalid email address: ");
                    err.println(addr);
                    err.flush();
                } else {
                    this.connector.getSimpleClient().removeEmailPipeAddress(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "address"), Aosh.parseInt(args[2], "pkey"));
                }
            }
            return true;
        }
        return false;
    }
}

