/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.Pipe;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class PipeTable
extends CachedTableIntegerKey<Pipe> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("command", true), new AoservTable.OrderBy("ao_server.hostname", true)};

    PipeTable(AoservConnector connector) {
        super(connector, Pipe.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addEmailPipe(Server ao, String command, Package packageObject) throws IOException, SQLException {
        int pkey = this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.EMAIL_PIPES, ao.getPkey(), command, packageObject.getName()});
        return pkey;
    }

    @Override
    public Pipe get(int pkey) throws IOException, SQLException {
        return (Pipe)this.getUniqueRow(0, pkey);
    }

    public List<Pipe> getEmailPipes(Package pack) throws IOException, SQLException {
        return this.getIndexedRows(3, pack.getName());
    }

    public List<Pipe> getEmailPipes(Server ao) throws IOException, SQLException {
        return this.getIndexedRows(1, ao.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_PIPES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_email_pipe")) {
            if (Aosh.checkParamCount("add_email_pipe", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addEmailPipe(args[1], args[2], Aosh.parseAccountingCode(args[3], "package")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_email_pipe")) {
            if (Aosh.checkParamCount("disable_email_pipe", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableEmailPipe(Aosh.parseInt(args[1], "pkey"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_email_pipe")) {
            if (Aosh.checkParamCount("enable_email_pipe", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableEmailPipe(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_email_pipe")) {
            if (Aosh.checkParamCount("remove_email_pipe", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeEmailPipe(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        return false;
    }
}

