/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.email.SendmailServer;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SendmailBind
extends CachedObjectIntegerKey<SendmailBind> {
    static final int COLUMN_NET_BIND = 0;
    static final int COLUMN_SENDMAIL_SERVER = 1;
    static final String COLUMN_NET_BIND_name = "net_bind";
    private int sendmailServer;
    private String name;

    @Deprecated
    public SendmailBind() {
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        SendmailServer server = this.getSendmailServer();
        Bind bind = this.getNetBind();
        return server.toStringImpl() + '|' + bind.toStringImpl();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.sendmailServer;
            }
            case 2: {
                return this.name;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SENDMAIL_BINDS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.sendmailServer = result.getInt(2);
        this.name = result.getString(3);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.sendmailServer = in.readCompressedInt();
        this.name = in.readNullUTF();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.sendmailServer);
        out.writeNullUTF(this.name);
    }

    public Bind getNetBind() throws SQLException, IOException {
        Bind obj = this.table.getConnector().getNet().getBind().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find NetBind: " + this.pkey);
        }
        return obj;
    }

    public SendmailServer getSendmailServer() throws SQLException, IOException {
        SendmailServer obj = this.table.getConnector().getEmail().getSendmailServer().get(this.sendmailServer);
        if (obj == null) {
            throw new SQLException("Unable to find SendmailServer: " + this.sendmailServer);
        }
        return obj;
    }

    public String getName() {
        assert (this.name == null || this.name.indexOf(32) == -1);
        return this.name;
    }
}

