/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.AddressFamily;
import com.aoapps.net.DomainName;
import com.aoapps.net.InetAddress;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.SendmailBind;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.util.SystemdUtil;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public final class SendmailServer
extends CachedObjectIntegerKey<SendmailServer> {
    static final int COLUMN_ID = 0;
    static final int COLUMN_AO_SERVER = 1;
    static final int COLUMN_PACKAGE = 3;
    static final int COLUMN_SERVER_CERTIFICATE = 5;
    static final int COLUMN_CLIENT_CERTIFICATE = 6;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_NAME_name = "name";
    public static final boolean DEFAULT_ALLOW_PLAINTEXT_AUTH = false;
    public static final int DEFAULT_MAX_QUEUE_CHILDREN = 100;
    public static final int DEFAULT_NICE_QUEUE_RUN = 10;
    public static final int DEFAULT_DELAY_LA = 40;
    public static final int DEFAULT_QUEUE_LA = 50;
    public static final int DEFAULT_REFUSE_LA = 80;
    public static final int DEFAULT_MAX_DAEMON_CHILDREN = 1000;
    public static final int DEFAULT_BAD_RCPT_THROTTLE = 10;
    public static final int DEFAULT_CONNECTION_RATE_THROTTLE = 100;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 100000000;
    public static final int DEFAULT_MIN_FREE_BLOCKS = 65536;
    private int linuxServer_server_id;
    private String name;
    private int packageNum;
    private DomainName hostname;
    private int serverCertificate;
    private int clientCertificate;
    private boolean allowPlaintextAuth;
    private int maxQueueChildren;
    private int niceQueueRun;
    private int delayLa;
    private int queueLa;
    private int refuseLa;
    private int maxDaemonChildren;
    private int badRcptThrottle;
    private int connectionRateThrottle;
    private int maxMessageSize;
    private int minFreeBlocks;
    private int clientAddrInet;
    private int clientAddrInet6;

    @Deprecated
    public SendmailServer() {
    }

    @Override
    public String toStringImpl() {
        return this.name == null ? "sendmail" : "sendmail(" + this.name + ')';
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.linuxServer_server_id;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.packageNum;
            }
            case 4: {
                return this.hostname;
            }
            case 5: {
                return this.serverCertificate;
            }
            case 6: {
                return this.clientCertificate;
            }
            case 7: {
                return this.allowPlaintextAuth;
            }
            case 8: {
                return this.maxQueueChildren == -1 ? null : Integer.valueOf(this.maxQueueChildren);
            }
            case 9: {
                return this.niceQueueRun == -1 ? null : Integer.valueOf(this.niceQueueRun);
            }
            case 10: {
                return this.delayLa == -1 ? null : Integer.valueOf(this.delayLa);
            }
            case 11: {
                return this.queueLa == -1 ? null : Integer.valueOf(this.queueLa);
            }
            case 12: {
                return this.refuseLa == -1 ? null : Integer.valueOf(this.refuseLa);
            }
            case 13: {
                return this.maxDaemonChildren == -1 ? null : Integer.valueOf(this.maxDaemonChildren);
            }
            case 14: {
                return this.badRcptThrottle == -1 ? null : Integer.valueOf(this.badRcptThrottle);
            }
            case 15: {
                return this.connectionRateThrottle == -1 ? null : Integer.valueOf(this.connectionRateThrottle);
            }
            case 16: {
                return this.maxMessageSize == -1 ? null : Integer.valueOf(this.maxMessageSize);
            }
            case 17: {
                return this.minFreeBlocks == -1 ? null : Integer.valueOf(this.minFreeBlocks);
            }
            case 18: {
                return this.clientAddrInet == -1 ? null : Integer.valueOf(this.clientAddrInet);
            }
            case 19: {
                return this.clientAddrInet6 == -1 ? null : Integer.valueOf(this.clientAddrInet6);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SENDMAIL_SERVERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.linuxServer_server_id = result.getInt(pos++);
            this.name = result.getString(pos++);
            this.packageNum = result.getInt(pos++);
            this.hostname = DomainName.valueOf((String)result.getString(pos++));
            this.serverCertificate = result.getInt(pos++);
            this.clientCertificate = result.getInt(pos++);
            this.allowPlaintextAuth = result.getBoolean(pos++);
            this.maxQueueChildren = result.getInt(pos++);
            if (result.wasNull()) {
                this.maxQueueChildren = -1;
            }
            this.niceQueueRun = result.getInt(pos++);
            if (result.wasNull()) {
                this.niceQueueRun = -1;
            }
            this.delayLa = result.getInt(pos++);
            if (result.wasNull()) {
                this.delayLa = -1;
            }
            this.queueLa = result.getInt(pos++);
            if (result.wasNull()) {
                this.queueLa = -1;
            }
            this.refuseLa = result.getInt(pos++);
            if (result.wasNull()) {
                this.refuseLa = -1;
            }
            this.maxDaemonChildren = result.getInt(pos++);
            if (result.wasNull()) {
                this.maxDaemonChildren = -1;
            }
            this.badRcptThrottle = result.getInt(pos++);
            if (result.wasNull()) {
                this.badRcptThrottle = -1;
            }
            this.connectionRateThrottle = result.getInt(pos++);
            if (result.wasNull()) {
                this.connectionRateThrottle = -1;
            }
            this.maxMessageSize = result.getInt(pos++);
            if (result.wasNull()) {
                this.maxMessageSize = -1;
            }
            this.minFreeBlocks = result.getInt(pos++);
            if (result.wasNull()) {
                this.minFreeBlocks = -1;
            }
            this.clientAddrInet = result.getInt(pos++);
            if (result.wasNull()) {
                this.clientAddrInet = -1;
            }
            this.clientAddrInet6 = result.getInt(pos++);
            if (result.wasNull()) {
                this.clientAddrInet6 = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.linuxServer_server_id = in.readCompressedInt();
            this.name = in.readNullUTF();
            this.packageNum = in.readCompressedInt();
            this.hostname = DomainName.valueOf((String)in.readNullUTF());
            this.serverCertificate = in.readCompressedInt();
            this.clientCertificate = in.readCompressedInt();
            this.allowPlaintextAuth = in.readBoolean();
            this.maxQueueChildren = in.readCompressedInt();
            this.niceQueueRun = in.readCompressedInt();
            this.delayLa = in.readCompressedInt();
            this.queueLa = in.readCompressedInt();
            this.refuseLa = in.readCompressedInt();
            this.maxDaemonChildren = in.readCompressedInt();
            this.badRcptThrottle = in.readCompressedInt();
            this.connectionRateThrottle = in.readCompressedInt();
            this.maxMessageSize = in.readCompressedInt();
            this.minFreeBlocks = in.readCompressedInt();
            this.clientAddrInet = in.readCompressedInt();
            this.clientAddrInet6 = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.linuxServer_server_id);
        out.writeNullUTF(this.name);
        out.writeCompressedInt(this.packageNum);
        out.writeNullUTF(Objects.toString(this.hostname, null));
        out.writeCompressedInt(this.serverCertificate);
        out.writeCompressedInt(this.clientCertificate);
        out.writeBoolean(this.allowPlaintextAuth);
        out.writeCompressedInt(this.maxQueueChildren);
        out.writeCompressedInt(this.niceQueueRun);
        out.writeCompressedInt(this.delayLa);
        out.writeCompressedInt(this.queueLa);
        out.writeCompressedInt(this.refuseLa);
        out.writeCompressedInt(this.maxDaemonChildren);
        out.writeCompressedInt(this.badRcptThrottle);
        out.writeCompressedInt(this.connectionRateThrottle);
        out.writeCompressedInt(this.maxMessageSize);
        out.writeCompressedInt(this.minFreeBlocks);
        out.writeCompressedInt(this.clientAddrInet);
        out.writeCompressedInt(this.clientAddrInet6);
    }

    public int getId() {
        return this.pkey;
    }

    public int getLinuxServer_server_id() {
        return this.linuxServer_server_id;
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server obj = this.table.getConnector().getLinux().getServer().get(this.linuxServer_server_id);
        if (obj == null) {
            throw new SQLException("Unable to find linux.Server: " + this.linuxServer_server_id);
        }
        return obj;
    }

    public String getName() {
        return this.name;
    }

    public String getSystemdEscapedName() {
        return SystemdUtil.encode(this.name);
    }

    public int getPackage_pkey() {
        return this.packageNum;
    }

    public Package getPackage() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().get(this.packageNum);
    }

    public DomainName getHostname() {
        return this.hostname;
    }

    public int getServerCertificate_pkey() {
        return this.serverCertificate;
    }

    public Certificate getServerCertificate() throws SQLException, IOException {
        return this.table.getConnector().getPki().getCertificate().get(this.serverCertificate);
    }

    public int getClientCertificate_pkey() {
        return this.clientCertificate;
    }

    public Certificate getClientCertificate() throws SQLException, IOException {
        return this.table.getConnector().getPki().getCertificate().get(this.clientCertificate);
    }

    public boolean getAllowPlaintextAuth() {
        return this.allowPlaintextAuth;
    }

    public int getMaxQueueChildren() {
        return this.maxQueueChildren;
    }

    public int getNiceQueueRun() {
        return this.niceQueueRun;
    }

    public int getDelayLa() {
        return this.delayLa;
    }

    public int getQueueLa() {
        return this.queueLa;
    }

    public int getRefuseLa() {
        return this.refuseLa;
    }

    public int getMaxDaemonChildren() {
        return this.maxDaemonChildren;
    }

    public int getBadRcptThrottle() {
        return this.badRcptThrottle;
    }

    public int getConnectionRateThrottle() {
        return this.connectionRateThrottle;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMinFreeBlocks() {
        return this.minFreeBlocks;
    }

    public Integer getClientAddrInet_id() {
        return this.clientAddrInet == -1 ? null : Integer.valueOf(this.clientAddrInet);
    }

    public IpAddress getClientAddrInet() throws IOException, SQLException {
        if (this.clientAddrInet == -1) {
            return null;
        }
        IpAddress obj = this.table.getConnector().getNet().getIpAddress().get(this.clientAddrInet);
        if (obj == null) {
            throw new SQLException("Unable to find IpAddress: " + this.clientAddrInet);
        }
        InetAddress address = obj.getInetAddress();
        AddressFamily family = address.getAddressFamily();
        if (family != AddressFamily.INET) {
            throw new SQLException("Unexpected address family for clientAddrInet #" + this.clientAddrInet + ": " + family);
        }
        if (address.isUnspecified()) {
            throw new SQLException("May not use unspecified address for clientAddrInet #" + this.clientAddrInet);
        }
        if (!this.getLinuxServer().getHost().equals(obj.getDevice().getHost())) {
            throw new SQLException("IpAddress is not on this server for clientAddrInet #" + this.clientAddrInet);
        }
        return obj;
    }

    public Integer getClientAddrInet6_id() {
        return this.clientAddrInet6 == -1 ? null : Integer.valueOf(this.clientAddrInet6);
    }

    public IpAddress getClientAddrInet6() throws IOException, SQLException {
        if (this.clientAddrInet6 == -1) {
            return null;
        }
        IpAddress obj = this.table.getConnector().getNet().getIpAddress().get(this.clientAddrInet6);
        if (obj == null) {
            throw new SQLException("Unable to find IpAddress: " + this.clientAddrInet6);
        }
        InetAddress address = obj.getInetAddress();
        AddressFamily family = address.getAddressFamily();
        if (family != AddressFamily.INET6) {
            throw new SQLException("Unexpected address family for clientAddrInet6 #" + this.clientAddrInet6 + ": " + family);
        }
        if (address.isUnspecified()) {
            throw new SQLException("May not use unspecified address for clientAddrInet6 #" + this.clientAddrInet6);
        }
        if (!this.getLinuxServer().getHost().equals(obj.getDevice().getHost())) {
            throw new SQLException("IpAddress is not on this server for clientAddrInet6 #" + this.clientAddrInet6);
        }
        return obj;
    }

    public List<SendmailBind> getSendmailBinds() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSendmailBind().getSendmailBinds(this);
    }
}

