/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.SendmailServer;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class SendmailServerTable
extends CachedTableIntegerKey<SendmailServer> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("ao_server.hostname", true), new AoservTable.OrderBy("name", true)};

    SendmailServerTable(AoservConnector connector) {
        super(connector, SendmailServer.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public SendmailServer get(int id) throws IOException, SQLException {
        return (SendmailServer)this.getUniqueRow(0, id);
    }

    public List<SendmailServer> getSendmailServers(Server ao) throws IOException, SQLException {
        return this.getIndexedRows(1, ao.getPkey());
    }

    public List<SendmailServer> getSendmailServers(Package pk) throws IOException, SQLException {
        return this.getIndexedRows(3, pk.getPkey());
    }

    public List<SendmailServer> getSendmailServersByServerCertificate(Certificate sslCert) throws IOException, SQLException {
        return this.getIndexedRows(5, sslCert.getPkey());
    }

    public List<SendmailServer> getSendmailServersByClientCertificate(Certificate sslCert) throws IOException, SQLException {
        return this.getIndexedRows(6, sslCert.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SENDMAIL_SERVERS;
    }
}

