/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.HostAddress;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.SmtpRelayType;
import com.aoindustries.aoserv.client.email.SpamMessage;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

public final class SmtpRelay
extends CachedObjectIntegerKey<SmtpRelay>
implements Removable,
Disablable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_PACKAGE = 1;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_HOST_name = "host";
    static final String COLUMN_PACKAGE_name = "package";
    public static final int HISTORY_DAYS = 92;
    private Account.Name packageName;
    private int aoServer;
    private HostAddress host;
    private String type;
    private UnmodifiableTimestamp created;
    private UnmodifiableTimestamp lastRefreshed;
    private int refreshCount;
    private UnmodifiableTimestamp expiration;
    private int disableLog;

    @Deprecated
    public SmtpRelay() {
    }

    public int addSpamEmailMessage(String message) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSpamMessage().addSpamEmailMessage(this, message);
    }

    @Override
    public boolean canDisable() {
        return this.disableLog == -1;
    }

    @Override
    public boolean canEnable() throws IOException, SQLException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getPackage().isDisabled();
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.EMAIL_SMTP_RELAYS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.EMAIL_SMTP_RELAYS, this.pkey});
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.packageName;
            }
            case 2: {
                return this.aoServer == -1 ? null : Integer.valueOf(this.aoServer);
            }
            case 3: {
                return this.host;
            }
            case 4: {
                return this.type;
            }
            case 5: {
                return this.created;
            }
            case 6: {
                return this.lastRefreshed;
            }
            case 7: {
                return this.refreshCount;
            }
            case 8: {
                return this.expiration;
            }
            case 9: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public DisableLog getDisableLog() throws IOException, SQLException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public UnmodifiableTimestamp getExpiration() {
        return this.expiration;
    }

    public HostAddress getHost() {
        return this.host;
    }

    public SmtpRelayType getType() throws SQLException, IOException {
        SmtpRelayType esrt = this.table.getConnector().getEmail().getSmtpRelayType().get(this.type);
        if (esrt == null) {
            throw new SQLException("Unable to find EmailSmtpRelayType: " + this.type);
        }
        return esrt;
    }

    public UnmodifiableTimestamp getLastRefreshed() {
        return this.lastRefreshed;
    }

    public Account.Name getPackage_name() {
        return this.packageName;
    }

    public Package getPackage() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().get(this.packageName);
    }

    public int getRefreshCount() {
        return this.refreshCount;
    }

    public Integer getLinuxServer_host_id() {
        return this.aoServer == -1 ? null : Integer.valueOf(this.aoServer);
    }

    public Server getLinuxServer() throws SQLException, IOException {
        if (this.aoServer == -1) {
            return null;
        }
        Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    public List<SpamMessage> getSpamEmailMessages() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSpamMessage().getSpamEmailMessages(this);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_SMTP_RELAYS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.packageName = Account.Name.valueOf(result.getString(2));
            this.aoServer = result.getInt(3);
            if (result.wasNull()) {
                this.aoServer = -1;
            }
            this.host = HostAddress.valueOf((String)result.getString(4));
            this.type = result.getString(5);
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(6));
            this.lastRefreshed = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(7));
            this.refreshCount = result.getInt(8);
            this.expiration = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(9));
            this.disableLog = result.getInt(10);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
            this.aoServer = in.readCompressedInt();
            this.host = HostAddress.valueOf((String)in.readUTF());
            this.type = in.readUTF().intern();
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.lastRefreshed = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.refreshCount = in.readCompressedInt();
            this.expiration = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
            this.disableLog = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public void refresh(long minDuration) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REFRESH_EMAIL_SMTP_RELAY, this.pkey, minDuration);
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.EMAIL_SMTP_RELAYS, this.pkey});
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.packageName + " " + this.getType().getVerb() + " from " + this.host + " to " + this.getLinuxServer().getHostname();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.packageName.toString());
        out.writeCompressedInt(this.aoServer);
        out.writeUTF(this.host.toString());
        out.writeUTF(this.type);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.lastRefreshed.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.lastRefreshed, (DataOutputStream)out);
        }
        out.writeCompressedInt(this.refreshCount);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.expiration == null ? -1L : this.expiration.getTime());
        } else {
            SQLStreamables.writeNullTimestamp((Timestamp)this.expiration, (DataOutputStream)out);
        }
        out.writeCompressedInt(this.disableLog);
    }
}

