/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.net.HostAddress;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.SmtpRelay;
import com.aoindustries.aoserv.client.email.SmtpRelayType;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class SmtpRelayTable
extends CachedTableIntegerKey<SmtpRelay> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("ao_server.hostname", true), new AoservTable.OrderBy("host", true), new AoservTable.OrderBy("package", true)};

    SmtpRelayTable(AoservConnector connector) {
        super(connector, SmtpRelay.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addEmailSmtpRelay(final Package pack, final Server aoServer, final HostAddress host, final SmtpRelayType type, final long duration) throws IOException, SQLException {
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.EMAIL_SMTP_RELAYS.ordinal());
                out.writeUTF(pack.getName().toString());
                out.writeCompressedInt(aoServer == null ? -1 : aoServer.getPkey());
                out.writeUTF(host.toString());
                out.writeUTF(type.getName());
                out.writeLong(duration);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                SmtpRelayTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public SmtpRelay get(int pkey) throws IOException, SQLException {
        return (SmtpRelay)this.getUniqueRow(0, pkey);
    }

    public SmtpRelay getEmailSmtpRelay(Package pk, Server ao, HostAddress host) throws IOException, SQLException {
        Account.Name packageName = pk.getName();
        int aoPkey = ao.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        for (int c = 0; c < len; ++c) {
            Integer hostId;
            SmtpRelay relay = (SmtpRelay)cached.get(c);
            if (!packageName.equals(relay.getPackage_name()) || (hostId = relay.getLinuxServer_host_id()) != null && hostId != aoPkey || !host.equals((Object)relay.getHost())) continue;
            return relay;
        }
        return null;
    }

    public List<SmtpRelay> getEmailSmtpRelays(Package pk) throws IOException, SQLException {
        return this.getIndexedRows(1, pk.getName());
    }

    public List<SmtpRelay> getEmailSmtpRelays(Server ao) throws IOException, SQLException {
        int aoPkey = ao.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<SmtpRelay> matches = new ArrayList<SmtpRelay>(len);
        for (int c = 0; c < len; ++c) {
            SmtpRelay relay = (SmtpRelay)cached.get(c);
            Integer hostId = relay.getLinuxServer_host_id();
            if (hostId != null && hostId != aoPkey) continue;
            matches.add(relay);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_SMTP_RELAYS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_email_smtp_relay")) {
            if (Aosh.checkParamCount("add_email_smtp_relay", args, 5, (PrintWriter)err)) {
                String s = args[5].trim();
                out.println(this.connector.getSimpleClient().addEmailSmtpRelay(Aosh.parseAccountingCode(args[1], "package"), args[2], Aosh.parseHostAddress(args[3], "host"), args[4], s.length() == 0 ? -1L : Aosh.parseLong(s, "duration")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_email_smtp_relay")) {
            if (Aosh.checkParamCount("disable_email_smtp_relay", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableEmailSmtpRelay(Aosh.parseInt(args[1], "pkey"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_email_smtp_relay")) {
            if (Aosh.checkParamCount("enable_email_smtp_relay", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableEmailSmtpRelay(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("refresh_email_smtp_relay")) {
            if (Aosh.checkParamCount("refresh_email_smtp_relay", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().refreshEmailSmtpRelay(Aosh.parseInt(args[1], "pkey"), args[2].trim().length() == 0 ? -1L : Aosh.parseLong(args[2], "min_duration"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_email_smtp_relay")) {
            if (Aosh.checkParamCount("remove_email_smtp_relay", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeEmailSmtpRelay(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        return false;
    }
}

