/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SmtpRelayType
extends GlobalObjectStringKey<SmtpRelayType> {
    static final int COLUMN_NAME = 0;
    static final String COLUMN_NAME_name = "name";
    public static final String ALLOW = "allow";
    public static final String ALLOW_RELAY = "allow_relay";
    public static final String DENY_SPAM = "deny_spam";
    public static final String DENY = "deny";
    private String sendmailConfig;
    private String qmailConfig;

    @Deprecated
    public SmtpRelayType() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.sendmailConfig;
            }
            case 2: {
                return this.qmailConfig;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getName() {
        return this.pkey;
    }

    public String getSendmailConfig() {
        return this.sendmailConfig;
    }

    public String getQmailConfig() {
        return this.qmailConfig;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_SMTP_RELAY_TYPES;
    }

    public String getVerb() throws SQLException {
        if (this.pkey.equals(ALLOW)) {
            return "allowed regular access";
        }
        if (this.pkey.equals(ALLOW_RELAY)) {
            return "allowed unauthenticated relay access";
        }
        if (this.pkey.equals(DENY_SPAM)) {
            return "blocked for sending unsolicited bulk email";
        }
        if (this.pkey.equals(DENY)) {
            return "blocked";
        }
        throw new SQLException("Unknown value for name: " + this.pkey);
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
        this.sendmailConfig = result.getString(2);
        this.qmailConfig = result.getString(3);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.sendmailConfig = in.readUTF();
        this.qmailConfig = in.readUTF();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeUTF(this.sendmailConfig);
        out.writeUTF(this.qmailConfig);
    }
}

