/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SmtpSmartHost
extends CachedObjectIntegerKey<SmtpSmartHost> {
    static final int COLUMN_NET_BIND = 0;
    static final String COLUMN_NET_BIND_name = "net_bind";
    private int totalOutBurst;
    private float totalOutRate;
    private int defaultDomainOutBurst;
    private float defaultDomainOutRate;

    @Deprecated
    public SmtpSmartHost() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.totalOutBurst == -1 ? null : Integer.valueOf(this.totalOutBurst);
            }
            case 2: {
                return Float.isNaN(this.totalOutRate) ? null : Float.valueOf(this.totalOutRate);
            }
            case 3: {
                return this.defaultDomainOutBurst == -1 ? null : Integer.valueOf(this.defaultDomainOutBurst);
            }
            case 4: {
                return Float.isNaN(this.defaultDomainOutRate) ? null : Float.valueOf(this.defaultDomainOutRate);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Bind getNetBind() throws IOException, SQLException {
        Bind obj = this.table.getConnector().getNet().getBind().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find NetBind: " + this.pkey);
        }
        return obj;
    }

    public int getTotalEmailOutBurst() {
        return this.totalOutBurst;
    }

    public float getTotalEmailOutRate() {
        return this.totalOutRate;
    }

    public int getDefaultDomainOutBurst() {
        return this.defaultDomainOutBurst;
    }

    public float getDefaultDomainOutRate() {
        return this.defaultDomainOutRate;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_SMTP_SMART_HOSTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.totalOutBurst = result.getInt(pos++);
        if (result.wasNull()) {
            this.totalOutBurst = -1;
        }
        this.totalOutRate = result.getFloat(pos++);
        if (result.wasNull()) {
            this.totalOutRate = Float.NaN;
        }
        this.defaultDomainOutBurst = result.getInt(pos++);
        if (result.wasNull()) {
            this.defaultDomainOutBurst = -1;
        }
        this.defaultDomainOutRate = result.getFloat(pos++);
        if (result.wasNull()) {
            this.defaultDomainOutRate = Float.NaN;
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.totalOutBurst = in.readCompressedInt();
        this.totalOutRate = in.readFloat();
        this.defaultDomainOutBurst = in.readCompressedInt();
        this.defaultDomainOutRate = in.readFloat();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.totalOutBurst);
        out.writeFloat(this.totalOutRate);
        out.writeCompressedInt(this.defaultDomainOutBurst);
        out.writeFloat(this.defaultDomainOutRate);
    }
}

