/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.email.SmtpSmartHost;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SmtpSmartHostDomain
extends CachedObjectIntegerKey<SmtpSmartHostDomain> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_SMART_HOST = 1;
    static final String COLUMN_SMART_HOST_name = "smart_host";
    static final String COLUMN_DOMAIN_name = "domain";
    private int smartHost;
    private DomainName domain;
    private int domainOutBurst;
    private float domainOutRate;

    @Deprecated
    public SmtpSmartHostDomain() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.smartHost;
            }
            case 2: {
                return this.domain;
            }
            case 3: {
                return this.domainOutBurst == -1 ? null : Integer.valueOf(this.domainOutBurst);
            }
            case 4: {
                return Float.isNaN(this.domainOutRate) ? null : Float.valueOf(this.domainOutRate);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public SmtpSmartHost getEmailSmtpSmartHost() throws SQLException, IOException {
        SmtpSmartHost obj = this.table.getConnector().getEmail().getSmtpSmartHost().get(this.smartHost);
        if (obj == null) {
            throw new SQLException("Unable to find EmailSmtpSmartHost: " + this.smartHost);
        }
        return obj;
    }

    public DomainName getDomain() {
        return this.domain;
    }

    public int getDomainOutBurst() {
        return this.domainOutBurst;
    }

    public float getDomainOutRate() {
        return this.domainOutRate;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_SMTP_SMART_HOST_DOMAINS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.smartHost = result.getInt(pos++);
            this.domain = DomainName.valueOf((String)result.getString(pos++));
            this.domainOutBurst = result.getInt(pos++);
            if (result.wasNull()) {
                this.domainOutBurst = -1;
            }
            this.domainOutRate = result.getFloat(pos++);
            if (result.wasNull()) {
                this.domainOutRate = Float.NaN;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.smartHost = in.readCompressedInt();
            this.domain = DomainName.valueOf((String)in.readUTF());
            this.domainOutBurst = in.readCompressedInt();
            this.domainOutRate = in.readFloat();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.smartHost);
        out.writeCompressedInt(this.domainOutBurst);
        out.writeFloat(this.domainOutRate);
    }
}

