/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.SingleTableObject;
import com.aoindustries.aoserv.client.email.SmtpRelay;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class SpamMessage
extends AoservObject<Integer, SpamMessage>
implements SingleTableObject<Integer, SpamMessage> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_EMAIL_RELAY = 1;
    static final String COLUMN_PKEY_name = "pkey";
    private AoservTable<Integer, SpamMessage> table;
    private int pkey;
    private int emailRelay;
    private UnmodifiableTimestamp time;
    private String message;

    @Deprecated
    public SpamMessage() {
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SpamMessage && ((SpamMessage)obj).getPkey() == this.pkey;
    }

    public int getPkey() {
        return this.pkey;
    }

    public SmtpRelay getEmailSmtpRelay() throws SQLException, IOException {
        SmtpRelay er = this.table.getConnector().getEmail().getSmtpRelay().get(this.emailRelay);
        if (er == null) {
            throw new SQLException("Unable to find EmailSmtpRelay: " + this.emailRelay);
        }
        return er;
    }

    public UnmodifiableTimestamp getTime() {
        return this.time;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.emailRelay;
            }
            case 2: {
                return this.time;
            }
            case 3: {
                return this.message;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Integer getKey() {
        return this.pkey;
    }

    @Override
    public AoservTable<Integer, SpamMessage> getTable() {
        return this.table;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SPAM_EMAIL_MESSAGES;
    }

    @Override
    public int hashCode() {
        return this.pkey;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.emailRelay = result.getInt(2);
        this.time = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(3));
        this.message = result.getString(4);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.emailRelay = in.readCompressedInt();
        this.time = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
        this.message = in.readUTF();
    }

    @Override
    public void setTable(AoservTable<Integer, SpamMessage> table) {
        if (this.table != null) {
            throw new IllegalStateException("table already set");
        }
        this.table = table;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.emailRelay);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.time.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.time, (DataOutputStream)out);
        }
        out.writeUTF(this.message);
    }
}

