/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.SmtpRelay;
import com.aoindustries.aoserv.client.email.SpamMessage;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SpamMessageTable
extends AoservTable<Integer, SpamMessage> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("pkey", true)};

    SpamMessageTable(AoservConnector connector) {
        super(connector, SpamMessage.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addSpamEmailMessage(SmtpRelay esr, String message) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.SPAM_EMAIL_MESSAGES, esr.getPkey(), message});
    }

    @Override
    public List<SpamMessage> getRowsCopy() throws IOException, SQLException {
        ArrayList<SpamMessage> list = new ArrayList<SpamMessage>();
        this.getObjects(true, list, AoservProtocol.CommandId.GET_TABLE, new Object[]{Table.TableId.SPAM_EMAIL_MESSAGES});
        return list;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SPAM_EMAIL_MESSAGES;
    }

    @Override
    @Deprecated
    public SpamMessage get(Object pkey) throws IOException, SQLException {
        if (pkey == null) {
            return null;
        }
        return this.get((Integer)pkey);
    }

    public SpamMessage get(int pkey) throws IOException, SQLException {
        return (SpamMessage)this.getObject(true, AoservProtocol.CommandId.GET_OBJECT, new Object[]{Table.TableId.SPAM_EMAIL_MESSAGES, pkey});
    }

    List<SpamMessage> getSpamEmailMessages(SmtpRelay esr) throws IOException, SQLException {
        return this.getSpamEmailMessages(esr.getPkey());
    }

    List<SpamMessage> getSpamEmailMessages(int esr) throws IOException, SQLException {
        return this.getObjects(true, AoservProtocol.CommandId.GET_SPAM_EMAIL_MESSAGES_FOR_EMAIL_SMTP_RELAY, esr);
    }

    @Override
    public List<SpamMessage> getIndexedRows(int col, Object value) throws IOException, SQLException {
        if (col == 0) {
            SpamMessage sem = this.get(value);
            if (sem == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(sem);
        }
        if (col == 1) {
            return this.getSpamEmailMessages((Integer)value);
        }
        throw new UnsupportedOperationException("Not an indexed column: " + col);
    }

    @Override
    protected SpamMessage getUniqueRowImpl(int col, Object value) throws IOException, SQLException {
        if (col == 0) {
            return this.get(value);
        }
        throw new IllegalArgumentException("Not a unique column: " + col);
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_spam_email_message")) {
            if (Aosh.checkParamCount("add_spam_email_message", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addSpamEmailMessage(Aosh.parseInt(args[1], "email_relay"), args[2]));
                out.flush();
            }
            return true;
        }
        return false;
    }
}

