/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SystemAlias
extends CachedObjectIntegerKey<SystemAlias> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_AO_SERVER = 1;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_ADDRESS_name = "address";
    private int aoServer;
    private String address;
    private String destination;

    @Deprecated
    public SystemAlias() {
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.aoServer;
            }
            case 2: {
                return this.address;
            }
            case 3: {
                return this.destination;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getDestination() {
        return this.destination;
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SYSTEM_EMAIL_ALIASES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.aoServer = result.getInt(2);
        this.address = result.getString(3);
        this.destination = result.getString(4);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.aoServer = in.readCompressedInt();
        this.address = in.readUTF().intern();
        this.destination = in.readUTF().intern();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.aoServer);
        out.writeUTF(this.address);
        out.writeUTF(this.destination);
    }
}

