/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ftp;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.linux.CachedObjectUserNameKey;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class GuestUser
extends CachedObjectUserNameKey<GuestUser>
implements Removable {
    static final int COLUMN_USERNAME = 0;
    static final String COLUMN_USERNAME_name = "username";

    @Deprecated
    public GuestUser() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public User getLinuxAccount() throws SQLException, IOException {
        User obj = this.table.getConnector().getLinux().getUser().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find LinuxAccount: " + this.pkey);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FTP_GUEST_USERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = User.Name.valueOf(result.getString(1));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = User.Name.valueOf(in.readUTF()).intern();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.FTP_GUEST_USERS, this.pkey});
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
    }
}

