/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ftp;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.ftp.GuestUser;
import com.aoindustries.aoserv.client.linux.CachedTableUserNameKey;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class GuestUserTable
extends CachedTableUserNameKey<GuestUser> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("username", true)};

    GuestUserTable(AoservConnector connector) {
        super(connector, GuestUser.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public void addFtpGuestUser(User.Name username) throws IOException, SQLException {
        this.connector.requestUpdateInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.FTP_GUEST_USERS, username});
    }

    public List<GuestUser> getFtpGuestUsers(Server aoServer) throws IOException, SQLException {
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<GuestUser> matches = new ArrayList<GuestUser>(size);
        for (int c = 0; c < size; ++c) {
            GuestUser obj = (GuestUser)cached.get(c);
            if (obj.getLinuxAccount().getLinuxServerAccount(aoServer) == null) continue;
            matches.add(obj);
        }
        return matches;
    }

    @Override
    public GuestUser get(User.Name username) throws IOException, SQLException {
        return (GuestUser)this.getUniqueRow(0, username);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FTP_GUEST_USERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_ftp_guest_user")) {
            if (Aosh.checkParamCount("add_ftp_guest_user", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().addFtpGuestUser(Aosh.parseLinuxUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_ftp_guest_user")) {
            if (Aosh.checkParamCount("remove_ftp_guest_user", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeFtpGuestUser(Aosh.parseLinuxUserName(args[1], "username"));
            }
            return true;
        }
        return false;
    }
}

