/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ftp;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.Email;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class PrivateServer
extends CachedObjectIntegerKey<PrivateServer> {
    static final int COLUMN_NET_BIND = 0;
    static final String COLUMN_NET_BIND_name = "net_bind";
    private PosixPath logfile;
    private DomainName hostname;
    private Email email;
    private UnmodifiableTimestamp created;
    private int pubLinuxServerAccount;
    private boolean allowAnonymous;

    @Deprecated
    public PrivateServer() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.logfile;
            }
            case 2: {
                return this.hostname;
            }
            case 3: {
                return this.email;
            }
            case 4: {
                return this.created;
            }
            case 5: {
                return this.pubLinuxServerAccount;
            }
            case 6: {
                return this.allowAnonymous;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public Email getEmail() {
        return this.email;
    }

    public DomainName getHostname() {
        return this.hostname;
    }

    public Bind getNetBind() throws SQLException, IOException {
        Bind nb = this.table.getConnector().getNet().getBind().get(this.pkey);
        if (nb == null) {
            throw new SQLException("Unable to find NetBind: " + this.pkey);
        }
        return nb;
    }

    public PosixPath getLogfile() {
        return this.logfile;
    }

    public int getLinuxServerAccount_pkey() {
        return this.pubLinuxServerAccount;
    }

    public UserServer getLinuxServerAccount() throws SQLException, IOException {
        UserServer lsa = this.table.getConnector().getLinux().getUserServer().get(this.pubLinuxServerAccount);
        if (lsa == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.pubLinuxServerAccount);
        }
        return lsa;
    }

    @Deprecated
    public GroupServer getLinuxServerGroup() throws SQLException, IOException {
        return this.getLinuxServerAccount().getPrimaryLinuxServerGroup();
    }

    public boolean allowAnonymous() {
        return this.allowAnonymous;
    }

    @Deprecated
    public PosixPath getRoot() throws SQLException, IOException {
        return this.getLinuxServerAccount().getHome();
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PRIVATE_FTP_SERVERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.logfile = PosixPath.valueOf(result.getString(2));
            this.hostname = DomainName.valueOf((String)result.getString(3));
            this.email = Email.valueOf((String)result.getString(4));
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(5));
            this.pubLinuxServerAccount = result.getInt(6);
            this.allowAnonymous = result.getBoolean(7);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.logfile = PosixPath.valueOf(in.readUTF());
            this.hostname = DomainName.valueOf((String)in.readUTF());
            this.email = Email.valueOf((String)in.readUTF());
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.pubLinuxServerAccount = in.readCompressedInt();
            this.allowAnonymous = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.hostname.toString();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_113) < 0) {
            throw new IOException("PrivateFtpServer on AoservProtocol version less than " + AoservProtocol.Version.VERSION_1_0_A_113.getVersion() + " is no longer supported.  Please upgrade your AOServ Client software packages.");
        }
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_38) <= 0) {
            out.writeUTF("Upgrade AOServClient to version " + (Object)((Object)AoservProtocol.Version.VERSION_1_39) + " or newer");
        }
        out.writeUTF(this.logfile.toString());
        out.writeUTF(this.hostname.toString());
        out.writeUTF(this.email.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_122) <= 0) {
            out.writeCompressedInt(-1);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        out.writeCompressedInt(this.pubLinuxServerAccount);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_38) <= 0) {
            out.writeCompressedInt(-1);
        }
        out.writeBoolean(this.allowAnonymous);
    }
}

