/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.infrastructure;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.infrastructure.ProcessorType;
import com.aoindustries.aoserv.client.infrastructure.Rack;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class PhysicalServer
extends CachedObjectIntegerKey<PhysicalServer> {
    static final int COLUMN_SERVER = 0;
    static final String COLUMN_SERVER_name = "server";
    private int rack;
    private short rackUnits;
    private int ram;
    private String processorType;
    private int processorSpeed;
    private int processorCores;
    private float maxPower;
    private Boolean supportsHvm;
    private UpsType upsType;

    @Deprecated
    public PhysicalServer() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.rack == -1 ? null : Integer.valueOf(this.rack);
            }
            case 2: {
                return this.rackUnits == -1 ? null : Short.valueOf(this.rackUnits);
            }
            case 3: {
                return this.ram == -1 ? null : Integer.valueOf(this.ram);
            }
            case 4: {
                return this.processorType;
            }
            case 5: {
                return this.processorSpeed == -1 ? null : Integer.valueOf(this.processorSpeed);
            }
            case 6: {
                return this.processorCores == -1 ? null : Integer.valueOf(this.processorCores);
            }
            case 7: {
                return Float.isNaN(this.maxPower) ? null : Float.valueOf(this.maxPower);
            }
            case 8: {
                return this.supportsHvm;
            }
            case 9: {
                return this.upsType.name();
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Host getHost() throws SQLException, IOException {
        Host se = this.table.getConnector().getNet().getHost().get(this.pkey);
        if (se == null) {
            throw new SQLException("Unable to find Host: " + this.pkey);
        }
        return se;
    }

    public Rack getRack() throws SQLException, IOException {
        if (this.rack == -1) {
            return null;
        }
        Rack ra = this.table.getConnector().getInfrastructure().getRack().get(this.rack);
        if (ra == null) {
            throw new SQLException("Unable to find Rack: " + this.rack);
        }
        return ra;
    }

    public short getRackUnits() {
        return this.rackUnits;
    }

    public int getRam() {
        return this.ram;
    }

    public ProcessorType getProcessorType() throws SQLException, IOException {
        if (this.processorType == null) {
            return null;
        }
        ProcessorType pt = this.table.getConnector().getInfrastructure().getProcessorType().get(this.processorType);
        if (pt == null) {
            throw new SQLException("Unable to find ProcessorType: " + this.processorType);
        }
        return pt;
    }

    public int getProcessorSpeed() {
        return this.processorSpeed;
    }

    public int getProcessorCores() {
        return this.processorCores;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public Boolean getSupportsHvm() {
        return this.supportsHvm;
    }

    public UpsType getUpsType() {
        return this.upsType;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PHYSICAL_SERVERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.rack = result.getInt(pos++);
        if (result.wasNull()) {
            this.rack = -1;
        }
        this.rackUnits = result.getShort(pos++);
        if (result.wasNull()) {
            this.rackUnits = (short)-1;
        }
        this.ram = result.getInt(pos++);
        if (result.wasNull()) {
            this.ram = -1;
        }
        this.processorType = result.getString(pos++);
        this.processorSpeed = result.getInt(pos++);
        if (result.wasNull()) {
            this.processorSpeed = -1;
        }
        this.processorCores = result.getInt(pos++);
        if (result.wasNull()) {
            this.processorCores = -1;
        }
        this.maxPower = result.getFloat(pos++);
        if (result.wasNull()) {
            this.maxPower = Float.NaN;
        }
        this.supportsHvm = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.supportsHvm = null;
        }
        this.upsType = UpsType.valueOf(result.getString(pos++));
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.rack = in.readCompressedInt();
        this.rackUnits = in.readShort();
        this.ram = in.readCompressedInt();
        this.processorType = InternUtils.intern((String)in.readNullUTF());
        this.processorSpeed = in.readCompressedInt();
        this.processorCores = in.readCompressedInt();
        this.maxPower = in.readFloat();
        this.supportsHvm = in.readBoolean() ? Boolean.valueOf(in.readBoolean()) : null;
        this.upsType = UpsType.valueOf(in.readUTF());
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getHost().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.rack);
        out.writeShort((int)this.rackUnits);
        out.writeCompressedInt(this.ram);
        out.writeNullUTF(this.processorType);
        out.writeCompressedInt(this.processorSpeed);
        out.writeCompressedInt(this.processorCores);
        out.writeFloat(this.maxPower);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_37) >= 0) {
            out.writeBoolean(this.supportsHvm != null);
            if (this.supportsHvm != null) {
                out.writeBoolean(this.supportsHvm.booleanValue());
            }
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_63) >= 0) {
            out.writeUTF(this.upsType.name());
        }
    }

    public static enum UpsType {
        none,
        datacenter,
        apc;

    }
}

