/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.infrastructure;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.infrastructure.ServerFarm;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Rack
extends CachedObjectIntegerKey<Rack> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_FARM = 1;
    static final int COLUMN_NAME = 2;
    static final String COLUMN_FARM_name = "farm";
    static final String COLUMN_NAME_name = "name";
    private String farm;
    private String name;
    private float maxPower;
    private int totalRackUnits;

    @Deprecated
    public Rack() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.farm;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return Float.isNaN(this.maxPower) ? null : Float.valueOf(this.maxPower);
            }
            case 4: {
                return this.totalRackUnits == -1 ? null : Integer.valueOf(this.totalRackUnits);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public ServerFarm getServerFarm() throws SQLException, IOException {
        ServerFarm sf = this.table.getConnector().getInfrastructure().getServerFarm().get(this.farm);
        if (sf == null) {
            throw new SQLException("Unable to find ServerFarm: " + this.farm);
        }
        return sf;
    }

    public String getName() {
        return this.name;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public int getTotalRackUnits() {
        return this.totalRackUnits;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.RACKS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.farm = result.getString(2);
        this.name = result.getString(3);
        this.maxPower = result.getFloat(4);
        if (result.wasNull()) {
            this.maxPower = Float.NaN;
        }
        this.totalRackUnits = result.getInt(5);
        if (result.wasNull()) {
            this.totalRackUnits = -1;
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.farm = in.readUTF().intern();
        this.name = in.readUTF();
        this.maxPower = in.readFloat();
        this.totalRackUnits = in.readCompressedInt();
    }

    @Override
    public String toStringImpl() {
        return this.name;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.farm);
        out.writeUTF(this.name);
        out.writeFloat(this.maxPower);
        out.writeCompressedInt(this.totalRackUnits);
    }
}

