/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.infrastructure;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectStringKey;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class ServerFarm
extends CachedObjectStringKey<ServerFarm> {
    static final int COLUMN_NAME = 0;
    static final String COLUMN_NAME_name = "name";
    private String description;
    private int owner;
    private boolean useRestrictedSmtpPort;

    @Deprecated
    public ServerFarm() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.description;
            }
            case 2: {
                return this.owner;
            }
            case 3: {
                return this.useRestrictedSmtpPort;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Package getOwner() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().get(this.owner);
    }

    public boolean useRestrictedSmtpPort() {
        return this.useRestrictedSmtpPort;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.pkey;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SERVER_FARMS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
        this.description = result.getString(2);
        this.owner = result.getInt(3);
        this.useRestrictedSmtpPort = result.getBoolean(4);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.description = in.readUTF();
        this.owner = in.readCompressedInt();
        this.useRestrictedSmtpPort = in.readBoolean();
    }

    @Override
    public String toStringImpl() {
        return this.description;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeUTF(this.description);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeUTF("192.168.0.0/16");
            out.writeBoolean(false);
            out.writeUTF("mob");
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_102) >= 0) {
            out.writeCompressedInt(this.owner);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_26) >= 0) {
            out.writeBoolean(this.useRestrictedSmtpPort);
        }
    }
}

