/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.infrastructure;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.infrastructure.VirtualServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class VirtualDisk
extends CachedObjectIntegerKey<VirtualDisk> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_VIRTUAL_SERVER = 1;
    static final int COLUMN_DEVICE = 2;
    static final String COLUMN_VIRTUAL_SERVER_name = "virtual_server";
    static final String COLUMN_DEVICE_name = "device";
    private int virtualServer;
    private String device;
    private int minimumDiskSpeed;
    private int minimumDiskSpeedTarget;
    private int extents;
    private short weight;
    private short weightTarget;
    private int verifyDayOfWeek;
    private int verifyHourOfDay;

    @Deprecated
    public VirtualDisk() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.virtualServer;
            }
            case 2: {
                return this.device;
            }
            case 3: {
                return this.minimumDiskSpeed == -1 ? null : Integer.valueOf(this.minimumDiskSpeed);
            }
            case 4: {
                return this.minimumDiskSpeedTarget == -1 ? null : Integer.valueOf(this.minimumDiskSpeedTarget);
            }
            case 5: {
                return this.extents;
            }
            case 6: {
                return this.weight;
            }
            case 7: {
                return this.weightTarget;
            }
            case 8: {
                return this.verifyDayOfWeek;
            }
            case 9: {
                return this.verifyHourOfDay;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public VirtualServer getVirtualServer() throws SQLException, IOException {
        VirtualServer vs = this.table.getConnector().getInfrastructure().getVirtualServer().get(this.virtualServer);
        if (vs == null) {
            throw new SQLException("Unable to find VirtualServer: " + this.virtualServer);
        }
        return vs;
    }

    public String getDevice() {
        return this.device;
    }

    public int getMinimumDiskSpeed() {
        return this.minimumDiskSpeed;
    }

    public int getMinimumDiskSpeedTarget() {
        return this.minimumDiskSpeedTarget;
    }

    public int getExtents() {
        return this.extents;
    }

    public short getWeight() {
        return this.weight;
    }

    public short getWeightTarget() {
        return this.weightTarget;
    }

    public int getVerifyDayOfWeek() {
        return this.verifyDayOfWeek;
    }

    public int getVerifyHourOfDay() {
        return this.verifyHourOfDay;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.VIRTUAL_DISKS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.virtualServer = result.getInt(pos++);
        this.device = result.getString(pos++);
        this.minimumDiskSpeed = result.getInt(pos++);
        if (result.wasNull()) {
            this.minimumDiskSpeed = -1;
        }
        this.minimumDiskSpeedTarget = result.getInt(pos++);
        if (result.wasNull()) {
            this.minimumDiskSpeedTarget = -1;
        }
        this.extents = result.getInt(pos++);
        this.weight = result.getShort(pos++);
        this.weightTarget = result.getShort(pos++);
        this.verifyDayOfWeek = result.getInt(pos++);
        this.verifyHourOfDay = result.getInt(pos++);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.virtualServer = in.readCompressedInt();
        this.device = in.readUTF().intern();
        this.minimumDiskSpeed = in.readCompressedInt();
        this.minimumDiskSpeedTarget = in.readCompressedInt();
        this.extents = in.readCompressedInt();
        this.weight = in.readShort();
        this.weightTarget = in.readShort();
        this.verifyDayOfWeek = in.readCompressedInt();
        this.verifyHourOfDay = in.readCompressedInt();
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getVirtualServer().toStringImpl() + ":/dev/" + this.device;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.virtualServer);
        out.writeUTF(this.device);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_41) <= 0) {
            out.writeNullUTF(null);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeNullUTF(null);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_41) <= 0) {
            out.writeNullUTF(null);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeNullUTF(null);
        }
        out.writeCompressedInt(this.minimumDiskSpeed);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) >= 0) {
            out.writeCompressedInt(this.minimumDiskSpeedTarget);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeCompressedInt(this.minimumDiskSpeed);
        }
        out.writeCompressedInt(this.extents);
        out.writeShort((int)this.weight);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) >= 0) {
            out.writeShort((int)this.weightTarget);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeShort((int)this.weight);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_42) <= 0) {
            out.writeBoolean(false);
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_72) >= 0) {
            out.writeCompressedInt(this.verifyDayOfWeek);
            out.writeCompressedInt(this.verifyHourOfDay);
        }
    }

    public long verify() throws SQLException, IOException {
        return this.table.getConnector().requestLongQuery(true, AoservProtocol.CommandId.VERIFY_VIRTUAL_DISK, this.getPkey());
    }
}

