/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.infrastructure;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.sql.SQLUtility;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.infrastructure.VirtualDisk;
import com.aoindustries.aoserv.client.infrastructure.VirtualServer;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class VirtualDiskTable
extends CachedTableIntegerKey<VirtualDisk> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("virtual_server.server.package.name", true), new AoservTable.OrderBy("virtual_server.server.name", true), new AoservTable.OrderBy("device", true)};

    VirtualDiskTable(AoservConnector connector) {
        super(connector, VirtualDisk.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public VirtualDisk get(int pkey) throws IOException, SQLException {
        return (VirtualDisk)this.getUniqueRow(0, pkey);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.VIRTUAL_DISKS;
    }

    List<VirtualDisk> getVirtualDisks(VirtualServer vs) throws IOException, SQLException {
        return this.getIndexedRows(1, vs.getPkey());
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("verify_virtual_disk")) {
            if (Aosh.checkParamCount("verify_virtual_disk", args, 2, (PrintWriter)err)) {
                long lastVerified = this.connector.getSimpleClient().verifyVirtualDisk(args[1], args[2]);
                if (isInteractive) {
                    out.println(SQLUtility.formatDateTime((long)lastVerified));
                } else {
                    out.println(lastVerified);
                }
                out.flush();
            }
            return true;
        }
        return false;
    }
}

