/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.infrastructure;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.HostAddress;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.distribution.Architecture;
import com.aoindustries.aoserv.client.infrastructure.PhysicalServer;
import com.aoindustries.aoserv.client.infrastructure.ProcessorType;
import com.aoindustries.aoserv.client.infrastructure.VirtualDisk;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class VirtualServer
extends CachedObjectIntegerKey<VirtualServer> {
    static final int COLUMN_SERVER = 0;
    static final String COLUMN_SERVER_name = "server";
    private int primaryRam;
    private int primaryRamTarget;
    private int secondaryRam;
    private int secondaryRamTarget;
    private String minimumProcessorType;
    private String minimumProcessorArchitecture;
    private int minimumProcessorSpeed;
    private int minimumProcessorSpeedTarget;
    private short processorCores;
    private short processorCoresTarget;
    private short processorWeight;
    private short processorWeightTarget;
    private boolean primaryPhysicalServerLocked;
    private boolean secondaryPhysicalServerLocked;
    private boolean requiresHvm;
    private String vncPassword;
    public static final int RUNNING = 1;
    public static final int BLOCKED = 2;
    public static final int PAUSED = 4;
    public static final int SHUTDOWN = 8;
    public static final int CRASHED = 16;
    public static final int DYING = 32;
    public static final int DESTROYED = 64;

    @Deprecated
    public VirtualServer() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.primaryRam;
            }
            case 2: {
                return this.primaryRamTarget;
            }
            case 3: {
                return this.secondaryRam == -1 ? null : Integer.valueOf(this.secondaryRam);
            }
            case 4: {
                return this.secondaryRamTarget == -1 ? null : Integer.valueOf(this.secondaryRamTarget);
            }
            case 5: {
                return this.minimumProcessorType;
            }
            case 6: {
                return this.minimumProcessorArchitecture;
            }
            case 7: {
                return this.minimumProcessorSpeed == -1 ? null : Integer.valueOf(this.minimumProcessorSpeed);
            }
            case 8: {
                return this.minimumProcessorSpeedTarget == -1 ? null : Integer.valueOf(this.minimumProcessorSpeedTarget);
            }
            case 9: {
                return this.processorCores;
            }
            case 10: {
                return this.processorCoresTarget;
            }
            case 11: {
                return this.processorWeight;
            }
            case 12: {
                return this.processorWeightTarget;
            }
            case 13: {
                return this.primaryPhysicalServerLocked;
            }
            case 14: {
                return this.secondaryPhysicalServerLocked;
            }
            case 15: {
                return this.requiresHvm;
            }
            case 16: {
                return this.vncPassword;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Host getHost() throws SQLException, IOException {
        Host se = this.table.getConnector().getNet().getHost().get(this.pkey);
        if (se == null) {
            throw new SQLException("Unable to find Host: " + this.pkey);
        }
        return se;
    }

    public int getPrimaryRam() {
        return this.primaryRam;
    }

    public int getPrimaryRamTarget() {
        return this.primaryRamTarget;
    }

    public int getSecondaryRam() {
        return this.secondaryRam;
    }

    public int getSecondaryRamTarget() {
        return this.secondaryRamTarget;
    }

    public ProcessorType getMinimumProcessorType() throws IOException, SQLException {
        if (this.minimumProcessorType == null) {
            return null;
        }
        ProcessorType pt = this.table.getConnector().getInfrastructure().getProcessorType().get(this.minimumProcessorType);
        if (pt == null) {
            throw new SQLException("Unable to find ProcessorType: " + this.minimumProcessorType);
        }
        return pt;
    }

    public Architecture getMinimumProcessorArchitecture() throws IOException, SQLException {
        Architecture a = this.table.getConnector().getDistribution().getArchitecture().get(this.minimumProcessorArchitecture);
        if (a == null) {
            throw new SQLException("Unable to find Architecture: " + this.minimumProcessorArchitecture);
        }
        return a;
    }

    public int getMinimumProcessorSpeed() {
        return this.minimumProcessorSpeed;
    }

    public int getMinimumProcessorSpeedTarget() {
        return this.minimumProcessorSpeedTarget;
    }

    public short getProcessorCores() {
        return this.processorCores;
    }

    public short getProcessorCoresTarget() {
        return this.processorCoresTarget;
    }

    public short getProcessorWeight() {
        return this.processorWeight;
    }

    public short getProcessorWeightTarget() {
        return this.processorWeightTarget;
    }

    public boolean isPrimaryPhysicalServerLocked() {
        return this.primaryPhysicalServerLocked;
    }

    public boolean isSecondaryPhysicalServerLocked() {
        return this.secondaryPhysicalServerLocked;
    }

    public boolean getRequiresHvm() {
        return this.requiresHvm;
    }

    public String getVncPassword() {
        return this.vncPassword;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.VIRTUAL_SERVERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.primaryRam = result.getInt(pos++);
        this.primaryRamTarget = result.getInt(pos++);
        this.secondaryRam = result.getInt(pos++);
        if (result.wasNull()) {
            this.secondaryRam = -1;
        }
        this.secondaryRamTarget = result.getInt(pos++);
        if (result.wasNull()) {
            this.secondaryRamTarget = -1;
        }
        this.minimumProcessorType = result.getString(pos++);
        this.minimumProcessorArchitecture = result.getString(pos++);
        this.minimumProcessorSpeed = result.getInt(pos++);
        if (result.wasNull()) {
            this.minimumProcessorSpeed = -1;
        }
        this.minimumProcessorSpeedTarget = result.getInt(pos++);
        if (result.wasNull()) {
            this.minimumProcessorSpeedTarget = -1;
        }
        this.processorCores = result.getShort(pos++);
        this.processorCoresTarget = result.getShort(pos++);
        this.processorWeight = result.getShort(pos++);
        this.processorWeightTarget = result.getShort(pos++);
        this.primaryPhysicalServerLocked = result.getBoolean(pos++);
        this.secondaryPhysicalServerLocked = result.getBoolean(pos++);
        this.requiresHvm = result.getBoolean(pos++);
        this.vncPassword = result.getString(pos++);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.primaryRam = in.readCompressedInt();
        this.primaryRamTarget = in.readCompressedInt();
        this.secondaryRam = in.readCompressedInt();
        this.secondaryRamTarget = in.readCompressedInt();
        this.minimumProcessorType = InternUtils.intern((String)in.readNullUTF());
        this.minimumProcessorArchitecture = in.readUTF().intern();
        this.minimumProcessorSpeed = in.readCompressedInt();
        this.minimumProcessorSpeedTarget = in.readCompressedInt();
        this.processorCores = in.readShort();
        this.processorCoresTarget = in.readShort();
        this.processorWeight = in.readShort();
        this.processorWeightTarget = in.readShort();
        this.primaryPhysicalServerLocked = in.readBoolean();
        this.secondaryPhysicalServerLocked = in.readBoolean();
        this.requiresHvm = in.readBoolean();
        this.vncPassword = in.readNullUTF();
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getHost().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.primaryRam);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) >= 0) {
            out.writeCompressedInt(this.primaryRamTarget);
        }
        out.writeCompressedInt(this.secondaryRam);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) >= 0) {
            out.writeCompressedInt(this.secondaryRamTarget);
        }
        out.writeNullUTF(this.minimumProcessorType);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeNullUTF(this.secondaryRam == -1 ? null : this.minimumProcessorType);
        }
        out.writeUTF(this.minimumProcessorArchitecture);
        out.writeCompressedInt(this.minimumProcessorSpeed);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) >= 0) {
            out.writeCompressedInt(this.minimumProcessorSpeedTarget);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeCompressedInt(this.secondaryRam == -1 ? -1 : this.minimumProcessorSpeed);
        }
        out.writeShort((int)this.processorCores);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) >= 0) {
            out.writeShort((int)this.processorCoresTarget);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeShort(this.secondaryRam == -1 ? -1 : (int)this.processorCores);
        }
        out.writeShort((int)this.processorWeight);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) >= 0) {
            out.writeShort((int)this.processorWeightTarget);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeShort(this.secondaryRam == -1 ? -1 : (int)this.processorWeight);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeCompressedInt(-1);
        }
        out.writeBoolean(this.primaryPhysicalServerLocked);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) <= 0) {
            out.writeCompressedInt(-1);
        }
        out.writeBoolean(this.secondaryPhysicalServerLocked);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_37) >= 0) {
            out.writeBoolean(this.requiresHvm);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_51) >= 0) {
            out.writeNullUTF(this.vncPassword);
        }
    }

    public List<VirtualDisk> getVirtualDisks() throws IOException, SQLException {
        return this.table.getConnector().getInfrastructure().getVirtualDisk().getVirtualDisks(this);
    }

    public VirtualDisk getVirtualDisk(String device) throws IOException, SQLException {
        for (VirtualDisk vd : this.getVirtualDisks()) {
            if (!vd.getDevice().equals(device)) continue;
            return vd;
        }
        return null;
    }

    public Server.DaemonAccess requestVncConsoleAccess() throws IOException, SQLException {
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.REQUEST_VNC_CONSOLE_DAEMON_ACCESS, new AoservConnector.ResultRequest<Server.DaemonAccess>(){
            private Server.DaemonAccess daemonAccess;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(VirtualServer.this.pkey);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code == 1) {
                    try {
                        this.daemonAccess = new Server.DaemonAccess(in.readUTF(), HostAddress.valueOf((String)in.readUTF()), Port.valueOf((int)in.readCompressedInt(), (Protocol)Protocol.TCP), in.readLong());
                    }
                    catch (ValidationException e) {
                        throw new IOException(e);
                    }
                } else {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
            }

            @Override
            public Server.DaemonAccess afterRelease() {
                return this.daemonAccess;
            }
        });
    }

    public String create() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(false, AoservProtocol.CommandId.CREATE_VIRTUAL_SERVER, this.pkey);
    }

    public String reboot() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(false, AoservProtocol.CommandId.REBOOT_VIRTUAL_SERVER, this.pkey);
    }

    public String shutdown() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(false, AoservProtocol.CommandId.SHUTDOWN_VIRTUAL_SERVER, this.pkey);
    }

    public String destroy() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(false, AoservProtocol.CommandId.DESTROY_VIRTUAL_SERVER, this.pkey);
    }

    public String pause() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(false, AoservProtocol.CommandId.PAUSE_VIRTUAL_SERVER, this.pkey);
    }

    public String unpause() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(false, AoservProtocol.CommandId.UNPAUSE_VIRTUAL_SERVER, this.pkey);
    }

    public static String getStatusList(int status) {
        StringBuilder sb = new StringBuilder();
        if ((status & 1) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("Running");
        }
        if ((status & 2) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("Blocked");
        }
        if ((status & 4) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("Paused");
        }
        if ((status & 8) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("Shutdown");
        }
        if ((status & 0x10) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("Crashed");
        }
        if ((status & 0x20) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("Dying");
        }
        if ((status & 0x40) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("Destroyed");
        }
        return sb.toString();
    }

    public int getStatus() throws IOException, SQLException {
        return this.table.getConnector().requestIntQuery(true, AoservProtocol.CommandId.GET_VIRTUAL_SERVER_STATUS, this.pkey);
    }

    public PhysicalServer getPrimaryPhysicalServer() throws IOException, SQLException {
        return this.table.getConnector().getInfrastructure().getPhysicalServer().get(this.table.getConnector().requestIntQuery(true, AoservProtocol.CommandId.GET_PRIMARY_PHYSICAL_SERVER, this.pkey));
    }

    public PhysicalServer getSecondaryPhysicalServer() throws IOException, SQLException {
        return this.table.getConnector().getInfrastructure().getPhysicalServer().get(this.table.getConnector().requestIntQuery(true, AoservProtocol.CommandId.GET_SECONDARY_PHYSICAL_SERVER, this.pkey));
    }
}

