/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.infrastructure;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.infrastructure.VirtualServer;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;

public final class VirtualServerTable
extends CachedTableIntegerKey<VirtualServer> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("server.package.name", true), new AoservTable.OrderBy("server.name", true)};

    VirtualServerTable(AoservConnector connector) {
        super(connector, VirtualServer.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public VirtualServer get(int server) throws IOException, SQLException {
        return (VirtualServer)this.getUniqueRow(0, server);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.VIRTUAL_SERVERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("create_virtual_server")) {
            if (Aosh.checkParamCount("create_virtual_server", args, 1, (PrintWriter)err)) {
                out.print(this.connector.getSimpleClient().createVirtualServer(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("reboot_virtual_server")) {
            if (Aosh.checkParamCount("reboot_virtual_server", args, 1, (PrintWriter)err)) {
                out.print(this.connector.getSimpleClient().rebootVirtualServer(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("shutdown_virtual_server")) {
            if (Aosh.checkParamCount("shutdown_virtual_server", args, 1, (PrintWriter)err)) {
                out.print(this.connector.getSimpleClient().shutdownVirtualServer(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("destroy_virtual_server")) {
            if (Aosh.checkParamCount("destroy_virtual_server", args, 1, (PrintWriter)err)) {
                out.print(this.connector.getSimpleClient().destroyVirtualServer(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("pause_virtual_server")) {
            if (Aosh.checkParamCount("pause_virtual_server", args, 1, (PrintWriter)err)) {
                out.print(this.connector.getSimpleClient().pauseVirtualServer(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("unpause_virtual_server")) {
            if (Aosh.checkParamCount("unpause_virtual_server", args, 1, (PrintWriter)err)) {
                out.print(this.connector.getSimpleClient().unpauseVirtualServer(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_virtual_server_status")) {
            if (Aosh.checkParamCount("get_virtual_server_status", args, 1, (PrintWriter)err)) {
                out.println(VirtualServer.getStatusList(this.connector.getSimpleClient().getVirtualServerStatus(args[1])));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_primary_physical_server")) {
            if (Aosh.checkParamCount("get_primary_physical_server", args, 1, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().getPrimaryVirtualServer(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_secondary_physical_server")) {
            if (Aosh.checkParamCount("get_secondary_physical_server", args, 1, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().getSecondaryVirtualServer(args[1]));
                out.flush();
            }
            return true;
        }
        return false;
    }
}

