/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.HostAddress;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.dto.LinuxDaemonAcl;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class DaemonAcl
extends CachedObjectIntegerKey<DaemonAcl>
implements DtoFactory<LinuxDaemonAcl> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_AO_SERVER = 1;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_HOST_name = "host";
    private int aoServer;
    private HostAddress host;

    @Deprecated
    public DaemonAcl() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.aoServer;
            }
            case 2: {
                return this.host;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public HostAddress getHost() {
        return this.host;
    }

    public Server getServer() throws SQLException, IOException {
        Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.AO_SERVER_DAEMON_HOSTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.aoServer = result.getInt(2);
            this.host = HostAddress.valueOf((String)result.getString(3));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.aoServer = in.readCompressedInt();
            this.host = HostAddress.valueOf((String)in.readUTF().intern());
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.aoServer + "|" + this.host;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.aoServer);
        out.writeUTF(this.host.toString());
    }

    public LinuxDaemonAcl getDto() {
        return new LinuxDaemonAcl(this.getPkey(), this.aoServer, (com.aoapps.net.dto.HostAddress)DaemonAcl.getDto(this.host));
    }
}

