/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.dto.LinuxGroupName;
import com.aoindustries.aoserv.client.linux.CachedObjectGroupNameKey;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.GroupType;
import com.aoindustries.aoserv.client.linux.GroupUser;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Group
extends CachedObjectGroupNameKey<Group>
implements Removable {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Group.class);
    static final int COLUMN_NAME = 0;
    static final int COLUMN_PACKAGE = 1;
    static final String COLUMN_NAME_name = "name";
    public static final Name ADM;
    public static final Name AOADMIN;
    public static final Name AOSERV_JILTER;
    public static final Name AOSERV_XEN_MIGRATION;
    public static final Name APACHE;
    public static final Name AUDIO;
    public static final Name AVAHI_AUTOIPD;
    public static final Name AWSTATS;
    public static final Name BIN;
    public static final Name BIRD;
    public static final Name CDROM;
    public static final Name CGRED;
    public static final Name CHRONY;
    public static final Name CLAMSCAN;
    public static final Name CLAMUPDATE;
    public static final Name DAEMON;
    public static final Name DBUS;
    public static final Name DHCPD;
    public static final Name DIALOUT;
    public static final Name DIP;
    public static final Name DISK;
    public static final Name FLOPPY;
    public static final Name FTP;
    public static final Name FTPONLY;
    public static final Name GAMES;
    public static final Name INPUT;
    public static final Name KMEM;
    public static final Name LOCK;
    public static final Name LP;
    public static final Name MAIL;
    public static final Name MAILNULL;
    public static final Name MAILONLY;
    public static final Name MAN;
    public static final Name MEM;
    public static final Name MEMCACHED;
    public static final Name MYSQL;
    public static final Name NAMED;
    public static final Name NFSNOBODY;
    public static final Name NGINX;
    public static final Name NOBODY;
    public static final Name NOGROUP;
    public static final Name POLKITD;
    public static final Name POSTGRES;
    public static final Name REDIS;
    public static final Name ROOT;
    public static final Name RPC;
    public static final Name RPCUSER;
    public static final Name SASLAUTH;
    public static final Name SCREEN;
    public static final Name SMMSP;
    public static final Name SSH_KEYS;
    public static final Name SSHD;
    public static final Name SYS;
    public static final Name SYSTEMD_BUS_PROXY;
    public static final Name SYSTEMD_JOURNAL;
    public static final Name SYSTEMD_NETWORK;
    public static final Name TAPE;
    public static final Name TCPDUMP;
    public static final Name TSS;
    public static final Name TTY;
    public static final Name UNBOUND;
    public static final Name USERS;
    public static final Name UTEMPTER;
    public static final Name UTMP;
    public static final Name VIDEO;
    public static final Name VIRUSGROUP;
    public static final Name WHEEL;
    public static final Name AOSERV_MASTER;
    public static final Name ACCOUNTING;
    public static final Name BILLING;
    public static final Name DISTRIBUTION;
    public static final Name INFRASTRUCTURE;
    public static final Name MANAGEMENT;
    public static final Name MONITORING;
    public static final Name RESELLER;
    public static final Name CENTOS;
    public static final Name JENKINS;
    public static final Name OPROFILE;
    public static final Name SONARQUBE;
    public static final Name STAPUSR;
    public static final Name STAPSYS;
    public static final Name STAPDEV;
    @Deprecated
    public static final Name HTTPD;
    private Account.Name packageName;
    private String type;

    @Deprecated
    public Group() {
    }

    public int addLinuxAccount(User user) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupUser().addLinuxGroupAccount(this, user);
    }

    public int addLinuxServerGroup(Server aoServer) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupServer().addLinuxServerGroup(this, aoServer);
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.packageName;
            }
            case 2: {
                return this.type;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public GroupType getLinuxGroupType() throws SQLException, IOException {
        GroupType typeObject = this.table.getConnector().getLinux().getGroupType().get(this.type);
        if (typeObject == null) {
            throw new SQLException("Unable to find LinuxGroupType: " + this.type);
        }
        return typeObject;
    }

    public GroupServer getLinuxServerGroup(Server aoServer) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupServer().getLinuxServerGroup(aoServer, this.pkey);
    }

    public List<GroupServer> getLinuxServerGroups() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupServer().getLinuxServerGroups(this);
    }

    public Name getName() {
        return this.pkey;
    }

    public Account.Name getPackage_name() {
        return this.packageName;
    }

    public Package getPackage() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().get(this.packageName);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_GROUPS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = Name.valueOf(result.getString(1));
            this.packageName = Account.Name.valueOf(result.getString(2));
            this.type = result.getString(3);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = Name.valueOf(in.readUTF()).intern();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
            this.type = in.readUTF().intern();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws IOException, SQLException {
        ArrayList reasons = new ArrayList();
        for (GroupUser lga : this.table.getConnector().getLinux().getGroupUser().getRows()) {
            if (!lga.isPrimary() || !this.equals(lga.getGroup())) continue;
            reasons.add(new CannotRemoveReason<GroupUser>("Used as primary group for Linux account " + lga.getUser().getUsername().getUsername(), lga));
        }
        for (GroupServer lsg : this.getLinuxServerGroups()) {
            reasons.addAll(lsg.getCannotRemoveReasons());
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.LINUX_GROUPS, this.pkey});
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        out.writeUTF(this.packageName.toString());
        out.writeUTF(this.type);
    }

    static {
        try {
            ADM = Name.valueOf("adm");
            AOADMIN = Name.valueOf("aoadmin");
            AOSERV_JILTER = Name.valueOf("aoserv-jilter");
            AOSERV_XEN_MIGRATION = Name.valueOf("aoserv-xen-migration");
            APACHE = Name.valueOf("apache");
            AUDIO = Name.valueOf("audio");
            AVAHI_AUTOIPD = Name.valueOf("avahi-autoipd");
            AWSTATS = Name.valueOf("awstats");
            BIN = Name.valueOf("bin");
            BIRD = Name.valueOf("bird");
            CDROM = Name.valueOf("cdrom");
            CGRED = Name.valueOf("cgred");
            CHRONY = Name.valueOf("chrony");
            CLAMSCAN = Name.valueOf("clamscan");
            CLAMUPDATE = Name.valueOf("clamupdate");
            DAEMON = Name.valueOf("daemon");
            DBUS = Name.valueOf("dbus");
            DHCPD = Name.valueOf("dhcpd");
            DIALOUT = Name.valueOf("dialout");
            DIP = Name.valueOf("dip");
            DISK = Name.valueOf("disk");
            FLOPPY = Name.valueOf("floppy");
            FTP = Name.valueOf("ftp");
            FTPONLY = Name.valueOf("ftponly");
            GAMES = Name.valueOf("games");
            INPUT = Name.valueOf("input");
            KMEM = Name.valueOf("kmem");
            LOCK = Name.valueOf("lock");
            LP = Name.valueOf("lp");
            MAIL = Name.valueOf("mail");
            MAILNULL = Name.valueOf("mailnull");
            MAILONLY = Name.valueOf("mailonly");
            MAN = Name.valueOf("man");
            MEM = Name.valueOf("mem");
            MEMCACHED = Name.valueOf("memcached");
            MYSQL = Name.valueOf("mysql");
            NAMED = Name.valueOf("named");
            NGINX = Name.valueOf("nginx");
            NFSNOBODY = Name.valueOf("nfsnobody");
            NOBODY = Name.valueOf("nobody");
            NOGROUP = Name.valueOf("nogroup");
            POLKITD = Name.valueOf("polkitd");
            POSTGRES = Name.valueOf("postgres");
            REDIS = Name.valueOf("redis");
            ROOT = Name.valueOf("root");
            RPC = Name.valueOf("rpc");
            RPCUSER = Name.valueOf("rpcuser");
            SASLAUTH = Name.valueOf("saslauth");
            SCREEN = Name.valueOf("screen");
            SMMSP = Name.valueOf("smmsp");
            SSH_KEYS = Name.valueOf("ssh_keys");
            SSHD = Name.valueOf("sshd");
            SYS = Name.valueOf("sys");
            SYSTEMD_BUS_PROXY = Name.valueOf("systemd-bus-proxy");
            SYSTEMD_JOURNAL = Name.valueOf("systemd-journal");
            SYSTEMD_NETWORK = Name.valueOf("systemd-network");
            TAPE = Name.valueOf("tape");
            TCPDUMP = Name.valueOf("tcpdump");
            TSS = Name.valueOf("tss");
            TTY = Name.valueOf("tty");
            UNBOUND = Name.valueOf("unbound");
            USERS = Name.valueOf("users");
            UTEMPTER = Name.valueOf("utempter");
            UTMP = Name.valueOf("utmp");
            VIDEO = Name.valueOf("video");
            VIRUSGROUP = Name.valueOf("virusgroup");
            WHEEL = Name.valueOf("wheel");
            AOSERV_MASTER = Name.valueOf("aoserv-master");
            ACCOUNTING = Name.valueOf("accounting");
            BILLING = Name.valueOf("billing");
            DISTRIBUTION = Name.valueOf("distribution");
            INFRASTRUCTURE = Name.valueOf("infrastructure");
            MANAGEMENT = Name.valueOf("management");
            MONITORING = Name.valueOf("monitoring");
            RESELLER = Name.valueOf("reseller");
            CENTOS = Name.valueOf("centos");
            JENKINS = Name.valueOf("jenkins");
            OPROFILE = Name.valueOf("oprofile");
            SONARQUBE = Name.valueOf("sonarqube");
            STAPUSR = Name.valueOf("stapusr");
            STAPSYS = Name.valueOf("stapsys");
            STAPDEV = Name.valueOf("stapdev");
            HTTPD = Name.valueOf("httpd");
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
    }

    public static final class Name
    implements Comparable<Name>,
    Serializable,
    DtoFactory<LinuxGroupName>,
    Internable<Name> {
        private static final long serialVersionUID = 5758732021942097608L;
        public static final int MAX_LENGTH = 32;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private final String name;

        public static ValidationResult validate(String name) {
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = name.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
            }
            if (len > 32) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(32), Integer.valueOf(len)});
            }
            char ch = name.charAt(0);
            if (ch < 'a' || ch > 'z') {
                return new InvalidResult(RESOURCES, "Name.validate.startAToZ");
            }
            for (int c = 1; c < len; ++c) {
                ch = name.charAt(c);
                if (ch == ' ') {
                    return new InvalidResult(RESOURCES, "Name.validate.noSpace");
                }
                if (ch <= '!' || ch > '\u007f') {
                    return new InvalidResult(RESOURCES, "Name.validate.specialCharacter");
                }
                if (ch >= 'A' && ch <= 'Z') {
                    return new InvalidResult(RESOURCES, "Name.validate.noCapital");
                }
                switch (ch) {
                    case ',': {
                        return new InvalidResult(RESOURCES, "Name.validate.comma");
                    }
                    case ':': {
                        return new InvalidResult(RESOURCES, "Name.validate.colon");
                    }
                    case '(': {
                        return new InvalidResult(RESOURCES, "Name.validate.leftParen");
                    }
                    case ')': {
                        return new InvalidResult(RESOURCES, "Name.validate.rightParen");
                    }
                    case '[': {
                        return new InvalidResult(RESOURCES, "Name.validate.leftSquare");
                    }
                    case ']': {
                        return new InvalidResult(RESOURCES, "Name.validate.rightSquare");
                    }
                    case '\'': {
                        return new InvalidResult(RESOURCES, "Name.validate.apostrophe");
                    }
                    case '\"': {
                        return new InvalidResult(RESOURCES, "Name.validate.quote");
                    }
                    case '|': {
                        return new InvalidResult(RESOURCES, "Name.validate.verticalBar");
                    }
                    case '&': {
                        return new InvalidResult(RESOURCES, "Name.validate.ampersand");
                    }
                    case ';': {
                        return new InvalidResult(RESOURCES, "Name.validate.semicolon");
                    }
                    case '\\': {
                        return new InvalidResult(RESOURCES, "Name.validate.backslash");
                    }
                    case '/': {
                        return new InvalidResult(RESOURCES, "Name.validate.slash");
                    }
                    case '@': {
                        return new InvalidResult(RESOURCES, "Name.validate.at");
                    }
                }
            }
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name, true);
        }

        private Name(String name, boolean validate) throws ValidationException {
            this.name = name;
            if (validate) {
                this.validate();
            }
        }

        private Name(String name) {
            ValidationResult result;
            assert ((result = Name.validate(name)).isValid()) : result.toString();
            this.name = name;
        }

        private void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            try {
                this.validate();
            }
            catch (ValidationException err) {
                InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
                newErr.initCause(err);
                throw newErr;
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof Name && this.name.equals(((Name)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Name other) {
            return this == other ? 0 : this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name;
        }

        public Name intern() {
            Name addMe;
            String internedId;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedId, addMe = this.name == (internedId = this.name.intern()) ? this : new Name(internedId))) == null) {
                existing = addMe;
            }
            return existing;
        }

        public LinuxGroupName getDto() {
            return new LinuxGroupName(this.name);
        }
    }
}

