/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.LinuxId;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.scm.CvsRepository;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public final class GroupServer
extends CachedObjectIntegerKey<GroupServer>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_NAME = 1;
    static final int COLUMN_AO_SERVER = 2;
    static final String COLUMN_NAME_name = "name";
    static final String COLUMN_AO_SERVER_name = "ao_server";
    private Group.Name name;
    private int aoServer;
    private LinuxId gid;
    private UnmodifiableTimestamp created;

    @Deprecated
    public GroupServer() {
    }

    public List<UserServer> getAlternateLinuxServerAccounts() throws SQLException, IOException {
        return this.table.getConnector().getLinux().getUserServer().getAlternateLinuxServerAccounts(this);
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.aoServer;
            }
            case 3: {
                return this.gid;
            }
            case 4: {
                return this.created;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public LinuxId getGid() {
        return this.gid;
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public Group.Name getLinuxGroup_name() {
        return this.name;
    }

    public Group getLinuxGroup() throws SQLException, IOException {
        Group group = this.table.getConnector().getLinux().getGroup().get(this.name);
        if (group == null) {
            throw new SQLException("Unable to find LinuxGroup: " + this.name);
        }
        return group;
    }

    public int getServer_host_id() {
        return this.aoServer;
    }

    public Server getServer() throws SQLException, IOException {
        Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_SERVER_GROUPS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.name = Group.Name.valueOf(result.getString(2));
            this.aoServer = result.getInt(3);
            this.gid = LinuxId.valueOf(result.getInt(4));
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(5));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.name = Group.Name.valueOf(in.readUTF()).intern();
            this.aoServer = in.readCompressedInt();
            this.gid = LinuxId.valueOf(in.readCompressedInt());
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList reasons = new ArrayList();
        Server ao = this.getServer();
        for (CvsRepository cr : ao.getCvsRepositories()) {
            if (cr.getLinuxServerGroup_pkey() != this.pkey) continue;
            reasons.add(new CannotRemoveReason<CvsRepository>("Used by CVS repository " + cr.getPath() + " on " + cr.getLinuxServerGroup().getServer().getHostname(), cr));
        }
        for (com.aoindustries.aoserv.client.email.List el : this.table.getConnector().getEmail().getList().getRows()) {
            if (el.getLinuxServerGroup_pkey() != this.pkey) continue;
            reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.email.List>("Used by email list " + el.getPath() + " on " + el.getLinuxServerGroup().getServer().getHostname(), el));
        }
        for (HttpdServer hs : ao.getHttpdServers()) {
            if (hs.getLinuxServerGroup_pkey() != this.pkey) continue;
            String hs_name = hs.getName();
            reasons.add(new CannotRemoveReason<HttpdServer>(hs_name == null ? "Used by Apache HTTP Server on " + hs.getLinuxServer().getHostname() : "Used by Apache HTTP Server (" + hs_name + ") on " + hs.getLinuxServer().getHostname(), hs));
        }
        for (SharedTomcat hst : ao.getHttpdSharedTomcats()) {
            if (hst.getLinuxServerGroup_pkey() != this.pkey) continue;
            reasons.add(new CannotRemoveReason<SharedTomcat>("Used by Multi-Site Tomcat JVM " + hst.getInstallDirectory() + " on " + hst.getLinuxServer().getHostname(), hst));
        }
        for (Site site : ao.getHttpdSites()) {
            if (!site.getLinuxGroup_name().equals(this.name)) continue;
            reasons.add(new CannotRemoveReason<Site>("Used by website " + site.getInstallDirectory() + " on " + site.getLinuxServer().getHostname(), site));
        }
        for (MajordomoServer ms : ao.getMajordomoServers()) {
            if (ms.getLinuxServerGroup_pkey() != this.pkey) continue;
            Domain ed = ms.getDomain();
            reasons.add(new CannotRemoveReason<MajordomoServer>("Used by Majordomo server " + ed.getDomain() + " on " + ed.getLinuxServer().getHostname(), ms));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.LINUX_SERVER_GROUPS, this.pkey});
    }

    @Override
    public String toStringImpl() {
        return this.name.toString();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.name.toString());
        out.writeCompressedInt(this.aoServer);
        out.writeCompressedInt(this.gid.getId());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
    }
}

