/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.LinuxId;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GroupServerTable
extends CachedTableIntegerKey<GroupServer> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true), new AoservTable.OrderBy("ao_server.hostname", true)};
    private boolean nameHashBuilt;
    private final Map<Integer, Map<Group.Name, GroupServer>> nameHash = new HashMap<Integer, Map<Group.Name, GroupServer>>();
    private boolean gidHashBuilt;
    private final Map<Integer, Map<LinuxId, GroupServer>> gidHash = new HashMap<Integer, Map<LinuxId, GroupServer>>();

    GroupServerTable(AoservConnector connector) {
        super(connector, GroupServer.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addLinuxServerGroup(Group linuxGroup, Server aoServer) throws IOException, SQLException {
        int pkey = this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.LINUX_SERVER_GROUPS, linuxGroup.getName(), aoServer.getPkey()});
        return pkey;
    }

    int addSystemGroup(Server aoServer, Group.Name groupName, int gid) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD_SYSTEM_GROUP, aoServer.getPkey(), groupName, gid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Map<Integer, Map<Comparable<LinuxId>, GroupServer>> map = this.gidHash;
        synchronized (map) {
            this.gidHashBuilt = false;
        }
        map = this.nameHash;
        synchronized (map) {
            this.nameHashBuilt = false;
        }
    }

    @Override
    public GroupServer get(int pkey) throws IOException, SQLException {
        return (GroupServer)this.getUniqueRow(0, pkey);
    }

    public GroupServer getLinuxServerGroup(Server aoServer, Account business) throws IOException, SQLException {
        Account.Name accounting = business.getName();
        int aoPkey = aoServer.getPkey();
        List list = this.getRows();
        int len = list.size();
        for (int c = 0; c < len; ++c) {
            Group linuxGroup;
            Package pk;
            GroupServer group = (GroupServer)list.get(c);
            if (aoPkey != group.getServer_host_id() || (pk = (linuxGroup = group.getLinuxGroup()).getPackage()) == null || !pk.getAccount_name().equals(accounting) || !linuxGroup.getLinuxGroupType().getName().equals("user")) continue;
            return group;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupServer getLinuxServerGroup(Server aoServer, Group.Name groupName) throws IOException, SQLException {
        Map<Integer, Map<Group.Name, GroupServer>> map = this.nameHash;
        synchronized (map) {
            Map<Group.Name, GroupServer> serverHash;
            if (!this.nameHashBuilt) {
                this.nameHash.clear();
                List list = this.getRows();
                int len = list.size();
                for (int c = 0; c < len; ++c) {
                    GroupServer lsg = (GroupServer)list.get(c);
                    Integer i = lsg.getServer_host_id();
                    Map<Group.Name, GroupServer> serverHash2 = this.nameHash.get(i);
                    if (serverHash2 == null) {
                        serverHash2 = new HashMap<Group.Name, GroupServer>();
                        this.nameHash.put(i, serverHash2);
                    }
                    if (serverHash2.put(lsg.getLinuxGroup_name(), lsg) == null) continue;
                    throw new SQLException("LinuxServerGroup name exists more than once on server: " + lsg.getLinuxGroup_name() + " on " + i);
                }
                this.nameHashBuilt = true;
            }
            if ((serverHash = this.nameHash.get(aoServer.getPkey())) == null) {
                return null;
            }
            return serverHash.get(groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupServer getLinuxServerGroup(Server aoServer, LinuxId gid) throws IOException, SQLException {
        Map<Integer, Map<LinuxId, GroupServer>> map = this.gidHash;
        synchronized (map) {
            Map<LinuxId, GroupServer> serverHash;
            if (!this.gidHashBuilt) {
                this.gidHash.clear();
                List list = this.getRows();
                int len = list.size();
                for (int c = 0; c < len; ++c) {
                    LinuxId gidI;
                    GroupServer lsg = (GroupServer)list.get(c);
                    Integer serverI = lsg.getServer_host_id();
                    Map<LinuxId, GroupServer> serverHash2 = this.gidHash.get(serverI);
                    if (serverHash2 == null) {
                        serverHash2 = new HashMap<LinuxId, GroupServer>();
                        this.gidHash.put(serverI, serverHash2);
                    }
                    if (serverHash2.put(gidI = lsg.getGid(), lsg) == null) continue;
                    throw new SQLException("GID exists more than once on server: " + gidI + " on " + serverI);
                }
                this.gidHashBuilt = true;
            }
            if ((serverHash = this.gidHash.get(aoServer.getPkey())) == null) {
                return null;
            }
            return serverHash.get(gid);
        }
    }

    List<GroupServer> getLinuxServerGroups(Server aoServer) throws IOException, SQLException {
        return this.getIndexedRows(2, aoServer.getPkey());
    }

    List<GroupServer> getLinuxServerGroups(Group lg) throws IOException, SQLException {
        return this.getIndexedRows(1, lg.getName());
    }

    GroupServer getPrimaryLinuxServerGroup(UserServer account) throws SQLException, IOException {
        if (account == null) {
            throw new IllegalArgumentException("account=null");
        }
        User linuxAccount = account.getLinuxAccount();
        Group linuxGroup = this.connector.getLinux().getGroupUser().getPrimaryGroup(linuxAccount);
        if (linuxGroup == null) {
            throw new SQLException("Unable to find primary LinuxGroup for username=" + linuxAccount.getUsername_id());
        }
        GroupServer lsg = this.getLinuxServerGroup(account.getServer(), linuxGroup.getName());
        if (lsg == null) {
            throw new SQLException("Unable to find LinuxServerGroup: " + linuxGroup.getName() + " on " + account.getAoServer_server_id());
        }
        return lsg;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_SERVER_GROUPS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_linux_server_group")) {
            if (Aosh.checkParamCount("add_linux_server_group", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addLinuxServerGroup(Aosh.parseGroupName(args[1], "group"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_linux_server_group")) {
            if (Aosh.checkParamCount("remove_linux_server_group", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeLinuxServerGroup(Aosh.parseGroupName(args[1], "group"), args[2]);
            }
            return true;
        }
        return false;
    }
}

