/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.linux.CachedTableGroupNameKey;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class GroupTable
extends CachedTableGroupNameKey<Group> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true)};

    GroupTable(AoservConnector connector) {
        super(connector, Group.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public void addLinuxGroup(Group.Name name, Package packageObject, String type) throws IOException, SQLException {
        this.connector.requestUpdateInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.LINUX_GROUPS, name, packageObject.getName(), type});
    }

    @Override
    public Group get(Group.Name name) throws IOException, SQLException {
        return (Group)this.getUniqueRow(0, name);
    }

    public List<Group> getLinuxGroups(Package pack) throws IOException, SQLException {
        return this.getIndexedRows(1, pack.getName());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_GROUPS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_linux_group")) {
            if (Aosh.checkParamCount("add_linux_group", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().addLinuxGroup(Aosh.parseGroupName(args[1], "group"), Aosh.parseAccountingCode(args[2], "package"), args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_linux_group_name")) {
            if (Aosh.checkParamCount("check_linux_group_name", args, 1, (PrintWriter)err)) {
                ValidationResult validationResult = Group.Name.validate(args[1]);
                out.println(validationResult.isValid());
                out.flush();
                if (!validationResult.isValid()) {
                    err.print("aosh: check_linux_group_name: ");
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_linux_group_name_available")) {
            if (Aosh.checkParamCount("is_linux_group_name_available", args, 1, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().isLinuxGroupNameAvailable(Aosh.parseGroupName(args[1], "groupname")));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: is_linux_group_name_available: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_linux_group")) {
            if (Aosh.checkParamCount("remove_linux_group", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeLinuxGroup(Aosh.parseGroupName(args[1], "group"));
            }
            return true;
        }
        return false;
    }

    public boolean isLinuxGroupNameAvailable(Group.Name groupname) throws SQLException, IOException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_LINUX_GROUP_NAME_AVAILABLE, groupname);
    }
}

