/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class GroupUser
extends CachedObjectIntegerKey<GroupUser>
implements Removable {
    static final int COLUMN_ID = 0;
    static final String COLUMN_GROUP_name = "group";
    static final String COLUMN_USER_name = "user";
    public static final int MAX_GROUPS = 65536;
    private Group.Name group;
    private User.Name user;
    private boolean isPrimary;
    private int operatingSystemVersion;

    @Deprecated
    public GroupUser() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.group;
            }
            case 2: {
                return this.user;
            }
            case 3: {
                return this.isPrimary;
            }
            case 4: {
                return this.operatingSystemVersion == -1 ? null : Integer.valueOf(this.operatingSystemVersion);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public Group.Name getGroup_name() {
        return this.group;
    }

    public Group getGroup() throws SQLException, IOException {
        Group groupNameObject = this.table.getConnector().getLinux().getGroup().get(this.group);
        if (groupNameObject == null) {
            throw new SQLException("Unable to find LinuxGroup: " + this.group);
        }
        return groupNameObject;
    }

    public User.Name getUser_username() {
        return this.user;
    }

    public User getUser() throws SQLException, IOException {
        User usernameObject = this.table.getConnector().getLinux().getUser().get(this.user);
        if (usernameObject == null) {
            throw new SQLException("Unable to find LinuxAccount: " + this.user);
        }
        return usernameObject;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public Integer getOperatingSystemVersion_pkey() {
        return this.operatingSystemVersion == -1 ? null : Integer.valueOf(this.operatingSystemVersion);
    }

    public OperatingSystemVersion getOperatingSystemVersion() throws SQLException, IOException {
        if (this.operatingSystemVersion == -1) {
            return null;
        }
        OperatingSystemVersion osv = this.table.getConnector().getDistribution().getOperatingSystemVersion().get(this.operatingSystemVersion);
        if (osv == null) {
            throw new SQLException("Unable to find OperatingSystemVersion: " + this.operatingSystemVersion);
        }
        return osv;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.group = Group.Name.valueOf(result.getString(pos++));
            this.user = User.Name.valueOf(result.getString(pos++));
            this.isPrimary = result.getBoolean(pos++);
            this.operatingSystemVersion = result.getInt(pos++);
            if (result.wasNull()) {
                this.operatingSystemVersion = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.group = Group.Name.valueOf(in.readUTF()).intern();
            this.user = User.Name.valueOf(in.readUTF()).intern();
            this.isPrimary = in.readBoolean();
            this.operatingSystemVersion = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.group.toString());
        out.writeUTF(this.user.toString());
        out.writeBoolean(this.isPrimary);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80_1) >= 0) {
            out.writeCompressedInt(this.operatingSystemVersion);
        }
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_GROUP_ACCOUNTS;
    }

    public List<CannotRemoveReason<GroupUser>> getCannotRemoveReasons() {
        ArrayList<CannotRemoveReason<GroupUser>> reasons = new ArrayList<CannotRemoveReason<GroupUser>>();
        if (this.isPrimary) {
            reasons.add(new CannotRemoveReason<GroupUser>("Not allowed to drop a primary group", this));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.LINUX_GROUP_ACCOUNTS, this.pkey});
    }

    void setAsPrimary() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_PRIMARY_LINUX_GROUP_ACCOUNT, this.pkey);
    }

    @Override
    public String toStringImpl() {
        return this.group.toString() + '|' + this.user.toString() + (this.isPrimary ? "|p" : "|a");
    }
}

