/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.collections.AoCollections;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.util.Tuple2;
import com.aoapps.lang.NullArgumentException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.GroupUser;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GroupUserTable
extends CachedTableIntegerKey<GroupUser> {
    private boolean hashBuilt;
    private final Map<Tuple2<Group.Name, User.Name>, List<GroupUser>> hash = new HashMap<Tuple2<Group.Name, User.Name>, List<GroupUser>>();
    private boolean primaryHashBuilt;
    private final Map<User.Name, Group.Name> primaryHash = new HashMap<User.Name, Group.Name>();
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("group", true), new AoservTable.OrderBy("user", true)};

    GroupUserTable(AoservConnector connector) {
        super(connector, GroupUser.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addLinuxGroupAccount(Group groupObject, User userObject) throws IOException, SQLException {
        int pkey = this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.LINUX_GROUP_ACCOUNTS, groupObject.getName(), userObject.getUsername()});
        return pkey;
    }

    @Override
    public GroupUser get(int id) throws IOException, SQLException {
        return (GroupUser)this.getUniqueRow(0, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupUser> getLinuxGroupAccounts(Group.Name group, User.Name user) throws IOException, SQLException {
        Map<Tuple2<Group.Name, User.Name>, List<GroupUser>> map = this.hash;
        synchronized (map) {
            List<GroupUser> lgas;
            if (!this.hashBuilt) {
                this.hash.clear();
                for (GroupUser groupUser : this.getRows()) {
                    Tuple2 key = new Tuple2((Object)groupUser.getGroup_name(), (Object)groupUser.getUser_username());
                    List<GroupUser> list = this.hash.get(key);
                    if (list == null) {
                        list = new ArrayList<GroupUser>();
                        this.hash.put((Tuple2<Group.Name, User.Name>)key, list);
                    }
                    list.add(groupUser);
                }
                for (Map.Entry entry : this.hash.entrySet()) {
                    entry.setValue(AoCollections.optimalUnmodifiableList((List)((List)entry.getValue())));
                }
                this.hashBuilt = true;
            }
            if ((lgas = this.hash.get(new Tuple2((Object)group, (Object)user))) == null) {
                return Collections.emptyList();
            }
            return lgas;
        }
    }

    List<Group> getLinuxGroups(User linuxAccount) throws IOException, SQLException {
        User.Name username = linuxAccount.getUsername_id();
        List rows = this.getRows();
        int len = rows.size();
        ArrayList<Group> matches = new ArrayList<Group>(65536);
        for (int c = 0; c < len; ++c) {
            Group lg;
            GroupUser lga = (GroupUser)rows.get(c);
            if (!lga.getUser_username().equals(username) || matches.contains(lg = lga.getGroup())) continue;
            matches.add(lg);
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Group getPrimaryGroup(User account) throws IOException, SQLException {
        NullArgumentException.checkNotNull((Object)account, (String)"account");
        Map<User.Name, Group.Name> map = this.primaryHash;
        synchronized (map) {
            Group.Name groupName;
            if (!this.primaryHashBuilt) {
                List cache = this.getRows();
                this.primaryHash.clear();
                int len = cache.size();
                for (int c = 0; c < len; ++c) {
                    Group.Name groupName2;
                    User.Name username;
                    Group.Name existing;
                    GroupUser lga = (GroupUser)cache.get(c);
                    if (!lga.isPrimary() || (existing = this.primaryHash.put(username = lga.getUser_username(), groupName2 = lga.getGroup_name())) == null || existing.equals(groupName2)) continue;
                    throw new SQLException("Conflicting primary groups for " + username + ": " + existing + " and " + groupName2);
                }
                this.primaryHashBuilt = true;
            }
            if ((groupName = this.primaryHash.get(account.getUsername_id())) == null) {
                return null;
            }
            return this.connector.getLinux().getGroup().get(groupName);
        }
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_GROUP_ACCOUNTS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_linux_group_account")) {
            if (Aosh.checkParamCount("add_linux_group_account", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addLinuxGroupAccount(Aosh.parseGroupName(args[1], "group"), Aosh.parseLinuxUserName(args[2], "username")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_linux_group_account")) {
            if (Aosh.checkParamCount("remove_linux_group_account", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeLinuxGroupAccount(Aosh.parseGroupName(args[1], "group"), Aosh.parseLinuxUserName(args[2], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_primary_linux_group_account")) {
            if (Aosh.checkParamCount("set_primary_linux_group_account", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setPrimaryLinuxGroupAccount(Aosh.parseGroupName(args[1], "group"), Aosh.parseLinuxUserName(args[2], "username"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Map<Object, Object> map = this.hash;
        synchronized (map) {
            this.hashBuilt = false;
        }
        map = this.primaryHash;
        synchronized (map) {
            this.primaryHashBuilt = false;
        }
    }
}

