/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class LinuxId
implements Comparable<LinuxId>,
Serializable,
DtoFactory<com.aoindustries.aoserv.client.dto.LinuxId> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, LinuxId.class);
    private static final long serialVersionUID = -6222776271442175855L;
    private static final AtomicReferenceArray<LinuxId> cache = new AtomicReferenceArray(65536);
    private final int id;

    public static ValidationResult validate(int id) {
        if (id < 0) {
            return new InvalidResult(RESOURCES, "validate.lessThanZero", new Serializable[]{Integer.valueOf(id)});
        }
        if (id > 65535) {
            return new InvalidResult(RESOURCES, "validate.greaterThan64k", new Serializable[]{Integer.valueOf(id)});
        }
        return ValidResult.getInstance();
    }

    public static LinuxId valueOf(int id) throws ValidationException {
        ValidationResult result = LinuxId.validate(id);
        if (!result.isValid()) {
            throw new ValidationException(result);
        }
        LinuxId linuxId = cache.get(id);
        if (linuxId == null && !cache.compareAndSet(id, null, linuxId = new LinuxId(id))) {
            linuxId = cache.get(id);
        }
        return linuxId;
    }

    private LinuxId(int id) {
        ValidationResult result;
        assert ((result = LinuxId.validate(id)).isValid()) : result.toString();
        this.id = id;
    }

    private void validate() throws ValidationException {
        ValidationResult result = LinuxId.validate(this.id);
        if (!result.isValid()) {
            throw new ValidationException(result);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            this.validate();
        }
        catch (ValidationException err) {
            InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            return LinuxId.valueOf(this.id);
        }
        catch (ValidationException err) {
            InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof LinuxId && ((LinuxId)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int compareTo(LinuxId other) {
        return this == other ? 0 : Integer.compare(this.id, other.id);
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public int getId() {
        return this.id;
    }

    public com.aoindustries.aoserv.client.dto.LinuxId getDto() {
        return new com.aoindustries.aoserv.client.dto.LinuxId(this.id);
    }
}

