/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.util.ComparatorUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class PosixPath
implements Comparable<PosixPath>,
Serializable,
DtoFactory<com.aoindustries.aoserv.client.dto.PosixPath>,
Internable<PosixPath> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, PosixPath.class);
    private static final long serialVersionUID = -4832121065303689152L;
    private static final ConcurrentMap<String, PosixPath> interned = new ConcurrentHashMap<String, PosixPath>();
    private final String path;

    public static ValidationResult validate(String path) {
        if (path == null) {
            return new InvalidResult(RESOURCES, "validate.isNull");
        }
        if (path.length() == 0) {
            return new InvalidResult(RESOURCES, "validate.empty");
        }
        char ch = path.charAt(0);
        if (ch != '/') {
            return new InvalidResult(RESOURCES, "validate.startWithNonSlash", new Serializable[]{Character.valueOf(ch)});
        }
        int i = path.indexOf(0);
        if (i != -1) {
            return new InvalidResult(RESOURCES, "validate.containsNullCharacter", new Serializable[]{Integer.valueOf(i)});
        }
        i = path.indexOf("/../");
        if (i != -1) {
            return new InvalidResult(RESOURCES, "validate.containsDotDot", new Serializable[]{Integer.valueOf(i)});
        }
        i = path.indexOf("/./");
        if (i != -1) {
            return new InvalidResult(RESOURCES, "validate.containsDot", new Serializable[]{Integer.valueOf(i)});
        }
        if (path.length() > 1 && path.endsWith("/")) {
            return new InvalidResult(RESOURCES, "validate.endsSlash");
        }
        if (path.endsWith("/.")) {
            return new InvalidResult(RESOURCES, "validate.endsSlashDot");
        }
        if (path.endsWith("/..")) {
            return new InvalidResult(RESOURCES, "validate.endsSlashDotDot");
        }
        i = path.indexOf("//");
        if (i != -1) {
            return new InvalidResult(RESOURCES, "validate.containsDoubleSlash", new Serializable[]{Integer.valueOf(i)});
        }
        return ValidResult.getInstance();
    }

    public static PosixPath valueOf(String path) throws ValidationException {
        if (path == null) {
            return null;
        }
        return new PosixPath(path, true);
    }

    private PosixPath(String path, boolean validate) throws ValidationException {
        this.path = path;
        if (validate) {
            this.validate();
        }
    }

    private PosixPath(String path) {
        ValidationResult result;
        assert ((result = PosixPath.validate(path)).isValid()) : result.toString();
        this.path = path;
    }

    private void validate() throws ValidationException {
        ValidationResult result = PosixPath.validate(this.path);
        if (!result.isValid()) {
            throw new ValidationException(result);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            this.validate();
        }
        catch (ValidationException err) {
            InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof PosixPath && this.path.equals(((PosixPath)obj).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public int compareTo(PosixPath other) {
        return this == other ? 0 : ComparatorUtils.compareIgnoreCaseConsistentWithEquals((String)this.path, (String)other.path);
    }

    public String toString() {
        return this.path;
    }

    public PosixPath intern() {
        PosixPath addMe;
        String internedPath;
        PosixPath existing = (PosixPath)interned.get(this.path);
        if (existing == null && (existing = interned.putIfAbsent(internedPath, addMe = this.path == (internedPath = this.path.intern()) ? this : new PosixPath(internedPath))) == null) {
            existing = addMe;
        }
        return existing;
    }

    public com.aoindustries.aoserv.client.dto.PosixPath getDto() {
        return new com.aoindustries.aoserv.client.dto.PosixPath(this.path);
    }
}

