/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.collections.AoCollections;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.Strings;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.exception.WrappedException;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.util.BufferManager;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.Email;
import com.aoapps.net.HostAddress;
import com.aoapps.net.InetAddress;
import com.aoapps.net.Port;
import com.aoapps.net.URIParameters;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.backup.BackupPartition;
import com.aoindustries.aoserv.client.backup.MysqlReplication;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.dto.LinuxServer;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.BlackholeAddress;
import com.aoindustries.aoserv.client.email.CyrusImapdServer;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.Forwarding;
import com.aoindustries.aoserv.client.email.InboxAddress;
import com.aoindustries.aoserv.client.email.ListAddress;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.email.Pipe;
import com.aoindustries.aoserv.client.email.PipeAddress;
import com.aoindustries.aoserv.client.email.SendmailServer;
import com.aoindustries.aoserv.client.email.SmtpRelay;
import com.aoindustries.aoserv.client.email.SystemAlias;
import com.aoindustries.aoserv.client.ftp.GuestUser;
import com.aoindustries.aoserv.client.ftp.PrivateServer;
import com.aoindustries.aoserv.client.linux.DaemonAcl;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.LinuxId;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.TimeZone;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.Device;
import com.aoindustries.aoserv.client.net.DeviceId;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.Version;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.scm.CvsRepository;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;

public final class Server
extends CachedObjectIntegerKey<Server>
implements DtoFactory<LinuxServer> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Server.class);
    static final int COLUMN_SERVER = 0;
    static final int COLUMN_HOSTNAME = 1;
    public static final String COLUMN_HOSTNAME_name = "hostname";
    private DomainName hostname;
    private int daemonBind;
    private int poolSize;
    private int distroHour;
    private UnmodifiableTimestamp lastDistroTime;
    private int failoverFerver;
    private String daemonDeviceId;
    private int daemonConnectBind;
    private String timeZone;
    private int jilterBind;
    private boolean restrictOutboundEmail;
    private HostAddress daemonConnectAddress;
    private int failoverBatchSize;
    private float monitoringLoadLow;
    private float monitoringLoadMedium;
    private float monitoringLoadHigh;
    private float monitoringLoadCritical;
    private LinuxId uidMin;
    private LinuxId gidMin;
    private LinuxId uidMax;
    private LinuxId gidMax;
    private LinuxId lastUid;
    private LinuxId lastGid;
    private long sftpUmask;
    private static final Map<Integer, Object> mrtgLocks = new HashMap<Integer, Object>();

    @Deprecated
    public Server() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.hostname;
            }
            case 2: {
                return this.daemonBind == -1 ? null : Integer.valueOf(this.daemonBind);
            }
            case 3: {
                return this.poolSize;
            }
            case 4: {
                return this.distroHour;
            }
            case 5: {
                return this.lastDistroTime;
            }
            case 6: {
                return this.failoverFerver == -1 ? null : Integer.valueOf(this.failoverFerver);
            }
            case 7: {
                return this.daemonDeviceId;
            }
            case 8: {
                return this.daemonConnectBind == -1 ? null : Integer.valueOf(this.daemonConnectBind);
            }
            case 9: {
                return this.timeZone;
            }
            case 10: {
                return this.jilterBind == -1 ? null : Integer.valueOf(this.jilterBind);
            }
            case 11: {
                return this.restrictOutboundEmail;
            }
            case 12: {
                return this.daemonConnectAddress;
            }
            case 13: {
                return this.failoverBatchSize;
            }
            case 14: {
                return Float.isNaN(this.monitoringLoadLow) ? null : Float.valueOf(this.monitoringLoadLow);
            }
            case 15: {
                return Float.isNaN(this.monitoringLoadMedium) ? null : Float.valueOf(this.monitoringLoadMedium);
            }
            case 16: {
                return Float.isNaN(this.monitoringLoadHigh) ? null : Float.valueOf(this.monitoringLoadHigh);
            }
            case 17: {
                return Float.isNaN(this.monitoringLoadCritical) ? null : Float.valueOf(this.monitoringLoadCritical);
            }
            case 18: {
                return this.uidMin;
            }
            case 19: {
                return this.gidMin;
            }
            case 20: {
                return this.uidMax;
            }
            case 21: {
                return this.gidMax;
            }
            case 22: {
                return this.lastUid;
            }
            case 23: {
                return this.lastGid;
            }
            case 24: {
                return this.sftpUmask == -1L ? null : Long.valueOf(this.sftpUmask);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getServer_pkey() {
        return this.pkey;
    }

    public Host getHost() throws SQLException, IOException {
        Host se = this.table.getConnector().getNet().getHost().get(this.pkey);
        if (se == null) {
            throw new SQLException("Unable to find Host: " + this.pkey);
        }
        return se;
    }

    public DomainName getHostname() {
        return this.hostname;
    }

    public Integer getDaemonBind_id() {
        return this.daemonBind == -1 ? null : Integer.valueOf(this.daemonBind);
    }

    public Bind getDaemonBind() throws IOException, SQLException {
        if (this.daemonBind == -1) {
            return null;
        }
        return this.table.getConnector().getNet().getBind().get(this.daemonBind);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getDistroHour() {
        return this.distroHour;
    }

    public UnmodifiableTimestamp getLastDistroTime() {
        return this.lastDistroTime;
    }

    public Integer getFailoverServer_server_pkey() {
        return this.failoverFerver == -1 ? null : Integer.valueOf(this.failoverFerver);
    }

    public Server getFailoverServer() throws SQLException, IOException {
        if (this.failoverFerver == -1) {
            return null;
        }
        Server se = this.table.getConnector().getLinux().getServer().get(this.failoverFerver);
        if (se == null) {
            throw new SQLException("Unable to find linux.Server: " + this.failoverFerver);
        }
        return se;
    }

    public String getDaemonDeviceId_name() {
        return this.daemonDeviceId;
    }

    public DeviceId getDaemonDeviceId() throws SQLException, IOException {
        DeviceId obj = this.table.getConnector().getNet().getDeviceId().get(this.daemonDeviceId);
        if (obj == null) {
            throw new SQLException("Unable to find DeviceId: " + this.daemonDeviceId);
        }
        return obj;
    }

    public Integer getDaemonConnectBind_id() {
        return this.daemonConnectBind == -1 ? null : Integer.valueOf(this.daemonConnectBind);
    }

    public Bind getDaemonConnectBind() throws IOException, SQLException {
        if (this.daemonConnectBind == -1) {
            return null;
        }
        return this.table.getConnector().getNet().getBind().get(this.daemonConnectBind);
    }

    public String getTimeZone_name() {
        return this.timeZone;
    }

    public TimeZone getTimeZone() throws SQLException, IOException {
        TimeZone obj = this.table.getConnector().getLinux().getTimeZone().get(this.timeZone);
        if (obj == null) {
            throw new SQLException("Unable to find TimeZone: " + this.timeZone);
        }
        return obj;
    }

    public Integer getJilterBind_id() {
        return this.jilterBind == -1 ? null : Integer.valueOf(this.jilterBind);
    }

    public Bind getJilterBind() throws IOException, SQLException {
        if (this.jilterBind == -1) {
            return null;
        }
        return this.table.getConnector().getNet().getBind().get(this.jilterBind);
    }

    public boolean getRestrictOutboundEmail() {
        return this.restrictOutboundEmail;
    }

    public HostAddress getDaemonConnectAddress() {
        return this.daemonConnectAddress;
    }

    public int getFailoverBatchSize() {
        return this.failoverBatchSize;
    }

    public float getMonitoringLoadLow() {
        return this.monitoringLoadLow;
    }

    public float getMonitoringLoadMedium() {
        return this.monitoringLoadMedium;
    }

    public float getMonitoringLoadHigh() {
        return this.monitoringLoadHigh;
    }

    public float getMonitoringLoadCritical() {
        return this.monitoringLoadCritical;
    }

    public LinuxId getUidMin() {
        return this.uidMin;
    }

    public LinuxId getGidMin() {
        return this.gidMin;
    }

    public LinuxId getUidMax() {
        return this.uidMax;
    }

    public LinuxId getGidMax() {
        return this.gidMax;
    }

    public LinuxId getLastUid() {
        return this.lastUid;
    }

    public LinuxId getLastGid() {
        return this.lastGid;
    }

    public long getSftpUmask() {
        return this.sftpUmask;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt("server");
            this.hostname = DomainName.valueOf((String)result.getString(COLUMN_HOSTNAME_name));
            this.daemonBind = result.getInt("daemon_bind");
            if (result.wasNull()) {
                this.daemonBind = -1;
            }
            this.poolSize = result.getInt("pool_size");
            this.distroHour = result.getInt("distro_hour");
            this.lastDistroTime = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp("last_distro_time"));
            this.failoverFerver = result.getInt("failover_server");
            if (result.wasNull()) {
                this.failoverFerver = -1;
            }
            this.daemonDeviceId = result.getString("daemonDeviceId");
            this.daemonConnectBind = result.getInt("daemon_connect_bind");
            this.timeZone = result.getString("time_zone");
            this.jilterBind = result.getInt("jilter_bind");
            if (result.wasNull()) {
                this.jilterBind = -1;
            }
            this.restrictOutboundEmail = result.getBoolean("restrict_outbound_email");
            this.daemonConnectAddress = HostAddress.valueOf((String)result.getString("daemon_connect_address"));
            this.failoverBatchSize = result.getInt("failover_batch_size");
            this.monitoringLoadLow = result.getFloat("monitoring_load_low");
            if (result.wasNull()) {
                this.monitoringLoadLow = Float.NaN;
            }
            this.monitoringLoadMedium = result.getFloat("monitoring_load_medium");
            if (result.wasNull()) {
                this.monitoringLoadMedium = Float.NaN;
            }
            this.monitoringLoadHigh = result.getFloat("monitoring_load_high");
            if (result.wasNull()) {
                this.monitoringLoadHigh = Float.NaN;
            }
            this.monitoringLoadCritical = result.getFloat("monitoring_load_critical");
            if (result.wasNull()) {
                this.monitoringLoadCritical = Float.NaN;
            }
            this.uidMin = LinuxId.valueOf(result.getInt("uidMin"));
            this.gidMin = LinuxId.valueOf(result.getInt("gidMin"));
            this.uidMax = LinuxId.valueOf(result.getInt("uidMax"));
            this.gidMax = LinuxId.valueOf(result.getInt("gidMax"));
            int lastUidInt = result.getInt("lastUid");
            this.lastUid = result.wasNull() ? null : LinuxId.valueOf(lastUidInt);
            int lastGidInt = result.getInt("lastGid");
            this.lastGid = result.wasNull() ? null : LinuxId.valueOf(lastGidInt);
            this.sftpUmask = result.getLong("sftp_umask");
            if (result.wasNull()) {
                this.sftpUmask = -1L;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.hostname = DomainName.valueOf((String)in.readUTF());
            this.daemonBind = in.readCompressedInt();
            this.poolSize = in.readCompressedInt();
            this.distroHour = in.readCompressedInt();
            this.lastDistroTime = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
            this.failoverFerver = in.readCompressedInt();
            this.daemonDeviceId = InternUtils.intern((String)in.readNullUTF());
            this.daemonConnectBind = in.readCompressedInt();
            this.timeZone = in.readUTF().intern();
            this.jilterBind = in.readCompressedInt();
            this.restrictOutboundEmail = in.readBoolean();
            this.daemonConnectAddress = (HostAddress)InternUtils.intern((Internable)HostAddress.valueOf((String)in.readNullUTF()));
            this.failoverBatchSize = in.readCompressedInt();
            this.monitoringLoadLow = in.readFloat();
            this.monitoringLoadMedium = in.readFloat();
            this.monitoringLoadHigh = in.readFloat();
            this.monitoringLoadCritical = in.readFloat();
            this.uidMin = LinuxId.valueOf(in.readCompressedInt());
            this.gidMin = LinuxId.valueOf(in.readCompressedInt());
            this.uidMax = LinuxId.valueOf(in.readCompressedInt());
            this.gidMax = LinuxId.valueOf(in.readCompressedInt());
            int lastUidInt = in.readCompressedInt();
            this.lastUid = lastUidInt == -1 ? null : LinuxId.valueOf(lastUidInt);
            int lastGidInt = in.readCompressedInt();
            this.lastGid = lastGidInt == -1 ? null : LinuxId.valueOf(lastGidInt);
            this.sftpUmask = in.readLong();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeCompressedInt(1);
            out.writeCompressedInt(2000);
            out.writeCompressedInt(1024);
            out.writeCompressedInt(2);
            out.writeCompressedInt(240);
            out.writeNullUTF(null);
            out.writeBoolean(false);
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_4) < 0) {
            out.writeBoolean(true);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeBoolean(false);
            out.writeUTF("linux.Server #" + this.pkey);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeUTF(this.hostname.toString());
        }
        out.writeCompressedInt(this.daemonBind);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_2) <= 0) {
            out.writeUTF("*");
        }
        out.writeCompressedInt(this.poolSize);
        out.writeCompressedInt(this.distroHour);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.lastDistroTime == null ? -1L : this.lastDistroTime.getTime());
        } else {
            SQLStreamables.writeNullTimestamp((Timestamp)this.lastDistroTime, (DataOutputStream)out);
        }
        out.writeCompressedInt(this.failoverFerver);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeCompressedInt(60000);
            out.writeCompressedInt(300000);
            out.writeBoolean(false);
        }
        out.writeNullUTF(this.daemonDeviceId);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeNullUTF(null);
            out.writeCompressedInt(120000);
            out.writeBoolean(true);
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_108) >= 0) {
                out.writeNullUTF(null);
                out.writeNullUTF(null);
            } else if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_104) >= 0) {
                out.writeUTF("*");
                out.writeUTF("*");
            }
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_119) >= 0) {
            out.writeCompressedInt(this.daemonConnectBind);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_2) >= 0) {
            out.writeUTF(this.timeZone);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_7) >= 0) {
            out.writeCompressedInt(this.jilterBind);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_8) >= 0) {
            out.writeBoolean(this.restrictOutboundEmail);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_11) >= 0) {
            out.writeNullUTF(Objects.toString(this.daemonConnectAddress, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_12) >= 0) {
            out.writeCompressedInt(this.failoverBatchSize);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_35) >= 0) {
            out.writeFloat(this.monitoringLoadLow);
            out.writeFloat(this.monitoringLoadMedium);
            out.writeFloat(this.monitoringLoadHigh);
            out.writeFloat(this.monitoringLoadCritical);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80) >= 0) {
            out.writeCompressedInt(this.uidMin.getId());
            out.writeCompressedInt(this.gidMin.getId());
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_18) >= 0) {
            out.writeCompressedInt(this.uidMax.getId());
            out.writeCompressedInt(this.gidMax.getId());
            out.writeCompressedInt(this.lastUid == null ? -1 : this.lastUid.getId());
            out.writeCompressedInt(this.lastGid == null ? -1 : this.lastGid.getId());
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_5) >= 0) {
            out.writeLong(this.sftpUmask);
        }
    }

    public int addCvsRepository(PosixPath path, UserServer lsa, GroupServer lsg, long mode) throws IOException, SQLException {
        return this.table.getConnector().getScm().getCvsRepository().addCvsRepository(this, path, lsa, lsg, mode);
    }

    public int addEmailDomain(DomainName domain, Package packageObject) throws SQLException, IOException {
        return this.table.getConnector().getEmail().getDomain().addEmailDomain(domain, this, packageObject);
    }

    public int addEmailPipe(String command, Package packageObject) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getPipe().addEmailPipe(this, command, packageObject);
    }

    public int addHttpdJbossSite(String siteName, Package packageObj, User siteUser, Group siteGroup, Email serverAdmin, boolean useApache, IpAddress ipAddress, DomainName primaryHttpHostname, DomainName[] altHttpHostnames, com.aoindustries.aoserv.client.web.jboss.Version jbossVersion) throws IOException, SQLException {
        return this.table.getConnector().getWeb_jboss().getSite().addHttpdJbossSite(this, siteName, packageObj, siteUser, siteGroup, serverAdmin, useApache, ipAddress, primaryHttpHostname, altHttpHostnames, jbossVersion);
    }

    public int addHttpdSharedTomcat(String name, com.aoindustries.aoserv.client.web.tomcat.Version version, UserServer lsa, GroupServer lsg) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcat().addHttpdSharedTomcat(name, this, version, lsa, lsg);
    }

    public int addHttpdTomcatSharedSite(String siteName, Package packageObj, User siteUser, Group siteGroup, Email serverAdmin, boolean useApache, IpAddress ipAddress, DomainName primaryHttpHostname, DomainName[] altHttpHostnames, String sharedTomcatName) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcatSite().addHttpdTomcatSharedSite(this, siteName, packageObj, siteUser, siteGroup, serverAdmin, useApache, ipAddress, primaryHttpHostname, altHttpHostnames, sharedTomcatName);
    }

    public int addHttpdTomcatStdSite(String siteName, Package packageObj, User jvmUser, Group jvmGroup, Email serverAdmin, boolean useApache, IpAddress ipAddress, DomainName primaryHttpHostname, DomainName[] altHttpHostnames, com.aoindustries.aoserv.client.web.tomcat.Version tomcatVersion) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getPrivateTomcatSite().addHttpdTomcatStdSite(this, siteName, packageObj, jvmUser, jvmGroup, serverAdmin, useApache, ipAddress, primaryHttpHostname, altHttpHostnames, tomcatVersion);
    }

    public int addSystemGroup(Group.Name groupName, int gid) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupServer().addSystemGroup(this, groupName, gid);
    }

    public int addSystemUser(User.Name username, int uid, int gid, User.Gecos fullName, User.Gecos officeLocation, User.Gecos officePhone, User.Gecos homePhone, PosixPath home, PosixPath shell) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getUserServer().addSystemUser(this, username, uid, gid, fullName, officeLocation, officePhone, homePhone, home, shell);
    }

    public List<DaemonAcl> getAoserverDaemonHosts() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getDaemonAcl().getAoserverDaemonHosts(this);
    }

    public List<BackupPartition> getBackupPartitions() throws IOException, SQLException {
        return this.table.getConnector().getBackup().getBackupPartition().getBackupPartitions(this);
    }

    public BackupPartition getBackupPartitionForPath(String path) throws IOException, SQLException {
        return this.table.getConnector().getBackup().getBackupPartition().getBackupPartitionForPath(this, path);
    }

    public List<BlackholeAddress> getBlackholeEmailAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getBlackholeAddress().getBlackholeEmailAddresses(this);
    }

    public CvsRepository getCvsRepository(PosixPath path) throws IOException, SQLException {
        return this.table.getConnector().getScm().getCvsRepository().getCvsRepository(this, path);
    }

    public List<CvsRepository> getCvsRepositories() throws IOException, SQLException {
        return this.table.getConnector().getScm().getCvsRepository().getCvsRepositories(this);
    }

    public IpAddress getDaemonIpAddress() throws SQLException, IOException {
        Bind nb = this.getDaemonBind();
        if (nb == null) {
            throw new SQLException("Unable to find daemon NetBind for linux.Server: " + this.pkey);
        }
        IpAddress ia = nb.getIpAddress();
        InetAddress ip = ia.getInetAddress();
        if (ip.isUnspecified()) {
            DeviceId ndi = this.getDaemonDeviceId();
            Device nd = this.getHost().getNetDevice(ndi.getName());
            if (nd == null) {
                throw new SQLException("Unable to find NetDevice: " + ndi.getName() + " on " + this.pkey);
            }
            ia = nd.getPrimaryIpAddress();
            if (ia == null) {
                throw new SQLException("Unable to find primary IpAddress: " + ndi.getName() + " on " + this.pkey);
            }
        }
        return ia;
    }

    public CyrusImapdServer getCyrusImapdServer() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getCyrusImapdServer().get(this.pkey);
    }

    public List<Address> getEmailAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getAddress().getEmailAddresses(this);
    }

    public Domain getEmailDomain(DomainName domain) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getDomain().getEmailDomain(this, domain);
    }

    public List<Domain> getEmailDomains() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getDomain().getEmailDomains(this);
    }

    public List<Forwarding> getEmailForwarding() throws SQLException, IOException {
        return this.table.getConnector().getEmail().getForwarding().getEmailForwarding(this);
    }

    public com.aoindustries.aoserv.client.email.List getEmailList(PosixPath path) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getList().getEmailList(this, path);
    }

    public List<ListAddress> getEmailListAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getListAddress().getEmailListAddresses(this);
    }

    public List<PipeAddress> getEmailPipeAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getPipeAddress().getEmailPipeAddresses(this);
    }

    public List<Pipe> getEmailPipes() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getPipe().getEmailPipes(this);
    }

    public SmtpRelay getEmailSmtpRelay(Package pk, HostAddress host) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSmtpRelay().getEmailSmtpRelay(pk, this, host);
    }

    public List<SmtpRelay> getEmailSmtpRelays() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSmtpRelay().getEmailSmtpRelays(this);
    }

    public List<GuestUser> getFtpGuestUsers() throws IOException, SQLException {
        return this.table.getConnector().getFtp().getGuestUser().getFtpGuestUsers(this);
    }

    public List<HttpdServer> getHttpdServers() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getHttpdServer().getHttpdServers(this);
    }

    public List<SharedTomcat> getHttpdSharedTomcats() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcat().getHttpdSharedTomcats(this);
    }

    public SharedTomcat getHttpdSharedTomcat(String jvmName) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcat().getHttpdSharedTomcat(jvmName, this);
    }

    public Site getHttpdSite(String siteName) throws IOException, SQLException {
        return this.table.getConnector().getWeb().getSite().getHttpdSite(siteName, this);
    }

    public List<Site> getHttpdSites() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getSite().getHttpdSites(this);
    }

    public List<InboxAddress> getLinuxAccAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getInboxAddress().getLinuxAccAddresses(this);
    }

    public List<User> getLinuxAccounts() throws SQLException, IOException {
        List<UserServer> lsa = this.getLinuxServerAccounts();
        int len = lsa.size();
        ArrayList<User> la = new ArrayList<User>(len);
        for (int c = 0; c < len; ++c) {
            la.add(lsa.get(c).getLinuxAccount());
        }
        return la;
    }

    public List<Group> getLinuxGroups() throws SQLException, IOException {
        List<GroupServer> lsg = this.getLinuxServerGroups();
        int len = lsg.size();
        ArrayList<Group> lg = new ArrayList<Group>(len);
        for (int c = 0; c < len; ++c) {
            lg.add(lsg.get(c).getLinuxGroup());
        }
        return lg;
    }

    public UserServer getLinuxServerAccount(User.Name username) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getUserServer().getLinuxServerAccount(this, username);
    }

    public UserServer getLinuxServerAccount(LinuxId uid) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getUserServer().getLinuxServerAccount(this, uid);
    }

    public List<UserServer> getLinuxServerAccounts() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getUserServer().getLinuxServerAccounts(this);
    }

    public GroupServer getLinuxServerGroup(LinuxId gid) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupServer().getLinuxServerGroup(this, gid);
    }

    public GroupServer getLinuxServerGroup(Group.Name groupName) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupServer().getLinuxServerGroup(this, groupName);
    }

    public List<GroupServer> getLinuxServerGroups() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupServer().getLinuxServerGroups(this);
    }

    public List<MajordomoServer> getMajordomoServers() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getMajordomoServer().getMajordomoServers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMrtgFile(final String filename, final OutputStream out) throws IOException, SQLException {
        Map<Integer, Object> map = mrtgLocks;
        synchronized (map) {
            long startTime = System.currentTimeMillis();
            do {
                if (!mrtgLocks.containsKey(this.pkey)) continue;
                long currentTime = System.currentTimeMillis();
                if (startTime > currentTime) {
                    startTime = currentTime;
                    continue;
                }
                if (currentTime - startTime >= 15000L) {
                    throw new IOException("15 second timeout reached while trying to get lock to access server #" + this.pkey);
                }
                try {
                    mrtgLocks.wait(startTime + 15000L - currentTime);
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(err);
                    throw ioErr;
                }
            } while (mrtgLocks.containsKey(this.pkey));
            mrtgLocks.put(this.pkey, Boolean.TRUE);
            mrtgLocks.notifyAll();
        }
        try {
            this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.GET_MRTG_FILE, new AoservConnector.UpdateRequest(){

                @Override
                public void writeRequest(StreamableOutput masterOut) throws IOException {
                    masterOut.writeCompressedInt(Server.this.pkey);
                    masterOut.writeUTF(filename);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void readResponse(StreamableInput in) throws IOException, SQLException {
                    byte[] buff = BufferManager.getBytes();
                    try {
                        byte code;
                        while ((code = in.readByte()) == 0) {
                            short len = in.readShort();
                            in.readFully(buff, 0, (int)len);
                            out.write(buff, 0, len);
                        }
                        AoservProtocol.checkResult(code, in);
                    }
                    finally {
                        BufferManager.release((byte[])buff, (boolean)false);
                    }
                }

                @Override
                public void afterRelease() {
                }
            });
        }
        finally {
            map = mrtgLocks;
            synchronized (map) {
                mrtgLocks.remove(this.pkey);
                mrtgLocks.notifyAll();
            }
        }
    }

    public com.aoindustries.aoserv.client.mysql.Server getMysqlServer(Server.Name name) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getServer().getMysqlServer(name, this);
    }

    public List<com.aoindustries.aoserv.client.mysql.Server> getMysqlServers() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getServer().getMysqlServers(this);
    }

    public com.aoindustries.aoserv.client.mysql.Server getPreferredMysqlServer() throws IOException, SQLException {
        List<com.aoindustries.aoserv.client.mysql.Server> pss = this.getMysqlServers();
        for (String versionPrefix : com.aoindustries.aoserv.client.mysql.Server.PREFERRED_VERSION_PREFIXES) {
            for (com.aoindustries.aoserv.client.mysql.Server ps : pss) {
                if (!ps.getVersion().getVersion().startsWith(versionPrefix)) continue;
                return ps;
            }
        }
        return pss.isEmpty() ? null : pss.get(0);
    }

    public List<Server> getNestedServers() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getServer().getNestedServers(this);
    }

    public com.aoindustries.aoserv.client.postgresql.Server getPostgresServer(Server.Name name) throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getServer().getPostgresServer(name, this);
    }

    public List<com.aoindustries.aoserv.client.postgresql.Server> getPostgresServers() throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getServer().getPostgresServers(this);
    }

    public com.aoindustries.aoserv.client.postgresql.Server getPreferredPostgresServer() throws SQLException, IOException {
        String[] preferredMinorVersions;
        List<com.aoindustries.aoserv.client.postgresql.Server> pss = this.getPostgresServers();
        for (String version : preferredMinorVersions = Version.getPreferredMinorVersions()) {
            for (com.aoindustries.aoserv.client.postgresql.Server ps : pss) {
                if (!ps.getVersion().getMinorVersion().equals(version)) continue;
                return ps;
            }
        }
        return pss.isEmpty() ? null : pss.get(0);
    }

    public IpAddress getPrimaryIpAddress() throws SQLException, IOException {
        DeviceId ndi = this.getDaemonDeviceId();
        String name = ndi.getName();
        Device nd = this.getHost().getNetDevice(name);
        if (nd == null) {
            throw new SQLException("Unable to find NetDevice: " + name + " on " + this.pkey);
        }
        return nd.getPrimaryIpAddress();
    }

    public List<PrivateServer> getPrivateFtpServers() throws IOException, SQLException {
        return this.table.getConnector().getFtp().getPrivateServer().getPrivateFtpServers(this);
    }

    public List<SendmailServer> getSendmailServers() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSendmailServer().getSendmailServers(this);
    }

    public List<Certificate> getSslCertificates() throws IOException, SQLException {
        return this.table.getConnector().getPki().getCertificate().getSslCertificates(this);
    }

    public List<SystemAlias> getSystemEmailAliases() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSystemAlias().getSystemEmailAliases(this);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.AO_SERVERS;
    }

    public boolean isEmailDomainAvailable(DomainName domain) throws SQLException, IOException {
        return this.table.getConnector().getEmail().getDomain().isEmailDomainAvailable(this, domain);
    }

    public boolean isHomeUsed(PosixPath directory) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getUserServer().isHomeUsed(this, directory);
    }

    public boolean isMysqlServerNameAvailable(Server.Name name) throws IOException, SQLException {
        return this.table.getConnector().getMysql().getServer().isMysqlServerNameAvailable(name, this);
    }

    public boolean isPostgresServerNameAvailable(Server.Name name) throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getServer().isPostgresServerNameAvailable(name, this);
    }

    public void restartApache() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.RESTART_APACHE, this.pkey);
    }

    public void restartCron() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.RESTART_CRON, this.pkey);
    }

    public void restartXfs() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.RESTART_XFS, this.pkey);
    }

    public void restartXvfb() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.RESTART_XVFB, this.pkey);
    }

    public void setLastDistroTime(Timestamp distroTime) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LAST_DISTRO_TIME, this.pkey, distroTime);
    }

    public void startApache() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.START_APACHE, this.pkey);
    }

    public void startCron() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.START_CRON, this.pkey);
    }

    public void startDistro(boolean includeUser) throws IOException, SQLException {
        this.table.getConnector().getDistribution_management().getDistroFile().startDistro(this, includeUser);
    }

    public void startXfs() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.START_XFS, this.pkey);
    }

    public void startXvfb() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.START_XVFB, this.pkey);
    }

    public void stopApache() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.STOP_APACHE, this.pkey);
    }

    public void stopCron() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.STOP_CRON, this.pkey);
    }

    public void stopXfs() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.STOP_XFS, this.pkey);
    }

    public void stopXvfb() throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.STOP_XVFB, this.pkey);
    }

    @Override
    public String toStringImpl() {
        return this.hostname.toString();
    }

    public void waitForHttpdSiteRebuild() throws IOException, SQLException {
        this.table.getConnector().getWeb().getSite().waitForRebuild(this);
    }

    public void waitForLinuxAccountRebuild() throws IOException, SQLException {
        this.table.getConnector().getLinux().getUser().waitForRebuild(this);
    }

    public void waitForMysqlDatabaseRebuild() throws IOException, SQLException {
        this.table.getConnector().getMysql().getDatabase().waitForRebuild(this);
    }

    public void waitForMysqlDbUserRebuild() throws IOException, SQLException {
        this.table.getConnector().getMysql().getDatabaseUser().waitForRebuild(this);
    }

    public void waitForMysqlServerRebuild() throws IOException, SQLException {
        this.table.getConnector().getMysql().getServer().waitForRebuild(this);
    }

    public void waitForMysqlUserRebuild() throws IOException, SQLException {
        this.table.getConnector().getMysql().getUser().waitForRebuild(this);
    }

    public void waitForPostgresDatabaseRebuild() throws IOException, SQLException {
        this.table.getConnector().getPostgresql().getDatabase().waitForRebuild(this);
    }

    public void waitForPostgresServerRebuild() throws IOException, SQLException {
        this.table.getConnector().getPostgresql().getServer().waitForRebuild(this);
    }

    public void waitForPostgresUserRebuild() throws IOException, SQLException {
        this.table.getConnector().getPostgresql().getUser().waitForRebuild(this);
    }

    public String get3wareRaidReport() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_3WARE_RAID_REPORT, this.pkey);
    }

    public String getMdStatReport() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_MD_STAT_REPORT, this.pkey);
    }

    public List<MdMismatchReport> getMdMismatchReport() throws IOException, SQLException, ParseException {
        return Server.parseMdMismatchReport(this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_MD_MISMATCH_REPORT, this.pkey));
    }

    public static List<MdMismatchReport> parseMdMismatchReport(String mismatchReport) throws ParseException {
        List lines = Strings.splitLines((String)mismatchReport);
        int lineNum = 0;
        ArrayList<MdMismatchReport> reports = new ArrayList<MdMismatchReport>(lines.size());
        for (String line : lines) {
            long count;
            ++lineNum;
            List values = Strings.split((String)line, (char)'\t');
            if (values.size() != 3) {
                throw new ParseException(RESOURCES.getMessage("MdMismatchReport.ParseException.badColumnCount", new Object[]{line}), lineNum);
            }
            String device = (String)values.get(0);
            if (!device.startsWith("/dev/md")) {
                throw new ParseException(RESOURCES.getMessage("MdMismatchReport.ParseException.badDeviceStart", new Object[]{device}), lineNum);
            }
            RaidLevel level = RaidLevel.valueOf((String)values.get(1));
            String countString = (String)values.get(2);
            try {
                count = Long.parseLong(countString);
            }
            catch (NumberFormatException e) {
                ParseException parseException = new ParseException(RESOURCES.getMessage("MdMismatchReport.ParseException.countNotNumber", new Object[]{countString}), lineNum);
                parseException.initCause(e);
                throw parseException;
            }
            reports.add(new MdMismatchReport(device, level, count));
        }
        return reports;
    }

    public List<DrbdReport> getDrbdReport() throws IOException, SQLException, ParseException {
        return Server.parseDrbdReport(this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_DRBD_REPORT, this.pkey));
    }

    public static List<DrbdReport> parseDrbdReport(String drbdReport) throws ParseException {
        List lines = Strings.splitLines((String)drbdReport);
        int lineNum = 0;
        ArrayList<DrbdReport> reports = new ArrayList<DrbdReport>(lines.size());
        for (String line : lines) {
            DrbdReport.Role remoteRole;
            DrbdReport.Role localRole;
            DrbdReport.DiskState remoteDiskState;
            DrbdReport.DiskState localDiskState;
            ++lineNum;
            List values = Strings.split((String)line, (char)'\t');
            if (values.size() != 7) {
                throw new ParseException(RESOURCES.getMessage("DrbdReport.ParseException.badColumnCount", new Object[]{line}), lineNum);
            }
            String device = (String)values.get(0);
            if (!device.startsWith("/dev/drbd")) {
                throw new ParseException(RESOURCES.getMessage("DrbdReport.ParseException.badDeviceStart", new Object[]{device}), lineNum);
            }
            String resource = (String)values.get(1);
            int dashPos = resource.lastIndexOf(45);
            if (dashPos == -1) {
                throw new ParseException(RESOURCES.getMessage("DrbdReport.ParseException.noDash", new Object[]{resource}), lineNum);
            }
            String domuHostname = resource.substring(0, dashPos);
            String domuDevice = resource.substring(dashPos + 1);
            if (domuDevice.length() != 4 || domuDevice.charAt(0) != 'x' || domuDevice.charAt(1) != 'v' || domuDevice.charAt(2) != 'd' || domuDevice.charAt(3) < 'a' || domuDevice.charAt(3) > 'z') {
                throw new ParseException(RESOURCES.getMessage("DrbdReport.ParseException.unexpectedResourceEnding", new Object[]{domuDevice}), lineNum);
            }
            String connectionStateString = (String)values.get(2);
            DrbdReport.ConnectionState connectionState = "null".equals(connectionStateString) ? null : DrbdReport.ConnectionState.valueOf(connectionStateString);
            String ds = (String)values.get(3);
            if ("null".equals(ds)) {
                localDiskState = null;
                remoteDiskState = null;
            } else if (DrbdReport.DiskState.Unconfigured.name().equals(ds)) {
                localDiskState = DrbdReport.DiskState.Unconfigured;
                remoteDiskState = DrbdReport.DiskState.Unconfigured;
            } else {
                int dsSlashPos = ds.indexOf(47);
                if (dsSlashPos == -1) {
                    throw new ParseException(RESOURCES.getMessage("DrbdReport.ParseException.noSlashInDiskStates", new Object[]{ds}), lineNum);
                }
                localDiskState = DrbdReport.DiskState.valueOf(ds.substring(0, dsSlashPos));
                remoteDiskState = DrbdReport.DiskState.valueOf(ds.substring(dsSlashPos + 1));
            }
            String state = (String)values.get(4);
            if ("null".equals(state)) {
                localRole = null;
                remoteRole = null;
            } else if (DrbdReport.Role.Unconfigured.name().equals(state)) {
                localRole = DrbdReport.Role.Unconfigured;
                remoteRole = DrbdReport.Role.Unconfigured;
            } else {
                int slashPos = state.indexOf(47);
                if (slashPos == -1) {
                    throw new ParseException(RESOURCES.getMessage("DrbdReport.ParseException.noSlashInState", new Object[]{state}), lineNum);
                }
                localRole = DrbdReport.Role.valueOf(state.substring(0, slashPos));
                remoteRole = DrbdReport.Role.valueOf(state.substring(slashPos + 1));
            }
            String lastVerifiedString = (String)values.get(5);
            Long lastVerified = "null".equals(lastVerifiedString) ? null : Long.valueOf(Long.parseLong(lastVerifiedString) * 1000L);
            String outOfSyncString = (String)values.get(6);
            Long outOfSync = "null".equals(outOfSyncString) ? null : Long.valueOf(Long.parseLong(outOfSyncString));
            reports.add(new DrbdReport(device, domuHostname, domuDevice, connectionState, localDiskState, remoteDiskState, localRole, remoteRole, lastVerified, outOfSync));
        }
        return reports;
    }

    public LvmReport getLvmReport() throws IOException, SQLException, ParseException {
        try {
            return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.GET_AO_SERVER_LVM_REPORT, new AoservConnector.ResultRequest<LvmReport>(){
                private String vgs;
                private String pvs;
                private String lvs;

                @Override
                public void writeRequest(StreamableOutput out) throws IOException {
                    out.writeCompressedInt(Server.this.pkey);
                }

                @Override
                public void readResponse(StreamableInput in) throws IOException, SQLException {
                    byte code = in.readByte();
                    if (code != 1) {
                        AoservProtocol.checkResult(code, in);
                        throw new IOException("Unexpected response code: " + code);
                    }
                    this.vgs = in.readUTF();
                    this.pvs = in.readUTF();
                    this.lvs = in.readUTF();
                }

                @Override
                public LvmReport afterRelease() {
                    try {
                        return new LvmReport(this.vgs, this.pvs, this.lvs);
                    }
                    catch (ParseException err) {
                        throw new WrappedException((Throwable)err);
                    }
                }
            });
        }
        catch (WrappedException err) {
            Throwable cause = err.getCause();
            if (cause instanceof ParseException) {
                throw (ParseException)cause;
            }
            throw err;
        }
    }

    public String getHddTempReport() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_HDD_TEMP_REPORT, this.pkey);
    }

    public Map<String, String> getHddModelReport() throws IOException, SQLException, ParseException {
        String report = this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_HDD_MODEL_REPORT, this.pkey);
        List lines = Strings.splitLines((String)report);
        int lineNum = 0;
        HashMap results = AoCollections.newHashMap((int)lines.size());
        for (String line : lines) {
            String model;
            ++lineNum;
            int colonPos = line.indexOf(58);
            if (colonPos == -1) {
                throw new ParseException(RESOURCES.getMessage("getHddModelReport.ParseException.noColon", new Object[]{line}), lineNum);
            }
            String device = line.substring(0, colonPos).trim();
            if (results.put(device, model = line.substring(colonPos + 1).trim()) == null) continue;
            throw new ParseException(RESOURCES.getMessage("getHddModelReport.ParseException.duplicateDevice", new Object[]{device}), lineNum);
        }
        return results;
    }

    @Deprecated
    public String getFilesystemsCsvReport() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_FILESYSTEMS_CSV_REPORT, this.pkey);
    }

    private static Byte parsePercent(String value) throws NumberFormatException {
        if (value.isEmpty()) {
            return null;
        }
        if (!value.endsWith("%")) {
            throw new NumberFormatException("Percentage does not end with '%': " + value);
        }
        return Byte.parseByte(value.substring(0, value.length() - 1));
    }

    private static Long parseLong(String value) throws NumberFormatException {
        if (value.isEmpty()) {
            return null;
        }
        return Long.parseLong(value);
    }

    public Map<String, FilesystemReport> getFilesystemsReport() throws IOException, SQLException {
        LinkedHashMap<String, FilesystemReport> reports = new LinkedHashMap<String, FilesystemReport>();
        List lines = Strings.splitLines((String)this.getFilesystemsCsvReport());
        if (lines.isEmpty()) {
            throw new IOException("No lines from report");
        }
        int numLines = lines.size();
        for (int i = 0; i < numLines; ++i) {
            String line = (String)lines.get(i);
            List columns = Strings.split((String)line, (String)"\",\"");
            if (columns.size() != 15) {
                throw new IOException("Line does not have 15 columns: " + columns.size());
            }
            String mountPoint = (String)columns.get(0);
            if (!mountPoint.startsWith("\"")) {
                throw new AssertionError();
            }
            mountPoint = mountPoint.substring(1);
            String extchkint = (String)columns.get(14);
            if (!extchkint.endsWith("\"")) {
                throw new AssertionError();
            }
            extchkint = extchkint.substring(0, extchkint.length() - 1);
            if (i == 0) {
                if ("mountpoint".equals(mountPoint) && "device".equals(columns.get(1)) && "bytes".equals(columns.get(2)) && "used".equals(columns.get(3)) && "free".equals(columns.get(4)) && "use".equals(columns.get(5)) && "inodes".equals(columns.get(6)) && "iused".equals(columns.get(7)) && "ifree".equals(columns.get(8)) && "iuse".equals(columns.get(9)) && "fstype".equals(columns.get(10)) && "mountoptions".equals(columns.get(11)) && "extstate".equals(columns.get(12)) && "extmaxmount".equals(columns.get(13)) && "extchkint".equals(extchkint)) continue;
                throw new IOException("First line is not the expected column labels");
            }
            if (reports.put(mountPoint, new FilesystemReport(mountPoint, (String)columns.get(1), Long.parseLong((String)columns.get(2)), Long.parseLong((String)columns.get(3)), Long.parseLong((String)columns.get(4)), Server.parsePercent((String)columns.get(5)), Server.parseLong((String)columns.get(6)), Server.parseLong((String)columns.get(7)), Server.parseLong((String)columns.get(8)), Server.parsePercent((String)columns.get(9)), (String)columns.get(10), (String)columns.get(11), (String)columns.get(12), (String)columns.get(13), extchkint)) == null) continue;
            throw new IOException("Duplicate mount point: " + mountPoint);
        }
        return AoCollections.optimalUnmodifiableMap(reports);
    }

    public String getLoadAvgReport() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_LOADAVG_REPORT, this.pkey);
    }

    public String getMemInfoReport() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_MEMINFO_REPORT, this.pkey);
    }

    public String checkPort(InetAddress ipAddress, Port port, String appProtocol, URIParameters monitoringParameters) throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.AO_SERVER_CHECK_PORT, this.pkey, ipAddress.toString(), port, appProtocol, Bind.encodeParameters(monitoringParameters));
    }

    public long getSystemTimeMillis() throws IOException, SQLException {
        return this.table.getConnector().requestLongQuery(true, AoservProtocol.CommandId.GET_AO_SERVER_SYSTEM_TIME_MILLIS, this.pkey);
    }

    public List<MysqlReplication> getFailoverMysqlReplications() throws IOException, SQLException {
        return this.table.getConnector().getBackup().getMysqlReplication().getFailoverMysqlReplications(this);
    }

    public String checkSmtpBlacklist(InetAddress sourceIp, InetAddress connectIp) throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(false, AoservProtocol.CommandId.AO_SERVER_CHECK_SMTP_BLACKLIST, this.pkey, sourceIp, connectIp);
    }

    public String getUpsStatus() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_UPS_STATUS, this.pkey);
    }

    public LinuxServer getDto() {
        return new LinuxServer(this.getPkey(), (com.aoapps.net.dto.DomainName)Server.getDto(this.hostname), this.daemonBind == -1 ? null : Integer.valueOf(this.daemonBind), this.poolSize, this.distroHour, this.lastDistroTime == null ? null : Long.valueOf(this.lastDistroTime.getTime()), this.failoverFerver == -1 ? null : Integer.valueOf(this.failoverFerver), this.daemonDeviceId, this.daemonConnectBind == -1 ? null : Integer.valueOf(this.daemonConnectBind), this.timeZone, this.jilterBind == -1 ? null : Integer.valueOf(this.jilterBind), this.restrictOutboundEmail, (com.aoapps.net.dto.HostAddress)Server.getDto(this.daemonConnectAddress), this.failoverBatchSize, Float.isNaN(this.monitoringLoadLow) ? null : Float.valueOf(this.monitoringLoadLow), Float.isNaN(this.monitoringLoadMedium) ? null : Float.valueOf(this.monitoringLoadMedium), Float.isNaN(this.monitoringLoadHigh) ? null : Float.valueOf(this.monitoringLoadHigh), Float.isNaN(this.monitoringLoadCritical) ? null : Float.valueOf(this.monitoringLoadCritical), Server.getDto(this.uidMin), Server.getDto(this.gidMin), Server.getDto(this.uidMax), Server.getDto(this.gidMax), Server.getDto(this.lastUid), Server.getDto(this.lastGid), this.sftpUmask == -1L ? null : Long.valueOf(this.sftpUmask));
    }

    public static class FilesystemReport {
        private final String mountPoint;
        private final String device;
        private final long bytes;
        private final long used;
        private final long free;
        private final byte use;
        private final Long inodes;
        private final Long inodesUsed;
        private final Long inodesFree;
        private final Byte inodeUse;
        private final String fsType;
        private final String mountOptions;
        private final String extState;
        private final String extMaxMount;
        private final String extCheckInterval;

        private FilesystemReport(String mountPoint, String device, long bytes, long used, long free, byte use, Long inodes, Long inodesUsed, Long inodesFree, Byte inodeUse, String fsType, String mountOptions, String extState, String extMaxMount, String extCheckInterval) {
            this.mountPoint = mountPoint;
            this.device = device;
            this.bytes = bytes;
            this.used = used;
            this.free = free;
            this.use = use;
            this.inodes = inodes;
            this.inodesUsed = inodesUsed;
            this.inodesFree = inodesFree;
            this.inodeUse = inodeUse;
            this.fsType = fsType;
            this.mountOptions = mountOptions;
            this.extState = extState;
            this.extMaxMount = extMaxMount;
            this.extCheckInterval = extCheckInterval;
        }

        public String getMountPoint() {
            return this.mountPoint;
        }

        public String getDevice() {
            return this.device;
        }

        public long getBytes() {
            return this.bytes;
        }

        public long getUsed() {
            return this.used;
        }

        public long getFree() {
            return this.free;
        }

        public byte getUse() {
            return this.use;
        }

        public Long getInodes() {
            return this.inodes;
        }

        public Long getInodesUsed() {
            return this.inodesUsed;
        }

        public Long getInodesFree() {
            return this.inodesFree;
        }

        public Byte getInodeUse() {
            return this.inodeUse;
        }

        public String getFsType() {
            return this.fsType;
        }

        public String getMountOptions() {
            return this.mountOptions;
        }

        public String getExtState() {
            return this.extState;
        }

        public String getExtMaxMount() {
            return this.extMaxMount;
        }

        public String getExtCheckInterval() {
            return this.extCheckInterval;
        }

        public String getConfigMessage() {
            switch (this.fsType) {
                case "ext3": {
                    if (!"-1".equals(this.extMaxMount)) {
                        return RESOURCES.getMessage("FilesystemReport.configMessage.extmaxmount.ext3", new Object[]{this.extMaxMount});
                    }
                    if (!"0 (<none>)".equals(this.extCheckInterval)) {
                        return RESOURCES.getMessage("FilesystemReport.configMessage.extchkint.ext3", new Object[]{this.extCheckInterval});
                    }
                    return null;
                }
                case "ext2": {
                    if ("-1".equals(this.extMaxMount)) {
                        return RESOURCES.getMessage("FilesystemReport.configMessage.extmaxmount.ext2", new Object[]{this.extMaxMount});
                    }
                    if ("0 (<none>)".equals(this.extCheckInterval)) {
                        return RESOURCES.getMessage("FilesystemReport.configMessage.extchkint.ext2", new Object[]{this.extCheckInterval});
                    }
                    return null;
                }
            }
            return null;
        }

        public boolean isClean() {
            switch (this.fsType) {
                case "ext3": {
                    return "clean".equals(this.extState);
                }
                case "ext2": {
                    return "not clean".equals(this.extState) || "clean".equals(this.extState);
                }
            }
            return true;
        }
    }

    public static class LvmReport {
        private final Map<String, VolumeGroup> volumeGroups;
        private final Map<String, PhysicalVolume> physicalVolumes;

        private static boolean overlaps(long start1, long size1, long start2, long size2) {
            return start2 + size2 > start1 && start1 + size1 > start2;
        }

        private LvmReport(String vgs, String pvs, String lvs) throws ParseException {
            this.volumeGroups = VolumeGroup.parseVgsReport(vgs);
            this.physicalVolumes = PhysicalVolume.parsePvsReport(pvs, this.volumeGroups);
            LogicalVolume.parseLvsReport(lvs, this.volumeGroups, this.physicalVolumes);
        }

        public PhysicalVolume getPhysicalVolume(String pvName) {
            return this.physicalVolumes.get(pvName);
        }

        public Map<String, PhysicalVolume> getPhysicalVolumes() {
            return this.physicalVolumes;
        }

        public VolumeGroup getVolumeGroup(String vgName) {
            return this.volumeGroups.get(vgName);
        }

        public Map<String, VolumeGroup> getVolumeGroups() {
            return this.volumeGroups;
        }

        public static class Stripe
        implements Comparable<Stripe> {
            private final Segment segment;
            private final PhysicalVolume physicalVolume;
            private final long firstPe;
            private final long lastPe;

            private Stripe(Segment segment, PhysicalVolume physicalVolume, long firstPe, long lastPe) {
                this.segment = segment;
                this.physicalVolume = physicalVolume;
                this.firstPe = firstPe;
                this.lastPe = lastPe;
            }

            public String toString() {
                return this.segment + ":" + this.physicalVolume + "(" + this.firstPe + "-" + this.lastPe + ")";
            }

            @Override
            public int compareTo(Stripe other) {
                int diff = this.segment.compareTo(other.segment);
                if (diff != 0) {
                    return diff;
                }
                if (this.firstPe < other.firstPe) {
                    return -1;
                }
                if (this.firstPe > other.firstPe) {
                    return 1;
                }
                return 0;
            }

            public Segment getSegment() {
                return this.segment;
            }

            public PhysicalVolume getPhysicalVolume() {
                return this.physicalVolume;
            }

            public long getFirstPe() {
                return this.firstPe;
            }

            public long getLastPe() {
                return this.lastPe;
            }

            public boolean overlaps(Stripe other) {
                return this != other && this.physicalVolume == other.physicalVolume && LvmReport.overlaps(this.firstPe, this.lastPe - this.firstPe + 1L, other.firstPe, other.lastPe - other.firstPe + 1L);
            }
        }

        public static class Segment
        implements Comparable<Segment> {
            private final LogicalVolume logicalVolume;
            private final SegmentType segtype;
            private final int stripeCount;
            private final long segStartPe;
            private final List<Stripe> stripes = new ArrayList<Stripe>();
            private final List<Stripe> unmodifiableStripes = Collections.unmodifiableList(this.stripes);

            private Segment(LogicalVolume logicalVolume, SegmentType segtype, int stripeCount, long segStartPe) {
                this.logicalVolume = logicalVolume;
                this.segtype = segtype;
                this.stripeCount = stripeCount;
                this.segStartPe = segStartPe;
            }

            public String toString() {
                return this.logicalVolume + "(" + this.segStartPe + "-" + this.getSegEndPe() + ")";
            }

            @Override
            public int compareTo(Segment other) {
                int diff = this.logicalVolume.compareTo(other.logicalVolume);
                if (diff != 0) {
                    return diff;
                }
                if (this.segStartPe < other.segStartPe) {
                    return -1;
                }
                if (this.segStartPe > other.segStartPe) {
                    return 1;
                }
                return 0;
            }

            public LogicalVolume getLogicalVolume() {
                return this.logicalVolume;
            }

            public SegmentType getSegtype() {
                return this.segtype;
            }

            public int getStripeCount() {
                return this.stripeCount;
            }

            public long getSegStartPe() {
                return this.segStartPe;
            }

            public long getSegEndPe() {
                long segmentCount = 0L;
                for (Stripe stripe : this.stripes) {
                    segmentCount += stripe.getLastPe() - stripe.getFirstPe() + 1L;
                }
                return this.segStartPe + segmentCount - 1L;
            }

            public List<Stripe> getStripes() {
                return this.unmodifiableStripes;
            }

            public boolean overlaps(Segment other) {
                return this != other && this.logicalVolume == other.logicalVolume && LvmReport.overlaps(this.segStartPe, this.getSegEndPe() - this.segStartPe + 1L, other.segStartPe, other.getSegEndPe() - other.segStartPe + 1L);
            }
        }

        public static enum SegmentType {
            linear,
            striped;

        }

        public static class LogicalVolume
        implements Comparable<LogicalVolume> {
            private final VolumeGroup volumeGroup;
            private final String lvName;
            private final int segCount;
            private final List<Segment> segments = new ArrayList<Segment>();
            private final List<Segment> unmodifiableSegments = Collections.unmodifiableList(this.segments);

            private static void parseLvsReport(String lvs, Map<String, VolumeGroup> volumeGroups, Map<String, PhysicalVolume> physicalVolumes) throws ParseException {
                List lines = Strings.splitLines((String)lvs);
                int size = lines.size();
                for (int c = 0; c < size; ++c) {
                    int lineNum = c + 1;
                    String line = (String)lines.get(c);
                    List fields = Strings.split((String)line, (char)'\t');
                    if (fields.size() != 7) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.badColumnCount", new Object[]{7, fields.size()}), lineNum);
                    }
                    String vgName = ((String)fields.get(0)).trim();
                    String lvName = ((String)fields.get(1)).trim();
                    int segCount = Integer.parseInt(((String)fields.get(2)).trim());
                    SegmentType segType = SegmentType.valueOf(((String)fields.get(3)).trim());
                    int stripeCount = Integer.parseInt(((String)fields.get(4)).trim());
                    long segStartPe = Long.parseLong(((String)fields.get(5)).trim());
                    List segPeRanges = Strings.split((String)((String)fields.get(6)).trim(), (char)' ');
                    VolumeGroup volumeGroup = volumeGroups.get(vgName);
                    if (volumeGroup == null) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.volumeGroupNotFound", new Object[]{vgName}), lineNum);
                    }
                    if (segCount < 1) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.badSegCount", new Object[]{segCount}), lineNum);
                    }
                    LogicalVolume logicalVolume = volumeGroup.getLogicalVolume(lvName);
                    if (logicalVolume == null) {
                        logicalVolume = new LogicalVolume(volumeGroup, lvName, segCount);
                        volumeGroup.logicalVolumes.put(lvName, logicalVolume);
                    } else if (segCount != logicalVolume.segCount) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.segCountChanged", new Object[]{logicalVolume.segCount, segCount}), lineNum);
                    }
                    if (stripeCount < 1) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.badStripeCount", new Object[]{stripeCount}), lineNum);
                    }
                    if (segPeRanges.size() != stripeCount) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.mismatchStripeCount"), lineNum);
                    }
                    Segment newSegment = new Segment(logicalVolume, segType, stripeCount, segStartPe);
                    for (Segment existingSegment : logicalVolume.segments) {
                        if (!newSegment.overlaps(existingSegment)) continue;
                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.segmentOverlap", new Object[]{existingSegment, newSegment}), lineNum);
                    }
                    logicalVolume.segments.add(newSegment);
                    for (String segPeRange : segPeRanges) {
                        int colonPos = segPeRange.indexOf(58);
                        if (colonPos == -1) {
                            throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.segPeRangeNoColon", new Object[]{segPeRange}), lineNum);
                        }
                        int dashPos = segPeRange.indexOf(45, colonPos + 1);
                        if (dashPos == -1) {
                            throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.segPeRangeNoDash", new Object[]{segPeRange}), lineNum);
                        }
                        String stripeDevice = segPeRange.substring(0, colonPos).trim();
                        PhysicalVolume stripePv = physicalVolumes.get(stripeDevice);
                        if (stripePv == null) {
                            throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.physicalVolumeNotFound", new Object[]{stripeDevice}), lineNum);
                        }
                        long firstPe = Long.parseLong(segPeRange.substring(colonPos + 1, dashPos).trim());
                        if (firstPe < 0L) {
                            throw new AssertionError((Object)("firstPe<0: " + firstPe));
                        }
                        long lastPe = Long.parseLong(segPeRange.substring(dashPos + 1).trim());
                        if (lastPe < firstPe) {
                            throw new AssertionError((Object)("lastPe<firstPe: " + lastPe + "<" + firstPe));
                        }
                        Stripe newStripe = new Stripe(newSegment, stripePv, firstPe, lastPe);
                        for (VolumeGroup existingVg : volumeGroups.values()) {
                            for (LogicalVolume existingLv : existingVg.logicalVolumes.values()) {
                                for (Segment existingSegment : existingLv.segments) {
                                    for (Stripe existingStripe : existingSegment.stripes) {
                                        if (!newStripe.overlaps(existingStripe)) continue;
                                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.stripeOverlap", new Object[]{existingStripe, newStripe}), lineNum);
                                    }
                                }
                            }
                        }
                        newSegment.stripes.add(newStripe);
                    }
                    Collections.sort(newSegment.stripes);
                }
                for (VolumeGroup volumeGroup : volumeGroups.values()) {
                    long actualFreeCount;
                    int actualLvCount;
                    int expectedLvCount = volumeGroup.getLvCount();
                    if (expectedLvCount != (actualLvCount = volumeGroup.logicalVolumes.size())) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.mismatchLvCount", new Object[]{volumeGroup}), 0);
                    }
                    long totalLvExtents = 0L;
                    for (LogicalVolume lv : volumeGroup.logicalVolumes.values()) {
                        for (Segment segment : lv.segments) {
                            for (Stripe stripe : segment.stripes) {
                                totalLvExtents += stripe.getLastPe() - stripe.getFirstPe() + 1L;
                            }
                        }
                    }
                    long expectedFreeCount = volumeGroup.vgFreeCount;
                    if (expectedFreeCount != (actualFreeCount = volumeGroup.vgExtentCount - totalLvExtents)) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.LogicalVolume.parseLsvReport.mismatchFreeCount", new Object[]{volumeGroup}), 0);
                    }
                    for (LogicalVolume logicalVolume : volumeGroup.logicalVolumes.values()) {
                        Collections.sort(logicalVolume.segments);
                    }
                }
            }

            private LogicalVolume(VolumeGroup volumeGroup, String lvName, int segCount) {
                this.volumeGroup = volumeGroup;
                this.lvName = lvName;
                this.segCount = segCount;
            }

            public String toString() {
                return this.volumeGroup + "/" + this.lvName;
            }

            @Override
            public int compareTo(LogicalVolume other) {
                int diff = this.volumeGroup.compareTo(other.volumeGroup);
                if (diff != 0) {
                    return diff;
                }
                return this.lvName.compareTo(other.lvName);
            }

            public VolumeGroup getVolumeGroup() {
                return this.volumeGroup;
            }

            public String getLvName() {
                return this.lvName;
            }

            public int getSegCount() {
                return this.segCount;
            }

            public List<Segment> getSegments() {
                return this.unmodifiableSegments;
            }
        }

        public static class PhysicalVolume
        implements Comparable<PhysicalVolume> {
            private final String pvName;
            private final long pvPeCount;
            private final long pvPeAllocCount;
            private final long pvSize;
            private final VolumeGroup volumeGroup;

            private static Map<String, PhysicalVolume> parsePvsReport(String pvs, Map<String, VolumeGroup> volumeGroups) throws ParseException {
                List lines = Strings.splitLines((String)pvs);
                int size = lines.size();
                HashMap physicalVolumes = AoCollections.newHashMap((int)size);
                HashMap vgPhysicalVolumeCounts = AoCollections.newHashMap((int)volumeGroups.size());
                HashMap vgExtentCountTotals = AoCollections.newHashMap((int)volumeGroups.size());
                HashMap vgAllocCountTotals = AoCollections.newHashMap((int)volumeGroups.size());
                for (int c = 0; c < size; ++c) {
                    VolumeGroup volumeGroup;
                    int lineNum = c + 1;
                    String line = (String)lines.get(c);
                    List fields = Strings.split((String)line, (char)'\t');
                    if (fields.size() != 5) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.PhysicalVolume.parsePvsReport.badColumnCount", new Object[]{5, fields.size()}), lineNum);
                    }
                    String pvName = ((String)fields.get(0)).trim();
                    String vgName = ((String)fields.get(4)).trim();
                    long pvPeCount = Long.parseLong(((String)fields.get(1)).trim());
                    long pvPeAllocCount = Long.parseLong(((String)fields.get(2)).trim());
                    String pvSizeString = ((String)fields.get(3)).trim();
                    if (pvSizeString.endsWith("B")) {
                        pvSizeString = pvSizeString.substring(0, pvSizeString.length() - 1);
                    }
                    long pvSize = Long.parseLong(pvSizeString);
                    if (vgName.length() == 0) {
                        if (pvPeCount != 0L || pvPeAllocCount != 0L) {
                            throw new ParseException(RESOURCES.getMessage("LvmReport.PhysicalVolume.parsePvsReport.invalidValues", new Object[]{pvPeCount, pvPeAllocCount, vgName}), lineNum);
                        }
                        volumeGroup = null;
                    } else {
                        if (pvPeCount < 1L && pvPeAllocCount < 0L && pvPeAllocCount > pvPeCount) {
                            throw new ParseException(RESOURCES.getMessage("LvmReport.PhysicalVolume.parsePvsReport.invalidValues", new Object[]{pvPeCount, pvPeAllocCount, vgName}), lineNum);
                        }
                        volumeGroup = volumeGroups.get(vgName);
                        if (volumeGroup == null) {
                            throw new ParseException(RESOURCES.getMessage("LvmReport.PhysicalVolume.parsePvsReport.volumeGroupNotFound", new Object[]{vgName}), lineNum);
                        }
                        Integer count = (Integer)vgPhysicalVolumeCounts.get(vgName);
                        vgPhysicalVolumeCounts.put(vgName, count == null ? 1 : count + 1);
                        Long vgExtentCountTotal = (Long)vgExtentCountTotals.get(vgName);
                        vgExtentCountTotals.put(vgName, vgExtentCountTotal == null ? pvPeCount : vgExtentCountTotal + pvPeCount);
                        Long vgFreeCountTotal = (Long)vgAllocCountTotals.get(vgName);
                        vgAllocCountTotals.put(vgName, vgFreeCountTotal == null ? pvPeAllocCount : vgFreeCountTotal + pvPeAllocCount);
                    }
                    if (physicalVolumes.put(pvName, new PhysicalVolume(pvName, pvPeCount, pvPeAllocCount, pvSize, volumeGroup)) == null) continue;
                    throw new ParseException(RESOURCES.getMessage("LvmReport.PhysicalVolume.parsePvsReport.pvNameFoundTwice", new Object[]{pvName}), lineNum);
                }
                for (Map.Entry<String, VolumeGroup> entry : volumeGroups.entrySet()) {
                    Long vgAllocCountTotalL;
                    long actualVgFreeCount;
                    long actualVgExtentCount;
                    int actualPvCount;
                    VolumeGroup volumeGroup = entry.getValue();
                    String vgName = entry.getKey();
                    int expectedPvCount = volumeGroup.getPvCount();
                    Integer actualPvCountI = (Integer)vgPhysicalVolumeCounts.get(vgName);
                    int n = actualPvCount = actualPvCountI == null ? 0 : actualPvCountI;
                    if (expectedPvCount != actualPvCount) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.PhysicalVolume.parsePvsReport.mismatchPvCount", new Object[]{vgName}), 0);
                    }
                    long expectedVgExtentCount = volumeGroup.getVgExtentCount();
                    Long actualVgExtentCountL = (Long)vgExtentCountTotals.get(vgName);
                    long l = actualVgExtentCount = actualVgExtentCountL == null ? 0L : actualVgExtentCountL;
                    if (expectedVgExtentCount != actualVgExtentCount) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.PhysicalVolume.parsePvsReport.badVgExtentCount", new Object[]{vgName}), 0);
                    }
                    long expectedVgFreeCount = volumeGroup.getVgFreeCount();
                    if (expectedVgFreeCount == (actualVgFreeCount = (vgAllocCountTotalL = (Long)vgAllocCountTotals.get(vgName)) == null ? expectedVgExtentCount : expectedVgExtentCount - vgAllocCountTotalL)) continue;
                    throw new ParseException(RESOURCES.getMessage("LvmReport.PhysicalVolume.parsePvsReport.badVgFreeCount", new Object[]{vgName}), 0);
                }
                return Collections.unmodifiableMap(physicalVolumes);
            }

            private PhysicalVolume(String pvName, long pvPeCount, long pvPeAllocCount, long pvSize, VolumeGroup volumeGroup) {
                this.pvName = pvName;
                this.pvPeCount = pvPeCount;
                this.pvPeAllocCount = pvPeAllocCount;
                this.pvSize = pvSize;
                this.volumeGroup = volumeGroup;
            }

            public String toString() {
                return this.pvName;
            }

            @Override
            public int compareTo(PhysicalVolume other) {
                return this.pvName.compareTo(other.pvName);
            }

            public String getPvName() {
                return this.pvName;
            }

            public long getPvPeAllocCount() {
                return this.pvPeAllocCount;
            }

            public long getPvPeCount() {
                return this.pvPeCount;
            }

            public long getPvSize() {
                return this.pvSize;
            }

            public VolumeGroup getVolumeGroup() {
                return this.volumeGroup;
            }
        }

        public static class VolumeGroup
        implements Comparable<VolumeGroup> {
            private final String vgName;
            private final int vgExtentSize;
            private final long vgExtentCount;
            private final long vgFreeCount;
            private final int pvCount;
            private final int lvCount;
            private final Map<String, LogicalVolume> logicalVolumes = new HashMap<String, LogicalVolume>();
            private final Map<String, LogicalVolume> unmodifiableLogicalVolumes = Collections.unmodifiableMap(this.logicalVolumes);

            private static Map<String, VolumeGroup> parseVgsReport(String vgs) throws ParseException {
                List lines = Strings.splitLines((String)vgs);
                int size = lines.size();
                HashMap volumeGroups = AoCollections.newHashMap((int)size);
                for (int c = 0; c < size; ++c) {
                    int lineNum = c + 1;
                    String line = (String)lines.get(c);
                    List fields = Strings.split((String)line, (char)'\t');
                    if (fields.size() != 6) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.VolumeGroup.parseVgsReport.badColumnCount", new Object[]{6, fields.size()}), lineNum);
                    }
                    String vgExtentSize = ((String)fields.get(1)).trim();
                    if (!vgExtentSize.endsWith("B")) {
                        throw new ParseException(RESOURCES.getMessage("LvmReport.VolumeGroup.parseVgsReport.invalidateVgExtentSize", new Object[]{vgExtentSize}), lineNum);
                    }
                    vgExtentSize = vgExtentSize.substring(0, vgExtentSize.length() - 1);
                    String vgName = ((String)fields.get(0)).trim();
                    if (volumeGroups.put(vgName, new VolumeGroup(vgName, Integer.parseInt(vgExtentSize), Long.parseLong(((String)fields.get(2)).trim()), Long.parseLong(((String)fields.get(3)).trim()), Integer.parseInt(((String)fields.get(4)).trim()), Integer.parseInt(((String)fields.get(5)).trim()))) == null) continue;
                    throw new ParseException(RESOURCES.getMessage("LvmReport.VolumeGroup.parseVgsReport.vgNameFoundTwice", new Object[]{vgName}), lineNum);
                }
                return Collections.unmodifiableMap(volumeGroups);
            }

            private VolumeGroup(String vgName, int vgExtentSize, long vgExtentCount, long vgFreeCount, int pvCount, int lvCount) {
                this.vgName = vgName;
                this.vgExtentSize = vgExtentSize;
                this.vgExtentCount = vgExtentCount;
                this.vgFreeCount = vgFreeCount;
                this.pvCount = pvCount;
                this.lvCount = lvCount;
            }

            public String toString() {
                return this.vgName;
            }

            @Override
            public int compareTo(VolumeGroup other) {
                return this.vgName.compareTo(other.vgName);
            }

            public int getLvCount() {
                return this.lvCount;
            }

            public int getPvCount() {
                return this.pvCount;
            }

            public long getVgExtentCount() {
                return this.vgExtentCount;
            }

            public int getVgExtentSize() {
                return this.vgExtentSize;
            }

            public long getVgFreeCount() {
                return this.vgFreeCount;
            }

            public String getVgName() {
                return this.vgName;
            }

            public LogicalVolume getLogicalVolume(String lvName) {
                return this.logicalVolumes.get(lvName);
            }

            public Map<String, LogicalVolume> getLogicalVolumes() {
                return this.unmodifiableLogicalVolumes;
            }
        }
    }

    public static class DrbdReport {
        private final String device;
        private final String resourceHostname;
        private final String resourceDevice;
        private final ConnectionState connectionState;
        private final DiskState localDiskState;
        private final DiskState remoteDiskState;
        private final Role localRole;
        private final Role remoteRole;
        private final Long lastVerified;
        private final Long outOfSync;

        DrbdReport(String device, String resourceHostname, String resourceDevice, ConnectionState connectionState, DiskState localDiskState, DiskState remoteDiskState, Role localRole, Role remoteRole, Long lastVerified, Long outOfSync) {
            this.device = device;
            this.resourceHostname = resourceHostname;
            this.resourceDevice = resourceDevice;
            this.connectionState = connectionState;
            this.localDiskState = localDiskState;
            this.remoteDiskState = remoteDiskState;
            this.localRole = localRole;
            this.remoteRole = remoteRole;
            this.lastVerified = lastVerified;
            this.outOfSync = outOfSync;
        }

        public ConnectionState getConnectionState() {
            return this.connectionState;
        }

        public String getDevice() {
            return this.device;
        }

        public DiskState getLocalDiskState() {
            return this.localDiskState;
        }

        public Role getLocalRole() {
            return this.localRole;
        }

        public DiskState getRemoteDiskState() {
            return this.remoteDiskState;
        }

        public Role getRemoteRole() {
            return this.remoteRole;
        }

        public String getResourceDevice() {
            return this.resourceDevice;
        }

        public String getResourceHostname() {
            return this.resourceHostname;
        }

        public Long getLastVerified() {
            return this.lastVerified;
        }

        public Long getOutOfSync() {
            return this.outOfSync;
        }

        public static enum DiskState {
            Unconfigured,
            Diskless,
            Attaching,
            Failed,
            Negotiating,
            Inconsistent,
            Outdated,
            DUnknown,
            Consistent,
            UpToDate;

        }

        public static enum Role {
            Unconfigured,
            Primary,
            Secondary,
            Unknown;

        }

        public static enum ConnectionState {
            Unconfigured,
            StandAlone,
            Disconnecting,
            Unconnected,
            Timeout,
            BrokenPipe,
            NetworkFailure,
            ProtocolError,
            TearDown,
            WFConnection,
            WFReportParams,
            Connected,
            StartingSyncS,
            StartingSyncT,
            WFBitMapS,
            WFBitMapT,
            WFSyncUUID,
            SyncSource,
            SyncTarget,
            PausedSyncS,
            PausedSyncT,
            VerifyS,
            VerifyT;

        }
    }

    public static class MdMismatchReport {
        private final String device;
        private final RaidLevel level;
        private final long count;

        MdMismatchReport(String device, RaidLevel level, long count) {
            this.device = device;
            this.level = level;
            this.count = count;
        }

        public String getDevice() {
            return this.device;
        }

        public RaidLevel getLevel() {
            return this.level;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static enum RaidLevel {
        linear,
        raid0,
        raid1,
        raid4,
        raid5,
        raid6,
        raid10;

    }

    public static class DaemonAccess {
        private final String protocol;
        private final HostAddress host;
        private final Port port;
        private final long key;

        public DaemonAccess(String protocol, HostAddress host, Port port, long key) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.key = key;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public HostAddress getHost() {
            return this.host;
        }

        public Port getPort() {
            return this.port;
        }

        public long getKey() {
            return this.key;
        }
    }
}

