/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.io.WriterOutputStream;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class ServerTable
extends CachedTableIntegerKey<Server> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("hostname", true)};

    ServerTable(AoservConnector connector) {
        super(connector, Server.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    @Deprecated
    public Server get(Object pkey) throws IOException, SQLException {
        if (pkey == null) {
            return null;
        }
        if (pkey instanceof Integer) {
            return this.get((Integer)pkey);
        }
        if (pkey instanceof DomainName) {
            return this.get((DomainName)pkey);
        }
        throw new IllegalArgumentException("Must be an Integer or a DomainName");
    }

    @Override
    public Server get(int pkey) throws IOException, SQLException {
        return (Server)this.getUniqueRow(0, pkey);
    }

    public Server get(DomainName hostname) throws IOException, SQLException {
        return (Server)this.getUniqueRow(1, hostname);
    }

    public Server getAoserverByDaemonNetBind(Bind nb) throws IOException, SQLException {
        int bind_id = nb.getId();
        List servers = this.getRows();
        int size = servers.size();
        for (int c = 0; c < size; ++c) {
            Server se = (Server)servers.get(c);
            Integer daemonBind_id = se.getDaemonBind_id();
            if (daemonBind_id == null || daemonBind_id != bind_id) continue;
            return se;
        }
        return null;
    }

    public Server getAoserverByJilterNetBind(Bind nb) throws IOException, SQLException {
        int bind_id = nb.getId();
        List servers = this.getRows();
        int size = servers.size();
        for (int c = 0; c < size; ++c) {
            Server se = (Server)servers.get(c);
            Integer jilterBind_id = se.getJilterBind_id();
            if (jilterBind_id == null || jilterBind_id != bind_id) continue;
            return se;
        }
        return null;
    }

    List<Server> getNestedServers(Server server) throws IOException, SQLException {
        int pkey = server.getPkey();
        List servers = this.getRows();
        int size = servers.size();
        ArrayList<Server> objs = new ArrayList<Server>();
        for (int c = 0; c < size; ++c) {
            Server se = (Server)servers.get(c);
            Integer fs = se.getFailoverServer_server_pkey();
            if (fs == null || fs != pkey) continue;
            objs.add(se);
        }
        return objs;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.AO_SERVERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("get_mrtg_file")) {
            if (Aosh.checkParamCount("get_mrtg_file", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().getMrtgFile(args[1], args[2], (OutputStream)new WriterOutputStream((Writer)out));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_ups_status")) {
            if (Aosh.checkParamCount("get_ups_status", args, 1, (PrintWriter)err)) {
                out.write(this.connector.getSimpleClient().getUpsStatus(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("restart_apache")) {
            if (Aosh.checkParamCount("restart_apache", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().restartApache(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("restart_cron")) {
            if (Aosh.checkParamCount("restart_cron", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().restartCron(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("restart_xfs")) {
            if (Aosh.checkParamCount("restart_xfs", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().restartXfs(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("restart_xvfb")) {
            if (Aosh.checkParamCount("restart_xvfb", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().restartXvfb(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("start_apache")) {
            if (Aosh.checkParamCount("start_apache", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().startApache(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("start_cron")) {
            if (Aosh.checkParamCount("start_cron", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().startCron(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("start_xfs")) {
            if (Aosh.checkParamCount("start_xfs", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().startXfs(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("start_xvfb")) {
            if (Aosh.checkParamCount("start_xvfb", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().startXvfb(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("stop_apache")) {
            if (Aosh.checkParamCount("stop_apache", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().stopApache(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("stop_cron")) {
            if (Aosh.checkParamCount("stop_cron", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().stopCron(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("stop_xfs")) {
            if (Aosh.checkParamCount("stop_xfs", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().stopXfs(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("stop_xvfb")) {
            if (Aosh.checkParamCount("stop_xvfb", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().stopXvfb(args[1]);
            }
            return true;
        }
        return false;
    }
}

