/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.linux.GlobalObjectPosixPathKey;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Shell
extends GlobalObjectPosixPathKey<Shell> {
    static final int COLUMN_PATH = 0;
    static final String COLUMN_PATH_name = "path";
    public static final PosixPath BASH;
    public static final PosixPath FALSE;
    public static final PosixPath KSH;
    public static final PosixPath SH;
    public static final PosixPath SYNC;
    public static final PosixPath TCSH;
    public static final PosixPath HALT;
    public static final PosixPath NOLOGIN;
    public static final PosixPath SHUTDOWN;
    public static final PosixPath FTPONLY;
    public static final PosixPath FTPPASSWD;
    public static final PosixPath GIT_SHELL;
    public static final PosixPath PASSWD;
    private boolean isLogin;
    private boolean isSystem;

    @Deprecated
    public Shell() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.isLogin;
        }
        if (i == 2) {
            return this.isSystem;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public PosixPath getPath() {
        return this.pkey;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SHELLS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = PosixPath.valueOf(result.getString(1));
            this.isLogin = result.getBoolean(2);
            this.isSystem = result.getBoolean(3);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isLogin() {
        return this.isLogin;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = PosixPath.valueOf(in.readUTF()).intern();
            this.isLogin = in.readBoolean();
            this.isSystem = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        out.writeBoolean(this.isLogin);
        out.writeBoolean(this.isSystem);
    }

    static {
        try {
            BASH = PosixPath.valueOf("/bin/bash").intern();
            FALSE = PosixPath.valueOf("/bin/false").intern();
            KSH = PosixPath.valueOf("/bin/ksh").intern();
            SH = PosixPath.valueOf("/bin/sh").intern();
            SYNC = PosixPath.valueOf("/bin/sync").intern();
            TCSH = PosixPath.valueOf("/bin/tcsh").intern();
            HALT = PosixPath.valueOf("/sbin/halt").intern();
            NOLOGIN = PosixPath.valueOf("/sbin/nologin").intern();
            SHUTDOWN = PosixPath.valueOf("/sbin/shutdown").intern();
            FTPONLY = PosixPath.valueOf("/usr/bin/ftponly").intern();
            FTPPASSWD = PosixPath.valueOf("/usr/bin/ftppasswd").intern();
            GIT_SHELL = PosixPath.valueOf("/usr/bin/git-shell").intern();
            PASSWD = PosixPath.valueOf("/usr/bin/passwd").intern();
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
    }
}

