/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.dto.DtoFactory;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.io.FastExternalizable;
import com.aoapps.lang.util.ComparatorUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.Email;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.dto.LinuxUserName;
import com.aoindustries.aoserv.client.ftp.GuestUser;
import com.aoindustries.aoserv.client.linux.CachedObjectUserNameKey;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.GroupUser;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.Shell;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.linux.UserType;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.password.PasswordProtected;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class User
extends CachedObjectUserNameKey<User>
implements PasswordProtected,
Removable,
Disablable {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, User.class);
    static final int COLUMN_USERNAME = 0;
    static final String COLUMN_USERNAME_name = "username";
    public static final Name ADM;
    public static final Name AOADMIN;
    public static final Name AOSERV_JILTER;
    public static final Name AOSERV_XEN_MIGRATION;
    public static final Name APACHE;
    public static final Name AVAHI_AUTOIPD;
    public static final Name AWSTATS;
    public static final Name BIN;
    public static final Name BIRD;
    public static final Name CHRONY;
    public static final Name CLAMSCAN;
    public static final Name CLAMUPDATE;
    public static final Name CYRUS;
    public static final Name DAEMON;
    public static final Name DBUS;
    public static final Name DHCPD;
    public static final Name EMAILMON;
    public static final Name FTP;
    public static final Name FTPMON;
    public static final Name GAMES;
    public static final Name HALT;
    public static final Name INTERBASE;
    public static final Name LP;
    public static final Name MAIL;
    public static final Name MAILNULL;
    public static final Name MEMCACHED;
    public static final Name MYSQL;
    public static final Name NAMED;
    public static final Name NFSNOBODY;
    public static final Name NGINX;
    public static final Name NOBODY;
    public static final Name OPERATOR;
    public static final Name POLKITD;
    public static final Name POSTGRES;
    public static final Name REDIS;
    public static final Name ROOT;
    public static final Name RPC;
    public static final Name RPCUSER;
    public static final Name SASLAUTH;
    public static final Name SHUTDOWN;
    public static final Name SMMSP;
    public static final Name SSHD;
    public static final Name SYNC;
    public static final Name SYSTEMD_BUS_PROXY;
    public static final Name SYSTEMD_NETWORK;
    public static final Name TCPDUMP;
    public static final Name TSS;
    public static final Name UNBOUND;
    public static final Name AOSERV_MASTER;
    public static final Name ACCOUNTING;
    public static final Name BILLING;
    public static final Name DISTRIBUTION;
    public static final Name INFRASTRUCTURE;
    public static final Name MANAGEMENT;
    public static final Name MONITORING;
    public static final Name RESELLER;
    public static final Name CENTOS;
    public static final Name JENKINS;
    public static final Name OPROFILE;
    public static final Name SONARQUBE;
    @Deprecated
    public static final Name HTTPD;
    public static final String NO_PASSWORD_CONFIG_VALUE = "!!";
    private Gecos name;
    private Gecos officeLocation;
    private Gecos officePhone;
    private Gecos homePhone;
    private String type;
    private PosixPath shell;
    private UnmodifiableTimestamp created;
    private int disableLog;

    @Deprecated
    public User() {
    }

    public void addFtpGuestUser() throws IOException, SQLException {
        this.table.getConnector().getFtp().getGuestUser().addFtpGuestUser(this.pkey);
    }

    public void addLinuxGroup(Group group) throws IOException, SQLException {
        this.table.getConnector().getLinux().getGroupUser().addLinuxGroupAccount(group, this);
    }

    public int addLinuxServerAccount(Server aoServer, PosixPath home) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getUserServer().addLinuxServerAccount(this, aoServer, home);
    }

    @Override
    public int arePasswordsSet() throws IOException, SQLException {
        return com.aoindustries.aoserv.client.account.User.groupPasswordsSet(this.getLinuxServerAccounts());
    }

    @Override
    public boolean canDisable() throws IOException, SQLException {
        if (this.disableLog != -1) {
            return false;
        }
        for (UserServer lsa : this.getLinuxServerAccounts()) {
            if (lsa.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getUsername().isDisabled();
    }

    @Override
    public List<PasswordChecker.Result> checkPassword(String password) throws IOException {
        return User.checkPassword(this.pkey, this.type, password);
    }

    public static List<PasswordChecker.Result> checkPassword(Name username, String type, String password) throws IOException {
        return PasswordChecker.checkPassword(username, password, UserType.getPasswordStrength(type));
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.LINUX_ACCOUNTS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.LINUX_ACCOUNTS, this.pkey});
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.officeLocation;
            }
            case 3: {
                return this.officePhone;
            }
            case 4: {
                return this.homePhone;
            }
            case 5: {
                return this.type;
            }
            case 6: {
                return this.shell;
            }
            case 7: {
                return this.created;
            }
            case 8: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public GuestUser getFtpGuestUser() throws IOException, SQLException {
        return this.table.getConnector().getFtp().getGuestUser().get(this.pkey);
    }

    public Gecos getHomePhone() {
        return this.homePhone;
    }

    public List<Group> getLinuxGroups() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupUser().getLinuxGroups(this);
    }

    public UserServer getLinuxServerAccount(Server aoServer) throws IOException, SQLException {
        return this.table.getConnector().getLinux().getUserServer().getLinuxServerAccount(aoServer, this.pkey);
    }

    public List<UserServer> getLinuxServerAccounts() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getUserServer().getLinuxServerAccounts(this);
    }

    public Gecos getName() {
        return this.name;
    }

    public Gecos getOfficeLocation() {
        return this.officeLocation;
    }

    public Gecos getOfficePhone() {
        return this.officePhone;
    }

    public Group getPrimaryGroup() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroupUser().getPrimaryGroup(this);
    }

    public Shell getShell() throws SQLException, IOException {
        Shell shellObject = this.table.getConnector().getLinux().getShell().get(this.shell);
        if (shellObject == null) {
            throw new SQLException("Unable to find Shell: " + this.shell);
        }
        return shellObject;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_ACCOUNTS;
    }

    public UserType getType() throws IOException, SQLException {
        UserType typeObject = this.table.getConnector().getLinux().getUserType().get(this.type);
        if (typeObject == null) {
            throw new IllegalArgumentException(new SQLException("Unable to find LinuxAccountType: " + this.type));
        }
        return typeObject;
    }

    public Name getUsername_id() {
        return this.pkey;
    }

    public com.aoindustries.aoserv.client.account.User getUsername() throws SQLException, IOException {
        com.aoindustries.aoserv.client.account.User usernameObject = this.table.getConnector().getAccount().getUser().get(this.pkey);
        if (usernameObject == null) {
            throw new SQLException("Unable to find Username: " + this.pkey);
        }
        return usernameObject;
    }

    public List<PosixPath> getValidHomeDirectories(Server ao) throws SQLException, IOException {
        return User.getValidHomeDirectories(this.pkey, ao);
    }

    public static List<PosixPath> getValidHomeDirectories(Name username, Server ao) throws SQLException, IOException {
        try {
            ArrayList<PosixPath> dirs = new ArrayList<PosixPath>();
            if (username != null) {
                dirs.add(UserServer.getDefaultHomeDirectory(username));
                dirs.add(UserServer.getHashedHomeDirectory(username));
            }
            List<Site> hss = ao.getHttpdSites();
            int hsslen = hss.size();
            for (int c = 0; c < hsslen; ++c) {
                Site hs = hss.get(c);
                PosixPath siteDir = hs.getInstallDirectory();
                dirs.add(siteDir);
                if (hs.getHttpdTomcatSite() == null) continue;
                dirs.add(PosixPath.valueOf(siteDir.toString() + "/webapps"));
            }
            List<SharedTomcat> hsts = ao.getHttpdSharedTomcats();
            int hstslen = hsts.size();
            for (int c = 0; c < hstslen; ++c) {
                SharedTomcat hst = hsts.get(c);
                dirs.add(PosixPath.valueOf(hst.getLinuxServer().getHost().getOperatingSystemVersion().getHttpdSharedTomcatsDirectory().toString() + '/' + hst.getName()));
            }
            return dirs;
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = Name.valueOf(result.getString(1));
            this.name = Gecos.valueOf(result.getString(2));
            this.officeLocation = Gecos.valueOf(result.getString(3));
            this.officePhone = Gecos.valueOf(result.getString(4));
            this.homePhone = Gecos.valueOf(result.getString(5));
            this.type = result.getString(6);
            this.shell = PosixPath.valueOf(result.getString(7));
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(8));
            this.disableLog = result.getInt(9);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = Name.valueOf(in.readUTF()).intern();
            this.name = Gecos.valueOf(in.readNullUTF());
            this.officeLocation = Gecos.valueOf(in.readNullUTF());
            this.officePhone = Gecos.valueOf(in.readNullUTF());
            this.homePhone = Gecos.valueOf(in.readNullUTF());
            this.type = in.readUTF().intern();
            this.shell = PosixPath.valueOf(in.readUTF()).intern();
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.disableLog = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList reasons = new ArrayList();
        for (UserServer lsa : this.getLinuxServerAccounts()) {
            reasons.addAll(lsa.getCannotRemoveReasons());
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.LINUX_ACCOUNTS, this.pkey});
    }

    public void removeLinuxGroup(Group group) throws IOException, SQLException {
        for (GroupUser lga : this.table.getConnector().getLinux().getGroupUser().getLinuxGroupAccounts(group.getName(), this.pkey)) {
            lga.remove();
        }
    }

    public void setHomePhone(Gecos phone) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_ACCOUNT_HOME_PHONE, this.pkey, phone == null ? "" : phone.toString());
    }

    public void setName(Gecos name) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_ACCOUNT_NAME, this.pkey, name == null ? "" : name.toString());
    }

    public void setOfficeLocation(Gecos location) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_ACCOUNT_OFFICE_LOCATION, this.pkey, location == null ? "" : location.toString());
    }

    public void setOfficePhone(Gecos phone) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_ACCOUNT_OFFICE_PHONE, this.pkey, phone == null ? "" : phone.toString());
    }

    @Override
    public void setPassword(String password) throws SQLException, IOException {
        for (UserServer lsa : this.getLinuxServerAccounts()) {
            if (!lsa.canSetPassword()) continue;
            lsa.setPassword(password);
        }
    }

    public void setShell(Shell shell) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_ACCOUNT_SHELL, this.pkey, shell.getPath());
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80_1) < 0) {
            out.writeUTF(this.name == null ? "*" : this.name.toString());
        } else {
            out.writeNullUTF(Objects.toString(this.name, null));
        }
        out.writeNullUTF(Objects.toString(this.officeLocation, null));
        out.writeNullUTF(Objects.toString(this.officePhone, null));
        out.writeNullUTF(Objects.toString(this.homePhone, null));
        out.writeUTF(this.type);
        out.writeUTF(this.shell.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        out.writeCompressedInt(this.disableLog);
    }

    @Override
    public boolean canSetPassword() throws IOException, SQLException {
        return this.disableLog == -1 && this.getType().canSetPassword();
    }

    public void setPrimaryLinuxGroup(Group group) throws SQLException, IOException {
        List<GroupUser> lgas = this.table.getConnector().getLinux().getGroupUser().getLinuxGroupAccounts(group.getName(), this.pkey);
        if (lgas.isEmpty()) {
            throw new SQLException("Unable to find LinuxGroupAccount for username=" + this.pkey + " and group=" + group.getName());
        }
        if (lgas.size() > 1) {
            throw new SQLException("Found more than one LinuxGroupAccount for username=" + this.pkey + " and group=" + group.getName());
        }
        lgas.get(0).setAsPrimary();
    }

    static {
        try {
            ADM = Name.valueOf("adm");
            AOADMIN = Name.valueOf("aoadmin");
            AOSERV_JILTER = Name.valueOf("aoserv-jilter");
            AOSERV_XEN_MIGRATION = Name.valueOf("aoserv-xen-migration");
            APACHE = Name.valueOf("apache");
            AVAHI_AUTOIPD = Name.valueOf("avahi-autoipd");
            AWSTATS = Name.valueOf("awstats");
            BIN = Name.valueOf("bin");
            BIRD = Name.valueOf("bird");
            CHRONY = Name.valueOf("chrony");
            CLAMSCAN = Name.valueOf("clamscan");
            CLAMUPDATE = Name.valueOf("clamupdate");
            CYRUS = Name.valueOf("cyrus");
            DAEMON = Name.valueOf("daemon");
            DBUS = Name.valueOf("dbus");
            DHCPD = Name.valueOf("dhcpd");
            EMAILMON = Name.valueOf("emailmon");
            FTP = Name.valueOf("ftp");
            FTPMON = Name.valueOf("ftpmon");
            GAMES = Name.valueOf("games");
            HALT = Name.valueOf("halt");
            INTERBASE = Name.valueOf("interbase");
            LP = Name.valueOf("lp");
            MAIL = Name.valueOf("mail");
            MAILNULL = Name.valueOf("mailnull");
            MEMCACHED = Name.valueOf("memcached");
            MYSQL = Name.valueOf("mysql");
            NAMED = Name.valueOf("named");
            NFSNOBODY = Name.valueOf("nfsnobody");
            NGINX = Name.valueOf("nginx");
            NOBODY = Name.valueOf("nobody");
            OPERATOR = Name.valueOf("operator");
            POLKITD = Name.valueOf("polkitd");
            POSTGRES = Name.valueOf("postgres");
            REDIS = Name.valueOf("redis");
            ROOT = Name.valueOf("root");
            RPC = Name.valueOf("rpc");
            RPCUSER = Name.valueOf("rpcuser");
            SASLAUTH = Name.valueOf("saslauth");
            SHUTDOWN = Name.valueOf("shutdown");
            SMMSP = Name.valueOf("smmsp");
            SSHD = Name.valueOf("sshd");
            SYNC = Name.valueOf("sync");
            SYSTEMD_BUS_PROXY = Name.valueOf("systemd-bus-proxy");
            SYSTEMD_NETWORK = Name.valueOf("systemd-network");
            TCPDUMP = Name.valueOf("tcpdump");
            TSS = Name.valueOf("tss");
            UNBOUND = Name.valueOf("unbound");
            AOSERV_MASTER = Name.valueOf("aoserv-master");
            ACCOUNTING = Name.valueOf("accounting");
            BILLING = Name.valueOf("billing");
            DISTRIBUTION = Name.valueOf("distribution");
            INFRASTRUCTURE = Name.valueOf("infrastructure");
            MANAGEMENT = Name.valueOf("management");
            MONITORING = Name.valueOf("monitoring");
            RESELLER = Name.valueOf("reseller");
            CENTOS = Name.valueOf("centos");
            JENKINS = Name.valueOf("jenkins");
            OPROFILE = Name.valueOf("oprofile");
            SONARQUBE = Name.valueOf("sonarqube");
            HTTPD = Name.valueOf("httpd");
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
    }

    public static class Name
    extends User.Name
    implements FastExternalizable {
        public static final int LINUX_NAME_MAX_LENGTH = 32;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private static final long serialVersionUID = 2L;

        public static ValidationResult validate(String name) {
            if (name == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = name.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
            }
            if (len > 32) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(32), Integer.valueOf(len)});
            }
            char ch = name.charAt(0);
            if (ch < 'a' || ch > 'z') {
                return new InvalidResult(RESOURCES, "Name.validate.startAToZ");
            }
            boolean hasAt = false;
            block16: for (int c = 1; c < len; ++c) {
                ch = name.charAt(c);
                if (ch == ' ') {
                    return new InvalidResult(RESOURCES, "Name.validate.noSpace");
                }
                if (ch <= '!' || ch > '\u007f') {
                    return new InvalidResult(RESOURCES, "Name.validate.specialCharacter");
                }
                if (ch >= 'A' && ch <= 'Z') {
                    return new InvalidResult(RESOURCES, "Name.validate.noCapital");
                }
                switch (ch) {
                    case ',': {
                        return new InvalidResult(RESOURCES, "Name.validate.comma");
                    }
                    case ':': {
                        return new InvalidResult(RESOURCES, "Name.validate.colon");
                    }
                    case '(': {
                        return new InvalidResult(RESOURCES, "Name.validate.leftParen");
                    }
                    case ')': {
                        return new InvalidResult(RESOURCES, "Name.validate.rightParen");
                    }
                    case '[': {
                        return new InvalidResult(RESOURCES, "Name.validate.leftSquare");
                    }
                    case ']': {
                        return new InvalidResult(RESOURCES, "Name.validate.rightSquare");
                    }
                    case '\'': {
                        return new InvalidResult(RESOURCES, "Name.validate.apostrophe");
                    }
                    case '\"': {
                        return new InvalidResult(RESOURCES, "Name.validate.quote");
                    }
                    case '|': {
                        return new InvalidResult(RESOURCES, "Name.validate.verticalBar");
                    }
                    case '&': {
                        return new InvalidResult(RESOURCES, "Name.validate.ampersand");
                    }
                    case ';': {
                        return new InvalidResult(RESOURCES, "Name.validate.semicolon");
                    }
                    case '\\': {
                        return new InvalidResult(RESOURCES, "Name.validate.backslash");
                    }
                    case '/': {
                        return new InvalidResult(RESOURCES, "Name.validate.slash");
                    }
                    case '@': {
                        hasAt = true;
                        continue block16;
                    }
                }
            }
            if (hasAt) {
                ValidationResult result = Email.validate((String)name);
                if (!result.isValid()) {
                    return result;
                }
                if (name.startsWith("cyrus@")) {
                    return new InvalidResult(RESOURCES, "Name.validate.startWithCyrusAt");
                }
            }
            assert (User.Name.validate(name).isValid()) : "A Linux User.Name is always a valid Account User.Name.";
            return ValidResult.getInstance();
        }

        public static Name valueOf(String name) throws ValidationException {
            if (name == null) {
                return null;
            }
            return new Name(name, true);
        }

        protected Name(String name, boolean validate) throws ValidationException {
            super(name, validate);
        }

        protected Name(String name) {
            super(name);
        }

        @Override
        protected void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        @Override
        public Name intern() {
            Name addMe;
            String internedId;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedId, addMe = this.name == (internedId = this.name.intern()) ? this : new Name(internedId))) == null) {
                existing = addMe;
            }
            return existing;
        }

        @Override
        public LinuxUserName getDto() {
            return new LinuxUserName(this.name);
        }

        @Deprecated
        public Name() {
        }

        @Override
        public long getSerialVersionUID() {
            return 2L;
        }
    }

    public static final class Gecos
    implements Comparable<Gecos>,
    Serializable,
    DtoFactory<com.aoindustries.aoserv.client.dto.Gecos>,
    Internable<Gecos> {
        private static final long serialVersionUID = -117164942375352467L;
        public static final int MAX_LENGTH = 100;
        private static final ConcurrentMap<String, Gecos> interned = new ConcurrentHashMap<String, Gecos>();
        private final String value;

        public static ValidationResult validate(String value) {
            if (value == null) {
                return new InvalidResult(RESOURCES, "Gecos.validate.isNull");
            }
            int len = value.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Gecos.validate.isEmpty");
            }
            if (len > 100) {
                return new InvalidResult(RESOURCES, "Gecos.validate.tooLong", new Serializable[]{Integer.valueOf(100), Integer.valueOf(len)});
            }
            for (int c = 0; c < len; ++c) {
                char ch = value.charAt(c);
                if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == '@' || ch == ' ' || ch == '.' || ch == '#' || ch == '=' || ch == '/' || ch == '$' || ch == '%' || ch == '^' || ch == '&' || ch == '*' || ch == '(' || ch == ')' || ch == '?' || ch == '\'' || ch == '+') continue;
                return new InvalidResult(RESOURCES, "Gecos.validate.invalidCharacter", new Serializable[]{Character.valueOf(ch)});
            }
            return ValidResult.getInstance();
        }

        public static Gecos valueOf(String value) throws ValidationException {
            if (value == null) {
                return null;
            }
            return new Gecos(value, true);
        }

        private Gecos(String value, boolean validate) throws ValidationException {
            this.value = value;
            if (validate) {
                this.validate();
            }
        }

        private Gecos(String value) {
            ValidationResult result;
            assert ((result = Gecos.validate(value)).isValid()) : result.toString();
            this.value = value;
        }

        private void validate() throws ValidationException {
            ValidationResult result = Gecos.validate(this.value);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            try {
                this.validate();
            }
            catch (ValidationException err) {
                InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
                newErr.initCause(err);
                throw newErr;
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof Gecos && this.value.equals(((Gecos)obj).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public int compareTo(Gecos other) {
            return this == other ? 0 : ComparatorUtils.compareIgnoreCaseConsistentWithEquals((String)this.value, (String)other.value);
        }

        public String toString() {
            return this.value;
        }

        public Gecos intern() {
            Gecos addMe;
            String internedValue;
            Gecos existing = (Gecos)interned.get(this.value);
            if (existing == null && (existing = interned.putIfAbsent(internedValue, addMe = this.value == (internedValue = this.value.intern()) ? this : new Gecos(internedValue))) == null) {
                existing = addMe;
            }
            return existing;
        }

        public com.aoindustries.aoserv.client.dto.Gecos getDto() {
            return new com.aoindustries.aoserv.client.dto.Gecos(this.value);
        }
    }
}

