/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.AttachmentBlock;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.InboxAddress;
import com.aoindustries.aoserv.client.email.InboxAttributes;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.email.SpamAssassinMode;
import com.aoindustries.aoserv.client.ftp.PrivateServer;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.LinuxId;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.password.PasswordProtected;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.scm.CvsRepository;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public final class UserServer
extends CachedObjectIntegerKey<UserServer>
implements Removable,
PasswordProtected,
Disablable {
    public static final int ROOT_UID = 0;
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_USERNAME = 1;
    static final int COLUMN_AO_SERVER = 2;
    public static final String COLUMN_USERNAME_name = "username";
    public static final String COLUMN_AO_SERVER_name = "ao_server";
    public static final int DEFAULT_TRASH_EMAIL_RETENTION = 31;
    public static final int DEFAULT_JUNK_EMAIL_RETENTION = 31;
    public static final float DEFAULT_SPAM_ASSASSIN_REQUIRED_SCORE = 3.0f;
    public static final int DEFAULT_SPAM_ASSASSIN_DISCARD_SCORE = 20;
    private User.Name username;
    private int aoServer;
    private LinuxId uid;
    private PosixPath home;
    private int autoresponderFrom;
    private String autoresponderSubject;
    private String autoresponderPath;
    private boolean isAutoresponderEnabled;
    private int disableLog;
    private String predisablePassword;
    private UnmodifiableTimestamp created;
    private boolean useInbox;
    private int trashEmailRetention;
    private int junkEmailRetention;
    private String saIntegrationMode;
    private float saRequiredScore;
    private int saDiscardScore;
    private String sudo;

    @Deprecated
    public UserServer() {
    }

    @Override
    public boolean canDisable() throws IOException, SQLException {
        if (this.disableLog != -1) {
            return false;
        }
        if (this.uid.compareTo(this.getServer().getUidMin()) < 0) {
            return false;
        }
        for (CvsRepository cr : this.getCvsRepositories()) {
            if (cr.isDisabled()) continue;
            return false;
        }
        for (SharedTomcat hst : this.getHttpdSharedTomcats()) {
            if (hst.isDisabled()) continue;
            return false;
        }
        for (com.aoindustries.aoserv.client.email.List el : this.getEmailLists()) {
            if (el.isDisabled()) continue;
            return false;
        }
        for (Site hs : this.getHttpdSites()) {
            if (hs.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getLinuxAccount().isDisabled();
    }

    @Override
    public List<PasswordChecker.Result> checkPassword(String password) throws SQLException, IOException {
        return this.getLinuxAccount().checkPassword(password);
    }

    public long copyHomeDirectory(final Server toServer) throws IOException, SQLException {
        return this.table.getConnector().requestResult(false, AoservProtocol.CommandId.COPY_HOME_DIRECTORY, new AoservConnector.ResultRequest<Long>(){
            private long result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(UserServer.this.pkey);
                out.writeCompressedInt(toServer.getPkey());
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.result = in.readLong();
            }

            @Override
            public Long afterRelease() {
                return this.result;
            }
        });
    }

    public void copyPassword(UserServer other) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.COPY_LINUX_SERVER_ACCOUNT_PASSWORD, this.pkey, other.getPkey());
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.LINUX_SERVER_ACCOUNTS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.LINUX_SERVER_ACCOUNTS, this.pkey});
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.username;
            }
            case 2: {
                return this.aoServer;
            }
            case 3: {
                return this.uid;
            }
            case 4: {
                return this.home;
            }
            case 5: {
                return this.autoresponderFrom == -1 ? null : Integer.valueOf(this.autoresponderFrom);
            }
            case 6: {
                return this.autoresponderSubject;
            }
            case 7: {
                return this.autoresponderPath;
            }
            case 8: {
                return this.isAutoresponderEnabled;
            }
            case 9: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
            case 10: {
                return this.predisablePassword;
            }
            case 11: {
                return this.created;
            }
            case 12: {
                return this.useInbox;
            }
            case 13: {
                return this.trashEmailRetention == -1 ? null : Integer.valueOf(this.trashEmailRetention);
            }
            case 14: {
                return this.junkEmailRetention == -1 ? null : Integer.valueOf(this.junkEmailRetention);
            }
            case 15: {
                return this.saIntegrationMode;
            }
            case 16: {
                return Float.valueOf(this.saRequiredScore);
            }
            case 17: {
                return this.saDiscardScore == -1 ? null : Integer.valueOf(this.saDiscardScore);
            }
            case 18: {
                return this.sudo;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public List<CvsRepository> getCvsRepositories() throws IOException, SQLException {
        return this.table.getConnector().getScm().getCvsRepository().getCvsRepositories(this);
    }

    public List<AttachmentBlock> getEmailAttachmentBlocks() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getAttachmentBlock().getEmailAttachmentBlocks(this);
    }

    public String getAutoresponderContent() throws IOException, SQLException {
        String content = this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_AUTORESPONDER_CONTENT, this.pkey);
        if (content.length() == 0) {
            return null;
        }
        return content;
    }

    public InboxAddress getAutoresponderFrom() throws IOException, SQLException {
        if (this.autoresponderFrom == -1) {
            return null;
        }
        return this.table.getConnector().getEmail().getInboxAddress().get(this.autoresponderFrom);
    }

    public String getAutoresponderSubject() {
        return this.autoresponderSubject;
    }

    public String getAutoresponderPath() {
        return this.autoresponderPath;
    }

    public boolean isAutoresponderEnabled() {
        return this.isAutoresponderEnabled;
    }

    public String getCronTable() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_CRON_TABLE, this.pkey);
    }

    public static PosixPath getDefaultHomeDirectory(User.Name username) {
        try {
            return PosixPath.valueOf("/home/" + username);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PosixPath getHashedHomeDirectory(User.Name username) {
        try {
            String usernameStr = username.toString();
            return PosixPath.valueOf("/home/" + usernameStr.charAt(0) + '/' + usernameStr);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public List<Address> getEmailAddresses() throws SQLException, IOException {
        return this.table.getConnector().getEmail().getInboxAddress().getEmailAddresses(this);
    }

    public List<SharedTomcat> getHttpdSharedTomcats() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcat().getHttpdSharedTomcats(this);
    }

    public List<Site> getHttpdSites() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getSite().getHttpdSites(this);
    }

    public InboxAttributes getInboxAttributes() throws IOException, SQLException {
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.GET_INBOX_ATTRIBUTES, new AoservConnector.ResultRequest<InboxAttributes>(){
            private InboxAttributes result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(UserServer.this.pkey);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                InboxAttributes attr;
                byte code = in.readByte();
                if (code == 1) {
                    if (in.readBoolean()) {
                        attr = new InboxAttributes(UserServer.this.table.getConnector(), UserServer.this);
                        attr.read(in, AoservProtocol.Version.CURRENT_VERSION);
                    } else {
                        attr = null;
                    }
                } else {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.result = attr;
            }

            @Override
            public InboxAttributes afterRelease() {
                return this.result;
            }
        });
    }

    public long[] getImapFolderSizes(final String[] folderNames) throws IOException, SQLException {
        final long[] sizes = new long[folderNames.length];
        if (sizes.length > 0) {
            this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.GET_IMAP_FOLDER_SIZES, new AoservConnector.UpdateRequest(){

                @Override
                public void writeRequest(StreamableOutput out) throws IOException {
                    out.writeCompressedInt(UserServer.this.pkey);
                    out.writeCompressedInt(folderNames.length);
                    for (String folderName : folderNames) {
                        out.writeUTF(folderName);
                    }
                }

                @Override
                public void readResponse(StreamableInput in) throws IOException, SQLException {
                    byte code = in.readByte();
                    if (code == 1) {
                        for (int c = 0; c < folderNames.length; ++c) {
                            sizes[c] = in.readLong();
                        }
                    } else {
                        AoservProtocol.checkResult(code, in);
                        throw new IOException("Unexpected response code: " + code);
                    }
                }

                @Override
                public void afterRelease() {
                }
            });
        }
        return sizes;
    }

    public List<InboxAddress> getLinuxAccAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getInboxAddress().getLinuxAccAddresses(this);
    }

    public PosixPath getHome() {
        return this.home;
    }

    public User.Name getLinuxAccount_username_id() {
        return this.username;
    }

    public User getLinuxAccount() throws SQLException, IOException {
        User linuxAccountObject = this.table.getConnector().getLinux().getUser().get(this.username);
        if (linuxAccountObject == null) {
            throw new SQLException("Unable to find LinuxAccount: " + this.username);
        }
        return linuxAccountObject;
    }

    public String getPredisablePassword() {
        return this.predisablePassword;
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public boolean useInbox() {
        return this.useInbox;
    }

    public int getTrashEmailRetention() {
        return this.trashEmailRetention;
    }

    public int getJunkEmailRetention() {
        return this.junkEmailRetention;
    }

    public SpamAssassinMode getEmailSpamAssassinIntegrationMode() throws SQLException, IOException {
        SpamAssassinMode esaim = this.table.getConnector().getEmail().getSpamAssassinMode().get(this.saIntegrationMode);
        if (esaim == null) {
            throw new SQLException("Unable to find EmailSpamAssassinIntegrationMode: " + this.saIntegrationMode);
        }
        return esaim;
    }

    public float getSpamAssassinRequiredScore() {
        return this.saRequiredScore;
    }

    public int getSpamAssassinDiscardScore() {
        return this.saDiscardScore;
    }

    public String getSudo() {
        return this.sudo;
    }

    public GroupServer getPrimaryLinuxServerGroup() throws SQLException, IOException {
        return this.table.getConnector().getLinux().getGroupServer().getPrimaryLinuxServerGroup(this);
    }

    public int getAoServer_server_id() {
        return this.aoServer;
    }

    public Server getServer() throws SQLException, IOException {
        Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_SERVER_ACCOUNTS;
    }

    public LinuxId getUid() {
        return this.uid;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.username = User.Name.valueOf(result.getString(pos++));
            this.aoServer = result.getInt(pos++);
            this.uid = LinuxId.valueOf(result.getInt(pos++));
            this.home = PosixPath.valueOf(result.getString(pos++));
            this.autoresponderFrom = result.getInt(pos++);
            if (result.wasNull()) {
                this.autoresponderFrom = -1;
            }
            this.autoresponderSubject = result.getString(pos++);
            this.autoresponderPath = result.getString(pos++);
            this.isAutoresponderEnabled = result.getBoolean(pos++);
            this.disableLog = result.getInt(pos++);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
            this.predisablePassword = result.getString(pos++);
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.useInbox = result.getBoolean(pos++);
            this.trashEmailRetention = result.getInt(pos++);
            if (result.wasNull()) {
                this.trashEmailRetention = -1;
            }
            this.junkEmailRetention = result.getInt(pos++);
            if (result.wasNull()) {
                this.junkEmailRetention = -1;
            }
            this.saIntegrationMode = result.getString(pos++);
            this.saRequiredScore = result.getFloat(pos++);
            this.saDiscardScore = result.getInt(pos++);
            if (result.wasNull()) {
                this.saDiscardScore = -1;
            }
            this.sudo = result.getString(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public int isProcmailManual() throws IOException, SQLException {
        return this.table.getConnector().requestIntQuery(true, AoservProtocol.CommandId.IS_LINUX_SERVER_ACCOUNT_PROCMAIL_MANUAL, this.pkey);
    }

    @Override
    public int arePasswordsSet() throws IOException, SQLException {
        return this.table.getConnector().requestBooleanQuery(true, AoservProtocol.CommandId.IS_LINUX_SERVER_ACCOUNT_PASSWORD_SET, this.pkey) ? 2 : 0;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.username = User.Name.valueOf(in.readUTF()).intern();
            this.aoServer = in.readCompressedInt();
            this.uid = LinuxId.valueOf(in.readCompressedInt());
            this.home = PosixPath.valueOf(in.readUTF());
            this.autoresponderFrom = in.readCompressedInt();
            this.autoresponderSubject = in.readNullUTF();
            this.autoresponderPath = in.readNullUTF();
            this.isAutoresponderEnabled = in.readBoolean();
            this.disableLog = in.readCompressedInt();
            this.predisablePassword = in.readNullUTF();
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.useInbox = in.readBoolean();
            this.trashEmailRetention = in.readCompressedInt();
            this.junkEmailRetention = in.readCompressedInt();
            this.saIntegrationMode = in.readUTF().intern();
            this.saRequiredScore = in.readFloat();
            this.saDiscardScore = in.readCompressedInt();
            this.sudo = in.readNullUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<com.aoindustries.aoserv.client.email.List> getEmailLists() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getList().getEmailLists(this);
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList reasons = new ArrayList();
        LinuxId uidMin = this.getServer().getUidMin();
        if (this.uid.compareTo(uidMin) < 0) {
            reasons.add(new CannotRemoveReason<UserServer>("Not allowed to remove accounts with UID less than " + uidMin, this));
        }
        Server ao = this.getServer();
        for (CvsRepository cr : ao.getCvsRepositories()) {
            if (cr.getLinuxServerAccount_pkey() != this.pkey) continue;
            reasons.add(new CannotRemoveReason<CvsRepository>("Used by CVS repository " + cr.getPath() + " on " + cr.getLinuxServerAccount().getServer().getHostname(), cr));
        }
        for (com.aoindustries.aoserv.client.email.List el : this.getEmailLists()) {
            reasons.add(new CannotRemoveReason<com.aoindustries.aoserv.client.email.List>("Used by email list " + el.getPath() + " on " + el.getLinuxServerAccount().getServer().getHostname(), el));
        }
        for (HttpdServer hs : ao.getHttpdServers()) {
            if (hs.getLinuxServerAccount_pkey() != this.pkey) continue;
            String name = hs.getName();
            reasons.add(new CannotRemoveReason<HttpdServer>(name == null ? "Used by Apache HTTP Server on " + hs.getLinuxServer().getHostname() : "Used by Apache HTTP Server (" + name + ") on " + hs.getLinuxServer().getHostname(), hs));
        }
        for (SharedTomcat hst : ao.getHttpdSharedTomcats()) {
            if (hst.getLinuxServerAccount_pkey() != this.pkey) continue;
            reasons.add(new CannotRemoveReason<SharedTomcat>("Used by Multi-Site Tomcat JVM " + hst.getInstallDirectory() + " on " + hst.getLinuxServer().getHostname(), hst));
        }
        for (MajordomoServer ms : ao.getMajordomoServers()) {
            if (ms.getLinuxServerAccount_pkey() != this.pkey) continue;
            Domain ed = ms.getDomain();
            reasons.add(new CannotRemoveReason<MajordomoServer>("Used by Majordomo server " + ed.getDomain() + " on " + ed.getLinuxServer().getHostname(), ms));
        }
        for (PrivateServer pfs : ao.getPrivateFtpServers()) {
            if (pfs.getLinuxServerAccount_pkey() != this.pkey) continue;
            UserServer lsa = pfs.getLinuxServerAccount();
            reasons.add(new CannotRemoveReason<PrivateServer>("Used by private FTP server " + lsa.getHome() + " on " + lsa.getServer().getHostname(), pfs));
        }
        for (Site site : ao.getHttpdSites()) {
            if (!site.getLinuxAccount_username().equals(this.username)) continue;
            reasons.add(new CannotRemoveReason<Site>("Used by website " + site.getInstallDirectory() + " on " + site.getLinuxServer().getHostname(), site));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.LINUX_SERVER_ACCOUNTS, this.pkey});
    }

    public void setCronTable(String cronTable) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_CRON_TABLE, this.pkey, cronTable);
    }

    @Override
    public void setPassword(String password) throws IOException, SQLException {
        AoservConnector connector = this.table.getConnector();
        if (!connector.isSecure()) {
            throw new IOException("Passwords for linux accounts may only be set when using secure protocols.  Currently using the " + connector.getProtocol() + " protocol, which is not secure.");
        }
        connector.requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_SERVER_ACCOUNT_PASSWORD, this.pkey, password);
    }

    public void setAutoresponder(final InboxAddress from, final String subject, final String content, final boolean enabled) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_AUTORESPONDER, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(UserServer.this.pkey);
                out.writeCompressedInt(from == null ? -1 : from.getPkey());
                out.writeBoolean(subject != null);
                if (subject != null) {
                    out.writeUTF(subject);
                }
                out.writeBoolean(content != null);
                if (content != null) {
                    out.writeUTF(content);
                }
                out.writeBoolean(enabled);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                UserServer.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    public void setTrashEmailRetention(int days) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_SERVER_ACCOUNT_TRASH_EMAIL_RETENTION, this.pkey, days);
    }

    public void setJunkEmailRetention(int days) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_SERVER_ACCOUNT_JUNK_EMAIL_RETENTION, this.pkey, days);
    }

    public void setEmailSpamAssassinIntegrationMode(SpamAssassinMode mode) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_SERVER_ACCOUNT_EMAIL_SPAMASSASSIN_INTEGRATION_MODE, this.pkey, mode.getName());
    }

    public void setSpamAssassinRequiredScore(float requiredScore) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_SERVER_ACCOUNT_SPAMASSASSIN_REQUIRED_SCORE, this.pkey, Float.valueOf(requiredScore));
    }

    public void setSpamAssassinDiscardScore(int discardScore) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_SERVER_ACCOUNT_SPAMASSASSIN_DISCARD_SCORE, this.pkey, discardScore);
    }

    public void setUseInbox(boolean useInbox) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_LINUX_SERVER_ACCOUNT_USE_INBOX, this.pkey, useInbox);
    }

    public void setPredisablePassword(final String password) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_LINUX_SERVER_ACCOUNT_PREDISABLE_PASSWORD, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(UserServer.this.pkey);
                out.writeNullUTF(password);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                UserServer.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.username + " on " + this.getServer().getHostname();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.username.toString());
        out.writeCompressedInt(this.aoServer);
        out.writeCompressedInt(this.uid.getId());
        out.writeUTF(this.home.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeShort(0);
            out.writeShort(7);
            out.writeShort(0);
            out.writeShort(7);
            out.writeShort(0);
            out.writeShort(7);
        }
        out.writeCompressedInt(this.autoresponderFrom);
        out.writeNullUTF(this.autoresponderSubject);
        out.writeNullUTF(this.autoresponderPath);
        out.writeBoolean(this.isAutoresponderEnabled);
        out.writeCompressedInt(this.disableLog);
        out.writeNullUTF(this.predisablePassword);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        out.writeBoolean(this.useInbox);
        out.writeCompressedInt(this.trashEmailRetention);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_120) >= 0) {
            out.writeCompressedInt(this.junkEmailRetention);
            out.writeUTF(this.saIntegrationMode);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_124) >= 0) {
            out.writeFloat(this.saRequiredScore);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_40) >= 0) {
            out.writeCompressedInt(this.saDiscardScore);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80_1) >= 0) {
            out.writeNullUTF(this.sudo);
        }
    }

    @Override
    public boolean canSetPassword() throws IOException, SQLException {
        return this.disableLog == -1 && this.getLinuxAccount().canSetPassword();
    }

    public boolean passwordMatches(String password) throws IOException, SQLException {
        return this.table.getConnector().requestBooleanQuery(true, AoservProtocol.CommandId.COMPARE_LINUX_SERVER_ACCOUNT_PASSWORD, this.pkey, password);
    }

    public int addEmailAddress(Address address) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getInboxAddress().addLinuxAccAddress(address, this);
    }
}

