/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.net.DomainName;
import com.aoapps.sql.SQLUtility;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.InboxAttributes;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.GroupUser;
import com.aoindustries.aoserv.client.linux.LinuxId;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public final class UserServerTable
extends CachedTableIntegerKey<UserServer> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("username", true), new AoservTable.OrderBy("ao_server.hostname", true)};
    private boolean nameHashBuilt;
    private final Map<Integer, Map<User.Name, UserServer>> nameHash = new HashMap<Integer, Map<User.Name, UserServer>>();
    private boolean uidHashBuilt;
    private final Map<Integer, Map<LinuxId, UserServer>> uidHash = new HashMap<Integer, Map<LinuxId, UserServer>>();

    UserServerTable(AoservConnector connector) {
        super(connector, UserServer.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addLinuxServerAccount(User linuxAccount, Server aoServer, PosixPath home) throws IOException, SQLException {
        int pkey = this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.LINUX_SERVER_ACCOUNTS, linuxAccount.getUsername_id(), aoServer.getPkey(), home});
        return pkey;
    }

    int addSystemUser(Server aoServer, User.Name username, int uid, int gid, User.Gecos fullName, User.Gecos officeLocation, User.Gecos officePhone, User.Gecos homePhone, PosixPath home, PosixPath shell) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD_SYSTEM_USER, aoServer.getPkey(), username, uid, gid, fullName == null ? "" : fullName.toString(), officeLocation == null ? "" : officeLocation.toString(), officePhone == null ? "" : officePhone.toString(), homePhone == null ? "" : homePhone.toString(), home, shell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Map<Integer, Map<Comparable<LinuxId>, UserServer>> map = this.uidHash;
        synchronized (map) {
            this.uidHashBuilt = false;
        }
        map = this.nameHash;
        synchronized (map) {
            this.nameHashBuilt = false;
        }
    }

    @Override
    public UserServer get(int pkey) throws IOException, SQLException {
        return (UserServer)this.getUniqueRow(0, pkey);
    }

    List<UserServer> getAlternateLinuxServerAccounts(GroupServer group) throws SQLException, IOException {
        Server aoServer = group.getServer();
        int osv = aoServer.getHost().getOperatingSystemVersion_id();
        Group.Name groupName = group.getLinuxGroup().getName();
        List rows = this.getRows();
        int cachedLen = rows.size();
        ArrayList<UserServer> matches = new ArrayList<UserServer>(cachedLen);
        block0: for (int c = 0; c < cachedLen; ++c) {
            UserServer linuxServerAccount = (UserServer)rows.get(c);
            if (linuxServerAccount.getAoServer_server_id() != aoServer.getPkey()) continue;
            User.Name username = linuxServerAccount.getLinuxAccount_username_id();
            for (GroupUser lga : this.connector.getLinux().getGroupUser().getLinuxGroupAccounts(groupName, username)) {
                if (lga.isPrimary() || lga.getOperatingSystemVersion_pkey() != null && lga.getOperatingSystemVersion_pkey() != osv) continue;
                matches.add(linuxServerAccount);
                continue block0;
            }
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserServer getLinuxServerAccount(Server aoServer, User.Name username) throws IOException, SQLException {
        Map<Integer, Map<User.Name, UserServer>> map = this.nameHash;
        synchronized (map) {
            Map<User.Name, UserServer> serverHash;
            if (!this.nameHashBuilt) {
                this.nameHash.clear();
                List list = this.getRows();
                int len = list.size();
                for (int c = 0; c < len; ++c) {
                    UserServer lsa = (UserServer)list.get(c);
                    Integer i = lsa.getServer().getPkey();
                    Map<User.Name, UserServer> serverHash2 = this.nameHash.get(i);
                    if (serverHash2 == null) {
                        serverHash2 = new HashMap<User.Name, UserServer>();
                        this.nameHash.put(i, serverHash2);
                    }
                    if (serverHash2.put(lsa.getLinuxAccount_username_id(), lsa) == null) continue;
                    throw new SQLException("LinuxServerAccount username exists more than once on server: " + lsa.getLinuxAccount_username_id() + " on " + i);
                }
                this.nameHashBuilt = true;
            }
            if ((serverHash = this.nameHash.get(aoServer.getPkey())) == null) {
                return null;
            }
            return serverHash.get(username);
        }
    }

    public UserServer getLinuxServerAccountFromUsernamePassword(User.Name username, String password, boolean emailOnly) throws LoginException, IOException, SQLException {
        List list = this.getRows();
        UserServer badPasswordLsa = null;
        UserServer disabledLsa = null;
        int len = list.size();
        for (int c = 0; c < len; ++c) {
            UserServer account = (UserServer)list.get(c);
            if (!account.getLinuxAccount_username_id().equals(username) || emailOnly && !account.getLinuxAccount().getType().isEmail()) continue;
            if (account.isDisabled()) {
                if (disabledLsa != null) continue;
                disabledLsa = account;
                continue;
            }
            if (account.passwordMatches(password)) {
                return account;
            }
            if (badPasswordLsa != null) continue;
            badPasswordLsa = account;
        }
        if (badPasswordLsa != null) {
            throw new FailedLoginException("The password does not match the password for the \"" + badPasswordLsa.getLinuxAccount().getUsername().getUsername() + "\" account on the \"" + badPasswordLsa.getServer().getHostname() + "\" server.");
        }
        if (disabledLsa != null) {
            String reason;
            DisableLog dl = disabledLsa.getDisableLog();
            String string = reason = dl == null ? null : dl.getDisableReason();
            if (reason == null) {
                throw new AccountLockedException("The \"" + disabledLsa.getLinuxAccount().getUsername().getUsername() + "\" account on the \"" + disabledLsa.getServer().getHostname() + "\" server has been disabled for an unspecified reason.");
            }
            throw new AccountLockedException("The \"" + disabledLsa.getLinuxAccount().getUsername().getUsername() + "\" account on the \"" + disabledLsa.getServer().getHostname() + "\" server has been disabled for the following reason: " + reason);
        }
        return null;
    }

    public UserServer getLinuxServerAccountFromEmailAddress(String address, DomainName domain, String password) throws LoginException, IOException, SQLException {
        UserServer badPasswordLsa = null;
        UserServer disabledLsa = null;
        List domains = this.connector.getEmail().getDomain().getRows();
        int domainsLen = domains.size();
        for (int c = 0; c < domainsLen; ++c) {
            Domain ed = (Domain)domains.get(c);
            if (!ed.getDomain().equals((Object)domain)) continue;
            Server ao = ed.getLinuxServer();
            Address ea = ed.getEmailAddress(address);
            if (ea == null) continue;
            List<UserServer> lsas = ea.getLinuxServerAccounts();
            int lsasLen = lsas.size();
            for (int d = 0; d < lsasLen; ++d) {
                UserServer lsa = lsas.get(d);
                if (lsa.isDisabled()) {
                    if (disabledLsa != null) continue;
                    disabledLsa = lsa;
                    continue;
                }
                if (lsa.passwordMatches(password)) {
                    return lsa;
                }
                if (badPasswordLsa != null) continue;
                badPasswordLsa = lsa;
            }
        }
        if (badPasswordLsa != null) {
            throw new FailedLoginException("The \"" + address + "@" + domain + "\" address resolves to the \"" + badPasswordLsa.getLinuxAccount().getUsername().getUsername() + "\" account on the \"" + badPasswordLsa.getServer().getHostname() + "\" server, but the password does not match.");
        }
        if (disabledLsa != null) {
            String reason;
            DisableLog dl = disabledLsa.getDisableLog();
            String string = reason = dl == null ? null : dl.getDisableReason();
            if (reason == null) {
                throw new AccountLockedException("The \"" + address + "@" + domain + "\" address resolves to the \"" + disabledLsa.getLinuxAccount().getUsername().getUsername() + "\" account on the \"" + disabledLsa.getServer().getHostname() + "\" server, but the account has been disabled for an unspecified reason.");
            }
            throw new AccountLockedException("The \"" + address + "@" + domain + "\" address resolves to the \"" + disabledLsa.getLinuxAccount().getUsername().getUsername() + "\" account on the \"" + disabledLsa.getServer().getHostname() + "\" server, but the account has been disabled for the following reason: " + reason);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserServer getLinuxServerAccount(Server aoServer, LinuxId uid) throws IOException, SQLException {
        Map<Integer, Map<LinuxId, UserServer>> map = this.uidHash;
        synchronized (map) {
            Map<LinuxId, UserServer> serverHash;
            if (!this.uidHashBuilt) {
                this.uidHash.clear();
                List list = this.getRows();
                int len = list.size();
                for (int c = 0; c < len; ++c) {
                    LinuxId i;
                    UserServer lsa = (UserServer)list.get(c);
                    LinuxId lsaUid = lsa.getUid();
                    if (lsaUid.getId() == 0 && !lsa.getLinuxAccount_username_id().equals(User.ROOT)) continue;
                    Integer aoI = lsa.getServer().getPkey();
                    Map<LinuxId, UserServer> serverHash2 = this.uidHash.get(aoI);
                    if (serverHash2 == null) {
                        serverHash2 = new HashMap<LinuxId, UserServer>();
                        this.uidHash.put(aoI, serverHash2);
                    }
                    if (serverHash2.containsKey(i = lsaUid)) continue;
                    serverHash2.put(i, lsa);
                }
                this.uidHashBuilt = true;
            }
            if ((serverHash = this.uidHash.get(aoServer.getPkey())) == null) {
                return null;
            }
            return serverHash.get(uid);
        }
    }

    List<UserServer> getLinuxServerAccounts(User linuxAccount) throws IOException, SQLException {
        return this.getIndexedRows(1, linuxAccount.getUsername_id());
    }

    List<UserServer> getLinuxServerAccounts(Server aoServer) throws IOException, SQLException {
        return this.getIndexedRows(2, aoServer.getPkey());
    }

    public List<UserServer> getMailAccounts() throws IOException, SQLException {
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<UserServer> matches = new ArrayList<UserServer>(len);
        for (int c = 0; c < len; ++c) {
            UserServer lsa = (UserServer)cached.get(c);
            if (!lsa.getLinuxAccount().getType().isEmail()) continue;
            matches.add(lsa);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_SERVER_ACCOUNTS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_linux_server_account")) {
            if (Aosh.checkParamCount("add_linux_server_account", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addLinuxServerAccount(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3].isEmpty() ? null : Aosh.parseUnixPath(args[3], "home_directory")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("compare_linux_server_account_password")) {
            if (Aosh.checkParamCount("compare_linux_server_account_password", args, 3, (PrintWriter)err)) {
                boolean result = this.connector.getSimpleClient().compareLinuxServerAccountPassword(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3]);
                out.println(result);
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("copy_home_directory")) {
            if (Aosh.checkParamCount("copy_home_directory", args, 3, (PrintWriter)err)) {
                long byteCount = this.connector.getSimpleClient().copyHomeDirectory(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3]);
                if (isInteractive) {
                    out.print(byteCount);
                    out.println(byteCount == 1L ? " byte" : " bytes");
                } else {
                    out.println(byteCount);
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("copy_linux_server_account_password")) {
            if (Aosh.checkParamCount("copy_linux_server_account_password", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().copyLinuxServerAccountPassword(Aosh.parseLinuxUserName(args[1], "from_username"), args[2], Aosh.parseLinuxUserName(args[3], "to_username"), args[4]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_linux_server_account")) {
            if (Aosh.checkParamCount("disable_linux_server_account", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableLinuxServerAccount(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_linux_server_account")) {
            if (Aosh.checkParamCount("enable_linux_server_account", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableLinuxServerAccount(Aosh.parseLinuxUserName(args[1], "username"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_cron_table")) {
            if (Aosh.checkParamCount("get_cron_table", args, 2, (PrintWriter)err)) {
                out.print(this.connector.getSimpleClient().getCronTable(Aosh.parseLinuxUserName(args[1], "username"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_imap_folder_sizes")) {
            if (Aosh.checkMinParamCount("get_imap_folder_sizes", args, 3, (PrintWriter)err)) {
                String[] folderNames = new String[args.length - 3];
                System.arraycopy(args, 3, folderNames, 0, folderNames.length);
                long[] sizes = this.connector.getSimpleClient().getImapFolderSizes(Aosh.parseLinuxUserName(args[1], "username"), args[2], folderNames);
                for (int c = 0; c < folderNames.length; ++c) {
                    out.print(folderNames[c]);
                    out.print('\t');
                    out.print(sizes[c]);
                    out.println();
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_inbox_attributes")) {
            if (Aosh.checkParamCount("get_inbox_attributes", args, 2, (PrintWriter)err)) {
                InboxAttributes attr = this.connector.getSimpleClient().getInboxAttributes(Aosh.parseLinuxUserName(args[1], "username"), args[2]);
                out.print("System Time..: ");
                out.println(attr == null ? "Server Unavailable" : SQLUtility.formatDateTime((long)attr.getSystemTime()));
                out.print("File Size....: ");
                out.println(attr == null ? "Server Unavailable" : Long.valueOf(attr.getFileSize()));
                out.print("Last Modified: ");
                if (attr == null) {
                    out.println("Server Unavailable");
                } else {
                    long lastModified = attr.getLastModified();
                    if (lastModified == 0L) {
                        out.println("Unknown");
                    } else {
                        out.println(SQLUtility.formatDateTime((long)lastModified));
                    }
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_linux_server_account_password_set")) {
            if (Aosh.checkParamCount("is_linux_server_account_password_set", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().isLinuxServerAccountPasswordSet(Aosh.parseLinuxUserName(args[1], "username"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_linux_server_account_procmail_manual")) {
            if (Aosh.checkParamCount("is_linux_server_account_procmail_manual", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().isLinuxServerAccountProcmailManual(Aosh.parseLinuxUserName(args[1], "username"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_linux_server_account")) {
            if (Aosh.checkParamCount("remove_linux_server_account", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeLinuxServerAccount(Aosh.parseLinuxUserName(args[1], "username"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_autoresponder")) {
            if (Aosh.checkParamCount("set_autoresponder", args, 7, (PrintWriter)err)) {
                this.connector.getSimpleClient().setAutoresponder(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3], args[4].length() == 0 ? null : Aosh.parseDomainName(args[4], "from_domain"), args[5], args[6], Aosh.parseBoolean(args[7], "enabled"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_cron_table")) {
            if (Aosh.checkParamCount("set_cron_table", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setCronTable(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_server_account_junk_email_retention")) {
            if (Aosh.checkParamCount("set_linux_server_account_junk_email_retention", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxServerAccountJunkEmailRetention(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3] == null || args[3].length() == 0 ? -1 : Aosh.parseInt(args[3], "junk_email_retention"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_server_account_password")) {
            if (Aosh.checkParamCount("set_linux_server_account_password", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxServerAccountPassword(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_server_account_spamassassin_integration_mode")) {
            if (Aosh.checkParamCount("set_linux_server_account_spamassassin_integration_mode", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxServerAccountSpamAssassinIntegrationMode(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_server_account_spamassassin_required_score")) {
            if (Aosh.checkParamCount("set_linux_server_account_spamassassin_required_score", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxServerAccountSpamAssassinRequiredScore(Aosh.parseLinuxUserName(args[1], "username"), args[2], Aosh.parseFloat(args[3], "required_score"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_server_account_trash_email_retention")) {
            if (Aosh.checkParamCount("set_linux_server_account_trash_email_retention", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxServerAccountTrashEmailRetention(Aosh.parseLinuxUserName(args[1], "username"), args[2], args[3] == null || args[3].length() == 0 ? -1 : Aosh.parseInt(args[3], "trash_email_retention"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_server_account_use_inbox")) {
            if (Aosh.checkParamCount("set_linux_server_account_use_inbox", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxServerAccountUseInbox(Aosh.parseLinuxUserName(args[1], "username"), args[2], Aosh.parseBoolean(args[3], "use_inbox"));
            }
            return true;
        }
        return false;
    }

    boolean isHomeUsed(Server aoServer, PosixPath directory) throws IOException, SQLException {
        int pkey = aoServer.getPkey();
        String directoryStr = directory.toString();
        String startsWith = directoryStr + '/';
        List cached = this.getRows();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            PosixPath home;
            UserServer lsa = (UserServer)cached.get(c);
            if (lsa.getAoServer_server_id() != pkey || !(home = lsa.getHome()).equals(directory) && !home.toString().startsWith(startsWith)) continue;
            return true;
        }
        return false;
    }
}

