/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.linux.CachedTableUserNameKey;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class UserTable
extends CachedTableUserNameKey<User> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("username", true)};

    UserTable(AoservConnector connector) {
        super(connector, User.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public void addLinuxAccount(final com.aoindustries.aoserv.client.account.User usernameObject, final Group.Name primaryGroup, final User.Gecos name, final User.Gecos officeLocation, final User.Gecos officePhone, final User.Gecos homePhone, final String type, final PosixPath shell) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.ADD, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.LINUX_ACCOUNTS.ordinal());
                out.writeUTF(usernameObject.getUsername().toString());
                out.writeUTF(primaryGroup.toString());
                out.writeNullUTF(Objects.toString(name, null));
                out.writeNullUTF(Objects.toString(officeLocation, null));
                out.writeNullUTF(Objects.toString(officePhone, null));
                out.writeNullUTF(Objects.toString(homePhone, null));
                out.writeUTF(type);
                out.writeUTF(shell.toString());
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                UserTable.this.connector.tablesUpdated(this.invalidateList);
            }
        });
    }

    @Override
    public User get(User.Name username) throws IOException, SQLException {
        return (User)this.getUniqueRow(0, username);
    }

    public List<User> getMailAccounts() throws IOException, SQLException {
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<User> matches = new ArrayList<User>(len);
        for (int c = 0; c < len; ++c) {
            User linuxAccount = (User)cached.get(c);
            if (!linuxAccount.getType().isEmail()) continue;
            matches.add(linuxAccount);
        }
        return matches;
    }

    public List<User> getMailAccounts(Account business) throws IOException, SQLException {
        Account.Name accounting = business.getName();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<User> matches = new ArrayList<User>(len);
        for (int c = 0; c < len; ++c) {
            User linuxAccount = (User)cached.get(c);
            if (!linuxAccount.getType().isEmail() || !linuxAccount.getUsername().getPackage().getAccount_name().equals(accounting)) continue;
            matches.add(linuxAccount);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_ACCOUNTS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_linux_account")) {
            if (Aosh.checkParamCount("add_linux_account", args, 8, (PrintWriter)err)) {
                this.connector.getSimpleClient().addLinuxAccount(Aosh.parseLinuxUserName(args[1], "username"), Aosh.parseGroupName(args[2], "primary_group"), args[3].isEmpty() ? null : Aosh.parseGecos(args[3], "full_name"), args[4].isEmpty() ? null : Aosh.parseGecos(args[4], "office_location"), args[5].isEmpty() ? null : Aosh.parseGecos(args[5], "office_phone"), args[6].isEmpty() ? null : Aosh.parseGecos(args[6], "home_phone"), args[7], Aosh.parseUnixPath(args[8], "shell"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("are_linux_account_passwords_set")) {
            if (Aosh.checkParamCount("are_linux_account_passwords_set", args, 1, (PrintWriter)err)) {
                int result = this.connector.getSimpleClient().areLinuxAccountPasswordsSet(Aosh.parseLinuxUserName(args[1], "username"));
                if (result == 0) {
                    out.println("none");
                } else if (result == 1) {
                    out.println("some");
                } else if (result == 2) {
                    out.println("all");
                } else {
                    throw new RuntimeException("Unexpected value for result: " + result);
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_linux_account_name")) {
            if (Aosh.checkParamCount("check_linux_account_name", args, 1, (PrintWriter)err)) {
                ValidationResult validationResult = User.Gecos.validate(args[1]);
                out.println(validationResult.isValid());
                out.flush();
                if (!validationResult.isValid()) {
                    err.print("aosh: check_linux_account_name: ");
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_linux_account_password")) {
            List<PasswordChecker.Result> results;
            if (Aosh.checkParamCount("check_linux_account_password", args, 2, (PrintWriter)err) && PasswordChecker.hasResults(results = this.connector.getSimpleClient().checkLinuxAccountPassword(Aosh.parseLinuxUserName(args[1], "username"), args[2]))) {
                PasswordChecker.printResults(results, (Appendable)out);
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_linux_account")) {
            if (Aosh.checkParamCount("disable_linux_account", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableLinuxAccount(Aosh.parseLinuxUserName(args[1], "username"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_linux_account")) {
            if (Aosh.checkParamCount("enable_linux_account", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableLinuxAccount(Aosh.parseLinuxUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("generate_password")) {
            if (Aosh.checkParamCount("generate_password", args, 0, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().generatePassword());
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_linux_account")) {
            if (Aosh.checkParamCount("remove_linux_account", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeLinuxAccount(Aosh.parseLinuxUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_account_home_phone")) {
            if (Aosh.checkParamCount("set_linux_account_home_phone", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxAccountHomePhone(Aosh.parseLinuxUserName(args[1], "username"), args[2].isEmpty() ? null : Aosh.parseGecos(args[2], "phone_number"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_account_name")) {
            if (Aosh.checkParamCount("set_linux_account_name", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxAccountName(Aosh.parseLinuxUserName(args[1], "username"), args[2].isEmpty() ? null : Aosh.parseGecos(args[2], "full_name"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_account_office_location")) {
            if (Aosh.checkParamCount("set_linux_account_office_location", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxAccountOfficeLocation(Aosh.parseLinuxUserName(args[1], "username"), args[2].isEmpty() ? null : Aosh.parseGecos(args[2], "location"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_account_office_phone")) {
            if (Aosh.checkParamCount("set_linux_account_office_phone", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxAccountOfficePhone(Aosh.parseLinuxUserName(args[1], "username"), args[2].isEmpty() ? null : Aosh.parseGecos(args[2], "phone_number"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_account_password")) {
            if (Aosh.checkParamCount("set_linux_account_password", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxAccountPassword(Aosh.parseLinuxUserName(args[1], "username"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_linux_account_shell")) {
            if (Aosh.checkParamCount("set_linux_account_shell", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setLinuxAccountShell(Aosh.parseLinuxUserName(args[1], "username"), Aosh.parseUnixPath(args[2], "shell"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("wait_for_linux_account_rebuild")) {
            if (Aosh.checkParamCount("wait_for_linux_account_rebuild", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().waitForLinuxAccountRebuild(args[1]);
            }
            return true;
        }
        return false;
    }

    void waitForRebuild(Server aoServer) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.WAIT_FOR_REBUILD, new Object[]{Table.TableId.LINUX_ACCOUNTS, aoServer.getPkey()});
    }
}

