/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.linux;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Shell;
import com.aoindustries.aoserv.client.linux.ShellTable;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class UserType
extends GlobalObjectStringKey<UserType> {
    static final int COLUMN_NAME = 0;
    static final String COLUMN_DESCRIPTION_name = "description";
    public static final String BACKUP = "backup";
    public static final String EMAIL = "email";
    public static final String FTPONLY = "ftponly";
    public static final String USER = "user";
    public static final String MERCENARY = "mercenary";
    public static final String SYSTEM = "system";
    public static final String APPLICATION = "application";
    private static final PosixPath[] backupShells = new PosixPath[]{Shell.BASH};
    private static final PosixPath[] emailShells = new PosixPath[]{Shell.PASSWD};
    private static final PosixPath[] ftpShells = new PosixPath[]{Shell.FTPONLY, Shell.FTPPASSWD};
    private static final PosixPath[] mercenaryShells = new PosixPath[]{Shell.BASH};
    private static final PosixPath[] systemShells = new PosixPath[]{Shell.BASH, Shell.FALSE, Shell.NOLOGIN, Shell.SYNC, Shell.HALT, Shell.SHUTDOWN};
    private static final PosixPath[] applicationShells = new PosixPath[]{Shell.BASH, Shell.FALSE};
    private static final PosixPath[] userShells = new PosixPath[]{Shell.BASH, Shell.FALSE, Shell.KSH, Shell.SH, Shell.TCSH, Shell.GIT_SHELL};
    private String description;
    private boolean isEmail;

    @Deprecated
    public UserType() {
    }

    public PasswordChecker.PasswordStrength getPasswordStrength() {
        return UserType.getPasswordStrength(this.pkey);
    }

    public static PasswordChecker.PasswordStrength getPasswordStrength(String type) {
        return type.equals(EMAIL) ? PasswordChecker.PasswordStrength.SUPER_LAX : PasswordChecker.PasswordStrength.STRICT;
    }

    public List<Shell> getAllowedShells(AoservConnector connector) throws SQLException, IOException {
        PosixPath[] paths = UserType.getShellList(this.pkey);
        ShellTable shellTable = connector.getLinux().getShell();
        int len = paths.length;
        ArrayList<Shell> shells = new ArrayList<Shell>(len);
        for (int c = 0; c < len; ++c) {
            Shell shell = shellTable.get(paths[c]);
            if (shell == null) {
                throw new SQLException("Unable to find Shell: " + paths[c]);
            }
            shells.add(shell);
        }
        return shells;
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.description;
        }
        if (i == 2) {
            return this.isEmail;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.pkey;
    }

    private static PosixPath[] getShellList(String type) throws SQLException {
        if (type.equals(BACKUP)) {
            return backupShells;
        }
        if (type.equals(EMAIL)) {
            return emailShells;
        }
        if (type.equals(FTPONLY)) {
            return ftpShells;
        }
        if (type.equals(USER)) {
            return userShells;
        }
        if (type.equals(MERCENARY)) {
            return mercenaryShells;
        }
        if (type.equals(SYSTEM)) {
            return systemShells;
        }
        if (type.equals(APPLICATION)) {
            return applicationShells;
        }
        throw new SQLException("Unknown type: " + type);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_ACCOUNT_TYPES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
        this.description = result.getString(2);
        this.isEmail = result.getBoolean(3);
    }

    public boolean canPostgresIdent() {
        return UserType.canPostgresIdent(this.pkey);
    }

    public static boolean canPostgresIdent(String type) {
        return APPLICATION.equals(type) || USER.equals(type);
    }

    public boolean isAllowedShell(Shell shell) throws SQLException {
        return this.isAllowedShell(shell.getPath());
    }

    public boolean isAllowedShell(PosixPath path) throws SQLException {
        return UserType.isAllowedShell(this.pkey, path);
    }

    public static boolean isAllowedShell(String type, PosixPath path) throws SQLException {
        PosixPath[] paths = UserType.getShellList(type);
        int len = paths.length;
        for (int c = 0; c < len; ++c) {
            if (!paths[c].equals(path)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmail() {
        return this.isEmail;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.description = in.readUTF();
        this.isEmail = in.readBoolean();
    }

    @Override
    public String toStringImpl() {
        return this.description;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeUTF(this.description);
        out.writeBoolean(this.isEmail);
    }

    public static boolean canSetPassword(String type) {
        return APPLICATION.equals(type) || EMAIL.equals(type) || FTPONLY.equals(type) || USER.equals(type);
    }

    public boolean canSetPassword() {
        return UserType.canSetPassword(this.pkey);
    }
}

