/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.master;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.master.Permission;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class AdministratorPermission
extends CachedObjectIntegerKey<AdministratorPermission> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_USERNAME = 1;
    static final String COLUMN_USERNAME_name = "username";
    static final String COLUMN_PERMISSION_name = "permission";
    private User.Name username;
    private String permission;

    @Deprecated
    public AdministratorPermission() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.username;
            }
            case 2: {
                return this.permission;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public User.Name getAdministrator_username() {
        return this.username;
    }

    public Administrator getAdministrator() throws SQLException, IOException {
        Administrator obj = this.table.getConnector().getAccount().getAdministrator().get(this.username);
        if (obj == null) {
            throw new SQLException("Unable to find Administrator: " + this.username);
        }
        return obj;
    }

    public String getAoservPermission_name() {
        return this.permission;
    }

    public Permission getAoservPermission() throws SQLException, IOException {
        Permission ap = this.table.getConnector().getMaster().getPermission().get(this.permission);
        if (ap == null) {
            throw new SQLException("Unable to find AoservPermission: " + this.permission);
        }
        return ap;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESS_ADMINISTRATOR_PERMISSIONS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.username = User.Name.valueOf(result.getString(2));
            this.permission = result.getString(3);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.username = User.Name.valueOf(in.readUTF()).intern();
            this.permission = in.readUTF().intern();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.username.toString());
        out.writeUTF(this.permission);
    }
}

