/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.master;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.master.AdministratorPermission;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public final class AdministratorPermissionTable
extends CachedTableIntegerKey<AdministratorPermission> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("username", true), new AoservTable.OrderBy("permission.sort_order", true)};
    private Map<User.Name, SortedSet<String>> cachedPermissions;

    AdministratorPermissionTable(AoservConnector connector) {
        super(connector, AdministratorPermission.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public AdministratorPermission get(int pkey) throws IOException, SQLException {
        return (AdministratorPermission)this.getUniqueRow(0, pkey);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BUSINESS_ADMINISTRATOR_PERMISSIONS;
    }

    public List<AdministratorPermission> getPermissions(Administrator ba) throws IOException, SQLException {
        return this.getIndexedRows(1, ba.getUsername_userId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        AdministratorPermissionTable administratorPermissionTable = this;
        synchronized (administratorPermissionTable) {
            this.cachedPermissions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(Administrator ba, String permission) throws IOException, SQLException {
        AdministratorPermissionTable administratorPermissionTable = this;
        synchronized (administratorPermissionTable) {
            if (this.cachedPermissions == null) {
                HashMap<User.Name, SortedSet<String>> newCachedPermissions = new HashMap<User.Name, SortedSet<String>>();
                List baps = this.getRows();
                for (AdministratorPermission bap : baps) {
                    User.Name bapUsername = bap.getAdministrator_username();
                    String bapPermission = bap.getAoservPermission_name();
                    TreeSet<String> perms = (TreeSet<String>)newCachedPermissions.get(bapUsername);
                    if (perms == null) {
                        perms = new TreeSet<String>();
                        newCachedPermissions.put(bapUsername, perms);
                    }
                    perms.add(bapPermission);
                }
                this.cachedPermissions = newCachedPermissions;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
            SortedSet<String> perms = this.cachedPermissions.get(ba.getUsername_userId());
            return perms != null && perms.contains(permission);
        }
    }
}

